/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiViewUtil;

public class WmiViewPosition {
    public static final int VIEW_START = 0;
    public static final int VIEW_END = -1;
    private WmiPositionedView view;
    private int offset;

    public WmiViewPosition(WmiPositionedView view, int offset) {
        this.view = view;
        this.offset = offset;
    }

    public WmiPositionedView getView() {
        return this.view;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean snapToPosition() {
        return this.snapToPosition(true);
    }

    public boolean snapToPosition(boolean updateMarker) {
        boolean done = false;
        WmiMathDocumentView docView = this.view.getDocumentView();
        WmiModel docModel = docView.getModel();
        boolean lock = !WmiModelLock.ownsWriteLock(docModel);
        try {
            if (lock) {
                WmiModelLock.readLock(docModel, true);
            }
            while (this.view instanceof WmiCompositeView) {
                int size;
                if (WmiViewUtil.isTraversableView(this.view) || (size = ((WmiCompositeView)((Object)this.view)).getChildCount()) <= 0) break;
                this.view = this.offset == -1 ? (WmiPositionedView)((WmiCompositeView)((Object)this.view)).getChild(size - 1) : (WmiPositionedView)((WmiCompositeView)((Object)this.view)).getChild(0);
            }
            if (updateMarker) {
                if (this.view instanceof WmiPositionedView) {
                    this.view.setPositionMarker(this.offset);
                } else if (docView != null) {
                    docView.setPositionMarker(null);
                }
            }
            if (docView != null) {
                WmiSelection selection;
                if (updateMarker && (selection = docView.getSelection()) != null) {
                    docView.setSelection(null);
                    selection.repaintDirtyRegions();
                }
                docView.saveLastHorizontalPosition();
                done = true;
            }
        }
        finally {
            if (lock) {
                WmiModelLock.readUnlock(docModel);
            }
        }
        return done;
    }
}

