/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.io.WmiImageUtilities;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMapleTASwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionInView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import com.maplesoft.util.SearchAlgorithms;
import com.maplesoft.util.WmiSearchException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class WmiViewUtil {
    private static ViewUtilLogicalChildOperation logicalChildOp = new ViewUtilLogicalChildOperation();
    private static ViewUtilPhysicalChildOperation physicalChildOp = new ViewUtilPhysicalChildOperation();
    private static ViewUtilParentOperation parentOp = new ViewUtilParentOperation();
    private static ViewUtilClassMatch docViewClassMatch = new ViewUtilClassMatch(WmiMathDocumentView.class);

    public static WmiView findAncestorOfTag(WmiView view, WmiModelTag tag) {
        return WmiViewUtil.parentSearch(view, new ViewUtilTagMatch(view, tag));
    }

    public static WmiView findAncestorOfTags(WmiView view, WmiModelTag[] tags) {
        return WmiViewUtil.parentSearch(view, new ViewUtilTagsMatch(view, tags));
    }

    public static WmiView findAncestorOfClass(WmiView view, Class c) {
        ViewUtilClassMatch match = new ViewUtilClassMatch(view, c);
        return WmiViewUtil.parentSearch(view, match);
    }

    public static boolean isViewAncestorOfView(WmiView first, WmiView second) {
        if (first == second) {
            return false;
        }
        ViewUtilEqualityMatch match = new ViewUtilEqualityMatch(first);
        return WmiViewUtil.parentSearch(second, match) != null;
    }

    public static WmiView findFirstDescendantOfTag(WmiView view, WmiModelTag tag) {
        WmiView dView = null;
        try {
            dView = WmiViewUtil.depthFirstSearch(view, new ViewUtilTagMatch(view, tag), 1, false);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return dView;
    }

    public static WmiView findFirstDescendantOfTags(WmiView view, WmiModelTag[] tags) {
        WmiView dView = null;
        try {
            dView = WmiViewUtil.depthFirstSearch(view, new ViewUtilTagsMatch(view, tags), 1, false);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return dView;
    }

    public static WmiView findFirstPhysicalDescendantOfTag(WmiView view, WmiModelTag tag) {
        WmiView dView = null;
        try {
            dView = WmiViewUtil.depthFirstSearch(view, new ViewUtilTagMatch(view, tag), 1, true);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return dView;
    }

    public static WmiView findLastDescendantOfTag(WmiView view, WmiModelTag tag) {
        WmiView dView = null;
        try {
            dView = WmiViewUtil.depthFirstSearch(view, new ViewUtilTagMatch(view, tag), -1, false);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return dView;
    }

    public static WmiView findLastPhysicalDescendantOfTag(WmiView view, WmiModelTag tag) {
        WmiView dView = null;
        try {
            dView = WmiViewUtil.depthFirstSearch(view, new ViewUtilTagMatch(view, tag), -1, true);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return dView;
    }

    public static WmiView findLastDescendantOfClass(WmiView view, Class c) {
        WmiView dView = null;
        try {
            dView = WmiViewUtil.depthFirstSearch(view, new ViewUtilClassMatch(view, c), -1, false);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return dView;
    }

    public static WmiView findFirstDescendantOfClass(WmiView view, Class c) {
        WmiView dView = null;
        try {
            dView = WmiViewUtil.depthFirstSearch(view, new ViewUtilClassMatch(view, c), 1, false);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return dView;
    }

    public static WmiMathDocumentView getDocumentView(WmiView view) {
        WmiMathDocumentView searchResult = null;
        try {
            if (view instanceof WmiMathDocumentView) {
                return (WmiMathDocumentView)view;
            }
            searchResult = (WmiMathDocumentView)SearchAlgorithms.parentSearch(view, parentOp, docViewClassMatch);
        }
        catch (WmiSearchException e) {
            WmiErrorLog.log(e);
        }
        return searchResult;
    }

    public static WmiMathDocumentView getDocumentView(Object o) {
        return o instanceof WmiView ? WmiViewUtil.getDocumentView((WmiView)o) : null;
    }

    public static Point getAbsoluteOffset(WmiPositionedView view) {
        return WmiViewUtil.getOffsetFrom(view, null);
    }

    public static Point getRelativeOffset(WmiPositionedView view, WmiPositionedView referenceView) {
        Point result;
        if (view == referenceView) {
            result = new Point(0, 0);
        } else if (WmiViewUtil.isViewAncestorOfView(referenceView, view)) {
            result = WmiViewUtil.getOffsetFrom(view, referenceView);
        } else if (WmiViewUtil.isViewAncestorOfView(view, referenceView)) {
            result = WmiViewUtil.getOffsetFrom(referenceView, view);
            result.setLocation(-result.getX(), -result.getY());
        } else {
            result = WmiViewUtil.getOffsetFrom(view, null);
            Point referencePoint = WmiViewUtil.getOffsetFrom(referenceView, null);
            result.translate(-((int)referencePoint.getX()), -((int)referencePoint.getY()));
        }
        return result;
    }

    private static Point getOffsetFrom(WmiPositionedView view, WmiPositionedView reference) {
        int x = 0;
        int y = 0;
        WmiView traverser = view;
        while (traverser instanceof WmiPositionedView && !(traverser instanceof WmiMathDocumentView) && traverser != reference) {
            x += traverser.getHorizontalOffset();
            y += traverser.getVerticalOffset();
            traverser = traverser.getParentView();
        }
        return new Point(x, y);
    }

    public static WmiScrollableContainerView findEnclosingContainer(WmiView view) {
        WmiScrollableContainerView scView = null;
        if (view instanceof WmiScrollableContainerView) {
            scView = (WmiScrollableContainerView)view;
        } else if (view != null) {
            scView = (WmiScrollableContainerView)WmiViewUtil.findAncestorOfClass(view, WmiScrollableContainerView.class);
        }
        return scView;
    }

    public static boolean isInSubcontainer(WmiView view) {
        WmiScrollableContainerView container;
        boolean isInContainer = false;
        if (view != null && (container = WmiViewUtil.findEnclosingContainer(view)) != null) {
            isInContainer = !container.isDocumentView();
        }
        return isInContainer;
    }

    public static Point offsetForContainer(WmiScrollableContainerView cont) {
        int xShift = 0;
        int yShift = 0;
        if (cont != null && !cont.isDocumentView()) {
            Rectangle cRect;
            Point pt = WmiViewUtil.getAbsoluteOffset(cont);
            if (pt != null) {
                xShift += pt.x;
                yShift += pt.y;
            }
            if ((cRect = cont.getVisibleRect()) != null) {
                xShift -= cRect.x;
                yShift -= cRect.y;
            }
        }
        return new Point(xShift, yShift);
    }

    public static Point containerRelativeOffset(WmiPositionedView view, WmiScrollableContainerView container) {
        Point pt = new Point(0, 0);
        if (view != null) {
            if (container == null && (container = WmiViewUtil.findEnclosingContainer(view)) == null) {
                container = view.getDocumentView();
            }
            if (container != null) {
                pt = WmiViewUtil.getRelativeOffset(view, container);
            }
        }
        return pt;
    }

    public static Point containerRelativeOffset(WmiPositionedView view) {
        return WmiViewUtil.containerRelativeOffset(view, null);
    }

    public static JScrollPane getDocumentScrollPane(WmiView view) {
        WmiMathDocumentView docView = view.getDocumentView();
        JScrollPane docScroller = null;
        if (docView != null) {
            docScroller = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, docView);
        }
        return docScroller;
    }

    public static WmiViewPath mapBeginningOfCompositeView(WmiCompositeView view) {
        WmiViewPath path = new WmiViewPath(view);
        WmiCompositeView toCheck = view;
        while (toCheck != null && toCheck.getChildCount() > 0) {
            WmiRowView morph;
            path.push(0);
            WmiView child = toCheck.getChild(0);
            if (child instanceof WmiSwitchableCompositeView && (morph = ((WmiSwitchableCompositeView)child).getRootPhysicalView()) != null) {
                child = morph;
            }
            if (child instanceof WmiCompositeView) {
                toCheck = (WmiCompositeView)child;
                continue;
            }
            toCheck = null;
            if (!(child instanceof WmiTextView)) continue;
            path.push(0);
        }
        return path;
    }

    public static WmiViewPath mapEndOfCompositeView(WmiCompositeView view, boolean isLogical) throws WmiNoReadAccessException {
        WmiViewPath path = null;
        if (view != null) {
            path = new WmiViewPath(view);
            WmiCompositeView toCheck = view;
            while (toCheck != null && toCheck.getChildCount() > 0) {
                WmiRowView morph;
                int end = toCheck.getChildCount() - 1;
                if (toCheck instanceof WmiFencedView) {
                    end = 1;
                }
                path.push(end);
                WmiView child = toCheck.getChild(end);
                if (!isLogical && child instanceof WmiSwitchableCompositeView && (morph = ((WmiSwitchableCompositeView)child).getRootPhysicalView()) != null) {
                    child = morph;
                }
                if (child instanceof WmiCompositeView) {
                    toCheck = (WmiCompositeView)child;
                    continue;
                }
                toCheck = null;
                if (!(child instanceof WmiTextView)) continue;
                path.push(((WmiTextView)child).getLength());
            }
        }
        return path;
    }

    public static WmiViewPath mapEndOfCompositeView(WmiCompositeView view) throws WmiNoReadAccessException {
        return WmiViewUtil.mapEndOfCompositeView(view, false);
    }

    public static WmiView modelToView(WmiMathDocumentView docView, WmiModel model, int offset) throws WmiNoReadAccessException {
        if (docView == null || model == null) {
            return null;
        }
        WmiView view = null;
        if (model instanceof WmiTextModel) {
            WmiModelObserver observer = model.getObserver();
            while (observer != null) {
                WmiTextView text;
                if (observer instanceof WmiTextView && (text = (WmiTextView)observer).getDocumentView() == docView && text.getStartOffset() <= offset && text.getEndOffset() >= offset) {
                    view = text;
                    break;
                }
                observer = observer.getNextObserver();
            }
        }
        if (view == null) {
            view = WmiViewUtil.modelToPhysicalView(docView, model);
        }
        return view;
    }

    public static void findChildViews(WmiCompositeView rootView, int y, ArrayList views) {
        WmiRowView physical;
        if (rootView instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)rootView).getRootPhysicalView()) != null) {
            rootView = physical;
        }
        int i = 0;
        while (i < rootView.getChildCount()) {
            WmiPositionedView posChild;
            Rectangle childBounds;
            WmiView child = rootView.getChild(i);
            if (child instanceof WmiPositionedView && (childBounds = (posChild = (WmiPositionedView)child).getBounds()) != null) {
                Point childPos = WmiViewUtil.getAbsoluteOffset(posChild);
                int childY = childPos.y;
                if (childY <= y && childBounds.height + childY >= y) {
                    if (child instanceof WmiCompositeView) {
                        WmiViewUtil.findChildViews((WmiCompositeView)child, y, views);
                    } else {
                        views.add(child);
                    }
                }
            }
            ++i;
        }
    }

    public static WmiView findNextDescendantOfTag(WmiView root, WmiView reference, WmiModelTag tag) {
        int index;
        WmiView match = null;
        WmiCompositeView parent = reference.getParentView();
        int n = index = parent != null ? parent.indexOf(reference) : -1;
        if (index >= 0 && index < parent.getChildCount() - 1) {
            WmiView siblingView = parent.getChild(index + 1);
            WmiModel siblingModel = siblingView.getModel();
            WmiModelTag siblingTag = siblingModel.getTag();
            WmiView wmiView = match = siblingTag == tag ? siblingView : WmiViewUtil.findFirstDescendantOfTag(siblingView, tag);
            if (match == null) {
                match = WmiViewUtil.findNextDescendantOfTag(root, siblingView, tag);
            }
        } else if (parent != null && parent != root) {
            match = WmiViewUtil.findNextDescendantOfTag(root, parent, tag);
        }
        return match;
    }

    public static WmiView findNextDescendantOfTags(WmiView root, WmiView reference, WmiModelTag[] tags) {
        int index;
        WmiView match = null;
        WmiCompositeView parent = reference.getParentView();
        int n = index = parent != null ? parent.indexOf(reference) : -1;
        if (index >= 0 && index < parent.getChildCount() - 1) {
            WmiView siblingView = parent.getChild(index + 1);
            WmiModel siblingModel = siblingView.getModel();
            WmiModelTag siblingTag = siblingModel.getTag();
            boolean matchFound = false;
            int i = 0;
            while (i < tags.length && !matchFound) {
                matchFound = siblingTag == tags[i];
                ++i;
            }
            WmiView wmiView = match = matchFound ? siblingView : WmiViewUtil.findFirstDescendantOfTags(siblingView, tags);
            if (match == null) {
                match = WmiViewUtil.findNextDescendantOfTags(root, siblingView, tags);
            }
        } else if (parent != null && parent != root) {
            match = WmiViewUtil.findNextDescendantOfTags(root, parent, tags);
        }
        return match;
    }

    public static WmiView findNextDescendantOfClass(WmiView root, WmiView reference, Class c) {
        int index;
        WmiView match = null;
        WmiCompositeView parent = reference.getParentView();
        int n = index = parent != null ? parent.indexOf(reference) : -1;
        if (index >= 0 && index < parent.getChildCount() - 1) {
            WmiView siblingView = parent.getChild(index + 1);
            WmiView wmiView = match = c.isInstance(siblingView) ? siblingView : WmiViewUtil.findFirstDescendantOfClass(siblingView, c);
            if (match == null) {
                match = WmiViewUtil.findNextDescendantOfClass(root, siblingView, c);
            }
        } else if (parent != null && parent != root) {
            match = WmiViewUtil.findNextDescendantOfClass(root, parent, c);
        }
        return match;
    }

    public static WmiView findPreviousDescendantOfClass(WmiView root, WmiView reference, Class c) {
        int index;
        WmiView match = null;
        WmiCompositeView parent = reference.getParentView();
        int n = index = parent != null ? parent.indexOf(reference) : -1;
        if (index > 0 && index < parent.getChildCount()) {
            WmiView siblingView = parent.getChild(index - 1);
            WmiView wmiView = match = c.isInstance(siblingView) ? siblingView : WmiViewUtil.findLastDescendantOfClass(siblingView, c);
            if (match == null) {
                match = WmiViewUtil.findPreviousDescendantOfClass(root, siblingView, c);
            }
        } else if (parent != null && parent != root) {
            match = WmiViewUtil.findPreviousDescendantOfClass(root, parent, c);
        }
        return match;
    }

    public static WmiView findNextPhysicalDescendantOfTag(WmiView root, WmiView reference, WmiModelTag tag) {
        int index;
        WmiView match = null;
        WmiCompositeView parent = reference.getParentView();
        int n = index = parent != null ? parent.indexOf(reference) : -1;
        if (index >= 0 && index < parent.getChildCount() - 1) {
            WmiView siblingView = parent.getChild(index + 1);
            WmiModel siblingModel = siblingView.getModel();
            WmiModelTag siblingTag = siblingModel.getTag();
            WmiView wmiView = match = siblingTag == tag ? siblingView : WmiViewUtil.findFirstPhysicalDescendantOfTag(siblingView, tag);
            if (match == null) {
                match = WmiViewUtil.findNextPhysicalDescendantOfTag(root, siblingView, tag);
            }
        } else if (parent != null && parent != root) {
            match = WmiViewUtil.findNextPhysicalDescendantOfTag(root, parent, tag);
        }
        return match;
    }

    public static WmiView findPreviousDescendantOfTag(WmiView root, WmiView reference, WmiModelTag tag) {
        int index;
        WmiView match = null;
        WmiCompositeView parent = reference.getParentView();
        int n = index = parent != null ? parent.indexOf(reference) : -1;
        if (index >= 1 && index < parent.getChildCount()) {
            WmiView siblingView = parent.getChild(index - 1);
            WmiModel siblingModel = siblingView.getModel();
            WmiModelTag siblingTag = siblingModel.getTag();
            WmiView wmiView = match = siblingTag == tag ? siblingView : WmiViewUtil.findLastDescendantOfTag(siblingView, tag);
            if (match == null) {
                match = WmiViewUtil.findPreviousDescendantOfTag(root, siblingView, tag);
            }
        } else if (parent != null && parent != root) {
            match = WmiViewUtil.findPreviousDescendantOfTag(root, parent, tag);
        }
        return match;
    }

    public static WmiView findPreviousPhysicalDescendantOfTag(WmiView root, WmiView reference, WmiModelTag tag) {
        int index;
        WmiView match = null;
        WmiCompositeView parent = reference.getParentView();
        int n = index = parent != null ? parent.indexOf(reference) : -1;
        if (index >= 1 && index < parent.getChildCount()) {
            WmiView siblingView = parent.getChild(index - 1);
            WmiModel siblingModel = siblingView.getModel();
            WmiModelTag siblingTag = siblingModel.getTag();
            WmiView wmiView = match = siblingTag == tag ? siblingView : WmiViewUtil.findLastPhysicalDescendantOfTag(siblingView, tag);
            if (match == null) {
                match = WmiViewUtil.findPreviousPhysicalDescendantOfTag(root, siblingView, tag);
            }
        } else if (parent != null && parent != root) {
            match = WmiViewUtil.findPreviousPhysicalDescendantOfTag(root, parent, tag);
        }
        return match;
    }

    public static WmiView findNextSibling(WmiView view) throws WmiNoReadAccessException {
        WmiCompositeView parent = view.getParentView();
        WmiView sibling = null;
        if (parent != null) {
            int index = parent.indexOf(view);
            int sibIndex = index + 1;
            while (sibIndex < parent.getChildCount() && WmiModelUtil.isEmptyIdentifierModel(parent.getChild(sibIndex).getModel())) {
                ++sibIndex;
            }
            if (sibIndex < parent.getChildCount()) {
                sibling = parent.getChild(sibIndex);
            }
        }
        return sibling;
    }

    public static WmiView findPreviousSibling(WmiView view) throws WmiNoReadAccessException {
        WmiCompositeView parent = view.getParentView();
        WmiView sibling = null;
        if (parent != null) {
            int index = parent.indexOf(view);
            int sibIndex = index - 1;
            while (sibIndex >= 0 && WmiModelUtil.isEmptyIdentifierModel(parent.getChild(sibIndex).getModel())) {
                --sibIndex;
            }
            if (sibIndex >= 0) {
                sibling = parent.getChild(sibIndex);
            }
        }
        return sibling;
    }

    public static WmiViewPosition findNearestView(WmiPositionedView reference, Point pt) {
        WmiViewPosition position = null;
        WmiPositionedView nextView = reference;
        pt = new Point(pt.x, pt.y);
        while (nextView != null) {
            WmiPositionedView child;
            int offset = 0;
            if (nextView != reference && WmiViewUtil.isTraversableView(nextView)) {
                WmiTraversableView traversable = (WmiTraversableView)nextView;
                if (nextView.getHorizontalOffset() + pt.x <= 0 && (traversable.getTraversalType() & 2) != 0) {
                    if (nextView.getParentView() != reference) {
                        nextView = (WmiPositionedView)((Object)nextView.getParentView());
                    }
                    offset = 0;
                    position = new WmiViewPosition(nextView, offset);
                    break;
                }
                if (pt.x >= nextView.getWidth()) {
                    WmiPositionedView parentView = (WmiPositionedView)((Object)nextView.getParentView());
                    if (pt.x + nextView.getHorizontalOffset() >= parentView.getWidth() && (traversable.getTraversalType() & 4) != 0) {
                        nextView = parentView;
                        offset = -1;
                        position = new WmiViewPosition(nextView, offset);
                        break;
                    }
                }
            }
            if ((child = nextView.getNearestChildView(pt)) != null && !child.isNavagableView()) {
                child = nextView.getViewForNavigation(-4, pt);
            }
            if (child != null) {
                WmiPositionedView view = child;
                while (view != nextView && view != null) {
                    pt.x -= view.getHorizontalOffset();
                    pt.y -= view.getVerticalOffset();
                    view = (WmiPositionedView)((Object)view.getParentView());
                }
                nextView = child;
                continue;
            }
            if (nextView instanceof WmiTextView) {
                offset = ((WmiTextView)nextView).getOffset(pt);
            }
            position = new WmiViewPosition(nextView, offset);
            break;
        }
        return position;
    }

    public static WmiModel findModelAtSource(WmiView view, WmiModelTag tag) throws WmiNoReadAccessException {
        WmiModel foundModel = null;
        if (view != null) {
            WmiModel searchModel = view.getModel();
            if (searchModel.getTag() == tag) {
                foundModel = searchModel;
            } else {
                WmiPositionedView searchView;
                WmiMathDocumentView docView;
                WmiPositionMarker marker;
                if (view instanceof WmiMathDocumentView && (marker = (docView = (WmiMathDocumentView)view).getPositionMarker()) != null && (searchView = marker.getView()) != null) {
                    searchModel = searchView.getModel();
                }
                if (searchModel != null && searchModel.getTag() != tag) {
                    searchModel = WmiModelUtil.findAncestorOfTag(searchModel, tag);
                }
                if (searchModel != null && searchModel.getTag() == tag) {
                    foundModel = searchModel;
                }
            }
        }
        return foundModel;
    }

    public static WmiView findViewAtSource(WmiView view, WmiModelTag tag) {
        WmiView foundView = null;
        if (view != null && view.getModel().getTag() == tag) {
            foundView = view;
        } else {
            WmiView searchView = view;
            if (view instanceof WmiMathDocumentView) {
                WmiMathDocumentView docView = (WmiMathDocumentView)view;
                WmiPositionMarker marker = docView.getPositionMarker();
                if (marker != null) {
                    searchView = marker.getView();
                } else {
                    WmiViewPath endPath;
                    WmiViewPath beginPath;
                    WmiViewPath root;
                    WmiSelection selection = docView.getSelection();
                    if (selection != null && !selection.isCompoundSelection() && (root = WmiViewPath.commonParent(beginPath = selection.getSelectionStartPath(), endPath = selection.getSelectionEndPath())) != null) {
                        searchView = root.extractView(docView);
                    }
                }
            }
            if (searchView != null && searchView.getModel() != null && searchView.getModel().getTag() != tag) {
                searchView = WmiViewUtil.findAncestorOfTag(searchView, tag);
            }
            if (searchView != null && searchView.getModel() != null && searchView.getModel().getTag() == tag) {
                foundView = searchView;
            }
        }
        return foundView;
    }

    public static WmiView modelToPhysicalView(WmiMathDocumentView docView, WmiModel targetModel) throws WmiNoReadAccessException {
        WmiView view = null;
        if (targetModel == targetModel.getDocument()) {
            view = docView;
        } else {
            WmiModelObserver observer = targetModel != null ? targetModel.getObserver() : null;
            while (observer != null) {
                if (observer instanceof WmiView) {
                    WmiCompositeView parentView;
                    boolean isPhysicalView = true;
                    WmiView candidate = (WmiView)((Object)observer);
                    WmiCompositeView parent = candidate.getParentView();
                    while (parent != docView) {
                        if (parent instanceof WmiSwitchableCompositeView) {
                            WmiRowView physical = ((WmiSwitchableCompositeView)parent).getRootPhysicalView();
                            if (physical != null && physical != candidate) {
                                isPhysicalView = false;
                                break;
                            }
                        } else if (parent == null) {
                            isPhysicalView = false;
                            break;
                        }
                        candidate = parent;
                        parent = candidate.getParentView();
                    }
                    if (isPhysicalView && (parentView = ((WmiView)((Object)observer)).getParentView()) != null && parentView.getModel() == targetModel) {
                        isPhysicalView = false;
                    }
                    if (isPhysicalView) {
                        view = (WmiView)((Object)observer);
                        break;
                    }
                }
                observer = observer.getNextObserver();
            }
        }
        WmiView view2 = WmiViewUtil.findView(docView, targetModel, false);
        if (view2 != view && view2 != null) {
            view = view2;
        }
        return view;
    }

    public static WmiModelPosition findVisibleMarkerPosition(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiModelPosition pos = null;
        WmiPositionedView positionRef = null;
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null) {
            WmiModel caretModel;
            pos = marker.getModelPosition();
            WmiPositionedView markerView = marker.getView();
            if (markerView instanceof WmiPositionedView && !(caretModel = markerView.getModel()).isVisible()) {
                positionRef = markerView;
                WmiCompositeView parentView = markerView.getParentView();
                while (parentView != null && !parentView.getModel().isVisible()) {
                    if (parentView instanceof WmiPositionedView) {
                        positionRef = (WmiPositionedView)((Object)parentView);
                    }
                    parentView = parentView.getParentView();
                }
            }
        }
        if (positionRef != null) {
            int offset = -1;
            WmiPositionedView newPos = positionRef.getNextView(2);
            if (newPos != null) {
                if (newPos instanceof WmiTextView) {
                    offset = ((WmiTextView)newPos).getLength();
                }
                pos = new WmiModelPosition(newPos.getModel(), offset);
            } else {
                if (pos == null) {
                    newPos = positionRef.getNextView(3);
                }
                if (newPos == null) {
                    newPos = positionRef.getNextView(0);
                }
                if (newPos == null) {
                    newPos = positionRef.getNextView(1);
                }
                if (newPos != null) {
                    WmiModel model = newPos.getModel();
                    if (model instanceof WmiCompositeModel) {
                        WmiModelPath path = WmiModelUtil.mapBeginningOfCompositeModel((WmiCompositeModel)model);
                        pos = path.getModelPosition(model.getDocument());
                    } else {
                        pos = new WmiModelPosition(model, offset);
                    }
                }
            }
        }
        return pos;
    }

    public static BufferedImage drawViewToImage(WmiPositionedView view, WmiRenderPath path, int maxWidth) throws WmiNoReadAccessException {
        BufferedImage image = null;
        int kernSpace = view.getModel().kerningPoints();
        if (view instanceof WmiInlineView) {
            kernSpace = Math.max(kernSpace, WmiMathViewUtil.getMathKerningSize((WmiInlineView)view));
        }
        AffineTransform at = null;
        if (maxWidth <= 0 || view.getWidth() + 2 * kernSpace < maxWidth) {
            image = WmiImageUtilities.createImageObject(view.getWidth() + 2 * kernSpace, view.getHeight());
        } else if (view instanceof WmiInlineView) {
            kernSpace = WmiMathViewUtil.getMathKerningSize((WmiInlineView)view);
            image = WmiImageUtilities.createImageObject(maxWidth, view.getHeight());
            view.setWidth(maxWidth - 2 * kernSpace);
        } else {
            int imageWidth = maxWidth;
            int imageHeight = (int)Math.round((double)view.getHeight() / ((double)view.getWidth() * 1.0) * (double)maxWidth);
            image = WmiImageUtilities.createImageObject(imageWidth, imageHeight);
            at = new AffineTransform();
            at.setToScale((float)imageWidth / (float)view.getWidth(), (float)imageHeight / (float)view.getHeight());
        }
        Graphics2D graphics = image.createGraphics();
        Rectangle rect = new Rectangle(image.getWidth(), image.getHeight());
        WmiMathDocumentView myDoc = view.getDocumentView();
        Color fillColour = myDoc != null ? myDoc.getColor(0) : Color.WHITE;
        graphics.setPaint(fillColour);
        graphics.setClip(rect);
        graphics.fill(rect);
        path.setScreenDraw(false);
        path.drawStringsWithGlyphVectors(false);
        graphics.translate(kernSpace, 0);
        if (at != null) {
            graphics.transform(at);
        }
        view.draw(graphics, path, rect);
        graphics.dispose();
        return image;
    }

    public static WmiView findFirstLeafView(WmiCompositeModel model, WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiView view = null;
        WmiModel child = WmiModelUtil.findFirstDescendantLeaf(model);
        while (child != null && view == null) {
            if (child.isVisible()) {
                view = WmiViewUtil.modelToPhysicalView(docView, child);
            }
            child = WmiModelUtil.findNextDescendantLeaf(model, child);
        }
        return view;
    }

    public static WmiView findLastLeafView(WmiCompositeModel model, WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiView view = null;
        WmiModel child = WmiModelUtil.findLastDescendantLeaf(model);
        while (child != null && view == null) {
            if (child.isVisible()) {
                view = WmiViewUtil.modelToPhysicalView(docView, child);
            }
            child = WmiModelUtil.findPreviousDescendantLeaf(model, child);
        }
        return view;
    }

    /*
     * Unable to fully structure code
     */
    private static Vector childModelToView(WmiCompositeView parent, WmiModel model, boolean logicalSearch) {
        block6: {
            result = new Vector<WmiView>();
            viewsToVisit = new LinkedList<WmiView>();
            viewsToVisit.addLast(parent);
            if (parent.getModel() != model) ** GOTO lbl24
            result.add(parent);
            break block6;
lbl-1000:
            // 1 sources

            {
                currentView = null;
                currentView = (WmiCompositeView)viewsToVisit.removeFirst();
                if ((!logicalSearch && currentView instanceof WmiSwitchableCompositeView || currentView instanceof WmiMapleTASwitchableCompositeView) && (physical = ((WmiSwitchableCompositeView)currentView).getRootPhysicalView()) != null) {
                    currentView = physical;
                }
                size = currentView.getChildCount();
                i = 0;
                while (i < size) {
                    child = currentView.getChild(i);
                    if (child != null) {
                        if (child.getModel() == model) {
                            result.add(child);
                        }
                        if (child instanceof WmiCompositeView && result.isEmpty()) {
                            viewsToVisit.addLast(child);
                        }
                    }
                    ++i;
                }
lbl24:
                // 2 sources

                ** while (!viewsToVisit.isEmpty())
            }
        }
        return result;
    }

    private static WmiView depthFirstSearch(WmiView view, SearchAlgorithms.MatchCondition condition, int dir, boolean isPhysical) throws WmiSearchException {
        return (WmiView)SearchAlgorithms.depthFirstSearch(view, isPhysical ? physicalChildOp : logicalChildOp, condition, dir);
    }

    public static WmiView findView(WmiMathDocumentView docView, WmiModel targetModel, boolean isLogical) throws WmiNoReadAccessException {
        Vector results;
        if (docView.getModel() == targetModel) {
            return docView;
        }
        WmiView found = null;
        Stack<WmiModel> modelAncestors = new Stack<WmiModel>();
        modelAncestors.push(targetModel);
        WmiCompositeModel parent = targetModel.getParent();
        while (parent != null) {
            modelAncestors.push(parent);
            parent = parent.getParent();
        }
        WmiModel searchModel = (WmiModel)modelAncestors.pop();
        Vector<WmiView> searchParents = new Vector<WmiView>();
        searchParents.add(docView);
        block1: while (!modelAncestors.isEmpty()) {
            searchModel = (WmiModel)modelAncestors.pop();
            results = null;
            int i = 0;
            while ((results == null || results.size() == 0) && i < searchParents.size()) {
                WmiCompositeView searchParent = (WmiCompositeView)searchParents.get(i++);
                results = WmiViewUtil.childModelToView(searchParent, searchModel, isLogical);
            }
            if (results != null && !results.isEmpty()) {
                searchParents.removeAllElements();
            }
            while (results != null && !results.isEmpty()) {
                WmiView findView = (WmiView)results.remove(results.size() - 1);
                if (findView != null && findView.getModel() == targetModel) {
                    found = findView;
                    continue block1;
                }
                if (!isLogical && findView instanceof WmiSwitchableCompositeView || findView instanceof WmiMapleTASwitchableCompositeView) {
                    WmiRowView physical = ((WmiSwitchableCompositeView)findView).getRootPhysicalView();
                    searchParents.add(physical != null ? physical : (WmiCompositeView)findView);
                    continue;
                }
                if (!(findView instanceof WmiCompositeView)) continue;
                searchParents.add(findView);
            }
        }
        if (found == null && (results = WmiViewUtil.childModelToView(docView, targetModel, isLogical)) != null && !results.isEmpty()) {
            found = (WmiView)results.get(0);
        }
        return found;
    }

    private static WmiView parentSearch(WmiView view, SearchAlgorithms.MatchCondition c) {
        WmiView searchResult = null;
        while (view != null) {
            if (c.matchesCondition(view)) {
                searchResult = view;
                break;
            }
            view = view.getParentView();
        }
        return searchResult;
    }

    public static WmiPositionInView getPositionInView(MouseEvent e) {
        return WmiViewUtil.getPositionInView(e, null);
    }

    public static WmiPositionInView getPositionInView(MouseEvent e, WmiView view) {
        Object source = e.getSource();
        Point p = e.getPoint();
        while (!(source instanceof WmiPositionedView)) {
            if (source instanceof Component) {
                Component c = (Component)source;
                p.translate((int)c.getLocation().getX(), (int)c.getLocation().getY());
                source = c.getParent();
                continue;
            }
            if (view instanceof WmiPositionedView) {
                return new WmiPositionInView((WmiPositionedView)view, e.getPoint());
            }
            throw new NullPointerException();
        }
        return new WmiPositionInView((WmiPositionedView)source, p);
    }

    public static WmiFontMetrics getFontMetrics(WmiGenericView parent) throws WmiNoReadAccessException {
        WmiModel model = parent.getModel();
        WmiAttributeSet attributes = model.getAttributesForRead();
        boolean forPrint = parent.getDocumentView().isPrintView();
        WmiFontAttributeSet set = attributes instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)attributes : WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
        Font font = WmiFontResolver.getFont(set, parent.getZoomFactor(), forPrint);
        return WmiFontResolver.getFontMetrics(font);
    }

    public static AffineTransform createCOBMatrix(WmiPositionedView ancestor, WmiPositionedView descendent) {
        AffineTransform t = new AffineTransform();
        while (descendent != ancestor) {
            int x = descendent.getHorizontalOffset();
            int y = descendent.getVerticalOffset();
            t.preConcatenate(AffineTransform.getTranslateInstance(x, y));
            descendent = (WmiPositionedView)((Object)descendent.getParentView());
        }
        return t;
    }

    public static boolean isTraversableView(WmiView view) {
        boolean traversable = false;
        if (view instanceof WmiTraversableView) {
            traversable = ((WmiTraversableView)view).getTraversalType() != 0;
        }
        return traversable;
    }

    private WmiViewUtil() {
    }

    private static class ViewUtilClassMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView view = null;
        private Class toMatch = null;

        private ViewUtilClassMatch(Class toMatch) {
            this(null, toMatch);
        }

        private ViewUtilClassMatch(WmiView view, Class toMatch) {
            this.view = view;
            this.toMatch = toMatch;
        }

        @Override
        public boolean matchesCondition(Object o) {
            return (this.view == null || this.view != o) && this.toMatch.isInstance(o);
        }
    }

    private static class ViewUtilEqualityMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView toMatch = null;

        private ViewUtilEqualityMatch(WmiView toMatch) {
            this.toMatch = toMatch;
        }

        @Override
        public boolean matchesCondition(Object o) {
            return o == this.toMatch;
        }
    }

    private static class ViewUtilLogicalChildOperation
    implements SearchAlgorithms.ChildOperation {
        private ViewUtilLogicalChildOperation() {
        }

        @Override
        public Object getChild(Object o, int i) {
            WmiCompositeView view = (WmiCompositeView)o;
            return view.getChild(i);
        }

        @Override
        public int getChildCount(Object o) {
            WmiCompositeView view = (WmiCompositeView)o;
            return view.getChildCount();
        }

        @Override
        public boolean hasChildren(Object o) {
            return o instanceof WmiCompositeView;
        }
    }

    private static class ViewUtilParentOperation
    implements SearchAlgorithms.ParentOperation {
        private ViewUtilParentOperation() {
        }

        @Override
        public Object getParent(Object o) {
            WmiView view = (WmiView)o;
            return view.getParentView();
        }
    }

    private static class ViewUtilPhysicalChildOperation
    implements SearchAlgorithms.ChildOperation {
        private ViewUtilPhysicalChildOperation() {
        }

        @Override
        public Object getChild(Object o, int i) {
            WmiRowView physical;
            WmiCompositeView view = (WmiCompositeView)o;
            if (o instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)o).getRootPhysicalView()) != null) {
                view = physical;
            }
            return view.getChild(i);
        }

        @Override
        public int getChildCount(Object o) {
            WmiRowView physical;
            WmiCompositeView view = (WmiCompositeView)o;
            if (o instanceof WmiSwitchableCompositeView && (physical = ((WmiSwitchableCompositeView)o).getRootPhysicalView()) != null) {
                view = physical;
            }
            return view.getChildCount();
        }

        @Override
        public boolean hasChildren(Object o) {
            return o instanceof WmiCompositeView;
        }
    }

    private static class ViewUtilTagMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView origin = null;
        private WmiModelTag tag = null;

        private ViewUtilTagMatch(WmiView origin, WmiModelTag tag) {
            this.origin = origin;
            this.tag = tag;
        }

        @Override
        public boolean matchesCondition(Object o) {
            if (o == this.origin) {
                return false;
            }
            WmiModel model = ((WmiView)o).getModel();
            return model != null ? model.getTag() == this.tag : false;
        }
    }

    private static class ViewUtilTagsMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView origin = null;
        private WmiModelTag[] tags = null;

        private ViewUtilTagsMatch(WmiView origin, WmiModelTag[] tags) {
            this.origin = origin;
            this.tags = tags;
        }

        @Override
        public boolean matchesCondition(Object o) {
            WmiModel model;
            boolean answer = false;
            if (o != this.origin && (model = ((WmiView)o).getModel()) != null) {
                int i = 0;
                while (i < this.tags.length) {
                    if (this.tags[i] == model.getTag()) {
                        answer = true;
                        break;
                    }
                    ++i;
                }
            }
            return answer;
        }
    }
}

