/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiFencedView
extends WmiMathInlineView
implements WmiTraversableView {
    private static final float MINIMUM_WIDTH_SCALE_FACTOR = 0.3f;
    private static final float MIN_HEIGHT_BASELINE_ADJUST = 0.8f;
    private WmiMathOperatorView leftView = null;
    private WmiMathOperatorView rightView = null;
    private WmiMathOperatorView[] sepViews = null;
    private boolean suppressLeft = false;
    private boolean suppressRight = false;
    private boolean addTrailingSeparator = false;

    public WmiFencedView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            super.layoutView();
            this.createFenceViews(this.getModel());
            int shift = 0;
            int dy = 0;
            int minWidth = 0;
            int bracketWidths = 0;
            if (this.leftView != null) {
                this.leftView.layoutView();
                int minHeight = this.leftView.getHeight();
                if (minHeight > this.height) {
                    int bracketBaseline = Math.round(0.8f * (float)minHeight);
                    dy = bracketBaseline - this.baseline;
                    this.baseline = bracketBaseline;
                    this.height = minHeight;
                }
                if (this.leftView.layoutStretchView(this.height)) {
                    this.leftView.setBaseline(this.baseline);
                }
                bracketWidths = shift = this.leftView.getWidth();
                minWidth = Math.round(0.3f * (float)shift);
            }
            int size = this.getChildCount();
            int i = 0;
            while (i < size) {
                WmiPositionedView child = (WmiPositionedView)this.getChild(i);
                child.setHorizontalOffset(child.getHorizontalOffset() + shift);
                if (dy != 0) {
                    child.setVerticalOffset(child.getVerticalOffset() + dy);
                }
                if (this.sepViews != null && i < this.sepViews.length) {
                    WmiMathOperatorView separator = this.sepViews[i];
                    separator.layoutView();
                    separator.setHorizontalOffset(child.getHorizontalOffset() + child.getWidth());
                    separator.setVerticalOffset(child.getVerticalOffset() + child.getBaseline() - separator.getBaseline());
                    shift += separator.getWidth();
                }
                ++i;
            }
            int rightWidth = 0;
            if (this.rightView != null) {
                this.rightView.layoutView();
                if (this.rightView.layoutStretchView(this.height)) {
                    this.rightView.setBaseline(this.baseline);
                }
                this.rightView.setHorizontalOffset(this.width + shift);
                rightWidth = this.rightView.getWidth();
                bracketWidths += rightWidth;
                shift += rightWidth;
                if (0.3f * (float)rightWidth > (float)minWidth) {
                    minWidth = Math.round(0.3f * (float)rightWidth);
                }
            }
            this.width += shift;
            if (this.rightView != null && this.width - bracketWidths < minWidth) {
                this.width = minWidth + bracketWidths;
                this.rightView.setHorizontalOffset(this.width - rightWidth);
            }
        }
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        super.draw(g, path, bounds);
        path.push(this.x, this.y);
        if (this.leftView != null) {
            this.leftView.draw(g, path, bounds);
        }
        if (this.rightView != null) {
            this.rightView.draw(g, path, bounds);
        }
        if (this.sepViews != null) {
            int i = 0;
            while (i < this.sepViews.length) {
                this.sepViews[i].draw(g, path, bounds);
                ++i;
            }
        }
        path.pop();
    }

    protected void createFenceViews(WmiModel cmodel) throws WmiNoReadAccessException {
        if (cmodel instanceof WmiMathFencedModel) {
            WmiMathOperatorModel rightFenceModel;
            WmiMathOperatorModel leftFenceModel;
            WmiMathFencedModel model = (WmiMathFencedModel)cmodel;
            int childCount = this.getChildCount();
            boolean includeSeparators = childCount > 1;
            int separatorBaseIndex = 0;
            if (includeSeparators) {
                WmiView firstView = this.getChild(0);
                WmiModel firstModel = firstView.getModel();
                WmiCompositeModel parent = firstModel.getParent();
                separatorBaseIndex = parent.indexOf(firstModel);
            }
            WmiMathOperatorModel wmiMathOperatorModel = leftFenceModel = !this.suppressLeft ? (WmiMathOperatorModel)model.getModelForLeft() : null;
            WmiMathOperatorModel wmiMathOperatorModel2 = !this.suppressRight ? (WmiMathOperatorModel)model.getModelForRight() : (rightFenceModel = this.addTrailingSeparator ? (WmiMathOperatorModel)model.getModelForSeparator(childCount + separatorBaseIndex) : null);
            if (leftFenceModel != null) {
                this.leftView = new WmiMathOperatorView(leftFenceModel, this.getDocumentView());
                this.leftView.setParentView(this);
            } else {
                this.leftView = null;
            }
            if (rightFenceModel != null) {
                this.rightView = new WmiMathOperatorView(rightFenceModel, this.getDocumentView());
                this.rightView.setParentView(this);
            } else {
                this.rightView = null;
            }
            if (includeSeparators) {
                this.sepViews = new WmiMathOperatorView[childCount - 1];
                int i = 0;
                while (i < childCount - 1) {
                    WmiMathOperatorModel separatorModel = (WmiMathOperatorModel)model.getModelForSeparator(i + separatorBaseIndex);
                    this.sepViews[i] = new WmiMathOperatorView(separatorModel, this.getDocumentView());
                    this.sepViews[i].setParentView(this);
                    ++i;
                }
            } else {
                this.sepViews = null;
            }
        }
    }

    public WmiPositionedView getLeftBracket() {
        return this.leftView;
    }

    public WmiPositionedView getRightBracket() {
        return this.rightView;
    }

    public WmiPositionedView getSeparator(int index) {
        WmiMathOperatorView sep = null;
        if (this.sepViews != null && this.sepViews.length > index) {
            sep = this.sepViews[index];
        }
        return sep;
    }

    @Override
    public void setPositionMarker(int offset) {
        WmiMathCaret.setBoundaryCaret(this, offset);
    }

    @Override
    public WmiPositionedView getNearestChildView(Point pt) {
        return this.getNearestChildView(pt, this.getNearestSearchRule());
    }

    @Override
    protected WmiPositionedView getNearestChildView(Point pt, int searchType) {
        WmiPositionedView view = super.getNearestChildView(pt, searchType);
        return view;
    }

    public int getNearestSearchRule() {
        return 2;
    }

    @Override
    public int getTraversalType() {
        int type = 0;
        if (this.leftView != null) {
            type |= 2;
        }
        if (this.rightView != null) {
            type |= 4;
        }
        return type;
    }

    @Override
    public int getOffset(Point pt) {
        return 0;
    }

    @Override
    public int getTraversableCount() {
        return this.leftView != null || this.rightView != null ? 2 : 0;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public WmiView splitView(int offset, int consume) {
        WmiFencedView fragment = (WmiFencedView)super.splitView(offset, consume);
        fragment.suppressRight = true;
        fragment.addTrailingSeparator = this.addTrailingSeparator;
        this.suppressLeft = true;
        this.addTrailingSeparator = false;
        this.markInvalid(1);
        fragment.markInvalid(1);
        return fragment;
    }

    public void updateLayout() {
    }

    @Override
    public void addNavigationLinks() {
        super.addNavigationLinks();
        if (this.leftView != null) {
            this.leftView.setNextView(this.getNextView(-4), 3);
        }
        if (this.rightView != null) {
            this.rightView.setNextView(this.getNextView(-3), 2);
        }
    }

    @Override
    public void adjustVerticalLayout() throws WmiNoReadAccessException {
        this.markInvalid(1);
        this.layoutView();
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        if (horizontalOffset + this.getWidth() < breakWidth && this.rightView != null && this.leftView == null) {
            int index;
            WmiCompositeView parent = this.getParentView();
            int n = index = parent != null ? parent.indexOf(this) : -1;
            if (index >= 0) {
                paragraph.split(parent, index + 1, 0);
                success = 2;
            }
        }
        if (success == 0) {
            success = super.doImplicitLinebreak(paragraph, horizontalOffset, breakWidth, thresholdCost);
        }
        if (success == 0 && thresholdCost == 2 && this.leftView != null) {
            paragraph.split(this, 0, 0);
            success = 2;
        }
        return success;
    }

    @Override
    protected int breakAtDelimiter(WmiParagraphView paragraph, int index) throws WmiNoReadAccessException {
        int size = this.getChildCount();
        if (size > 1) {
            this.addTrailingSeparator = true;
            paragraph.split(this, index, 0);
            return 2;
        }
        return super.breakAtDelimiter(paragraph, index);
    }

    @Override
    public WmiPositionedView getChildView(Point pt) {
        WmiPositionedView childView = null;
        if (!(this.leftView != null && pt.x < this.leftView.getWidth() || this.rightView != null && pt.x > this.getWidth() - this.rightView.getWidth())) {
            childView = super.getChildView(pt);
        }
        return childView;
    }
}

