/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiMathCaret
extends WmiCaret {
    private int uprightBottom = 0;
    private int uprightTop = 0;
    private Rectangle caretRect = new Rectangle(0, 0, 0, 0);
    private static boolean DRAW_CLIP_BOUNDS = false;

    public WmiMathCaret(WmiMathDocumentView view) {
        super(view);
    }

    @Override
    protected void drawCaret(Graphics g) {
        Point cPt;
        Color saveColor = g.getColor();
        Rectangle saveClip = g.getClipBounds();
        WmiPositionedView cV = this.getView();
        Point cOffset = WmiViewUtil.offsetForContainer(this.container);
        Point cOrigin = WmiViewUtil.getAbsoluteOffset(this.container);
        Rectangle cBounds = this.container.getBounds();
        int xClip = cOrigin.x;
        int yClip = cOrigin.y;
        int wClip = cBounds.width;
        int hClip = cBounds.height;
        if (!this.container.isDocumentView()) {
            g.setClip(xClip, yClip, wClip, hClip);
        }
        if ((cPt = this.container.getContainerOffset()) != null) {
            cOffset.x += cPt.x;
            cOffset.y += cPt.y;
        }
        int xTop = this.uprightTop + cOffset.x;
        int yTop = this.getTop() + cOffset.y;
        int xBottom = this.uprightBottom + cOffset.x;
        int yBottom = this.getBottom() + cOffset.y;
        g.setColor(Color.BLACK);
        g.drawLine(xTop, yTop, xBottom, yBottom);
        int boundsLeft = Math.min(xTop, xBottom);
        int boundsRight = Math.max(xTop, xBottom);
        if (cV != null) {
            g.setColor(Color.LIGHT_GRAY);
            Point relativeDrawPoint = WmiViewUtil.getRelativeOffset(cV, this.container);
            int hstartpoint = relativeDrawPoint.x + cOffset.x;
            int hendpoint = hstartpoint + cV.getWidth();
            hendpoint = hendpoint > xBottom && xBottom > hstartpoint ? xBottom : hendpoint;
            g.drawLine(hstartpoint, yBottom, hendpoint, yBottom);
            boundsLeft = Math.min(boundsLeft, hstartpoint);
            boundsRight = Math.max(boundsRight, hendpoint);
        }
        int width = boundsRight - boundsLeft + 1;
        int height = yBottom - yTop + 1;
        this.caretRect.setBounds(boundsLeft, yTop, width, height);
        g.setColor(saveColor);
        g.setClip(saveClip.x, saveClip.y, saveClip.width, saveClip.height);
    }

    public void setUprightPosition(int hposBottom, int hposTop) {
        this.uprightBottom = hposBottom;
        this.uprightTop = hposTop;
    }

    public int getUprightPosition() {
        return this.uprightTop;
    }

    @Override
    protected void repaint() {
        if ((this.caretRect.width == 0 || this.caretRect.height == 0) && this.container != null) {
            Point cPt;
            Point cOffset = WmiViewUtil.offsetForContainer(this.container);
            if (cOffset == null) {
                cOffset = new Point(0, 0);
            }
            if ((cPt = this.container.getContainerOffset()) != null) {
                cOffset.x += cPt.x;
                cOffset.y += cPt.y;
            }
            int xTop = this.uprightTop + cOffset.x;
            int yTop = this.getTop() + cOffset.y;
            int xBottom = this.uprightBottom + cOffset.x;
            int yBottom = this.getBottom() + cOffset.y;
            int boundsLeft = Math.min(xTop, xBottom);
            int boundsRight = Math.max(xTop, xBottom);
            WmiPositionedView cV = this.getView();
            if (cV != null) {
                Point relativeDrawPoint = WmiViewUtil.getRelativeOffset(cV, this.container);
                int hstartpoint = relativeDrawPoint.x + cOffset.x;
                int hendpoint = hstartpoint + cV.getWidth();
                hendpoint = hendpoint > xBottom && xBottom > hstartpoint ? xBottom : hendpoint;
                boundsLeft = Math.min(boundsLeft, hstartpoint);
                boundsRight = Math.max(boundsRight, hendpoint);
            }
            int width = boundsRight - boundsLeft + 1;
            int height = yBottom - yTop + 1;
            this.caretRect.setBounds(boundsLeft, yTop, width, height);
        }
        this.docView.repaint(this.caretRect.x, this.caretRect.y, this.caretRect.width, this.caretRect.height);
    }

    public static void setBoundaryCaret(WmiTraversableView view, int offset) {
        try {
            WmiMathDocumentView docView;
            if (offset == -1) {
                offset = view.getTraversableCount() - 1;
            }
            if ((docView = view.getDocumentView()) != null) {
                WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(view);
                Point pt = WmiViewUtil.containerRelativeOffset(view, container);
                int uprightOffset = 0;
                if (offset != 0) {
                    uprightOffset = view.getWidth();
                }
                WmiCaret caret = docView.getCaret();
                boolean setMarker = false;
                if (!(caret instanceof WmiMathCaret)) {
                    caret = new WmiMathCaret(docView);
                    setMarker = true;
                }
                caret.updateCaretBounds(container, pt.x, pt.y, pt.x + view.getWidth(), pt.y + view.getHeight());
                ((WmiMathCaret)caret).setUprightPosition(pt.x + uprightOffset, pt.x + uprightOffset);
                caret.updateView(view, offset);
                if (setMarker) {
                    docView.setPositionMarker(caret);
                }
                caret.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    public int getUprightBottom() {
        return this.uprightBottom;
    }

    public void setUprightBottom(int uprightBottom) {
        this.uprightBottom = uprightBottom;
    }

    public int getUprightTop() {
        return this.uprightTop;
    }

    public void setUprightTop(int uprightTop) {
        this.uprightTop = uprightTop;
    }

    @Override
    public void updateCaretBounds(WmiScrollableContainerView view, int x1, int y1, int x2, int y2) {
        super.updateCaretBounds(view, x1, y1, x2, y2);
        this.caretRect = new Rectangle(0, 0, 0, 0);
    }
}

