/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathEncloseModel;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashSet;

public class WmiMathEncloseView
extends WmiMathInlineView {
    private static final String WIDTH_PADDING = "0.4em";
    private static final String HEIGHT_PADDING = "0.5ex";
    private int widthPadding = 0;
    private int heightPadding = 0;
    private HashSet notationList = new HashSet();

    public WmiMathEncloseView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
        this.applyMathRules(true);
        this.lockOperatorSize(false);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        super.draw(g, path, bounds);
        if (this.notationList.contains("left")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + 1, this.height);
        }
        if (this.notationList.contains("right")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, this.height);
        }
        if (this.notationList.contains("top")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, path.getVerticalOffset() + 2);
        }
        if (this.notationList.contains("bottom")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + this.height, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 2, path.getVerticalOffset() + this.height);
        }
        if (this.notationList.contains("updiagonalstrike")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + this.height - 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, path.getVerticalOffset() + 2);
        }
        if (this.notationList.contains("downdiagonalstrike")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, path.getVerticalOffset() + this.height - 2);
        }
        if (this.notationList.contains("verticalstrike")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + this.width / 2, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width / 2, path.getVerticalOffset() + this.height - 2);
        }
        if (this.notationList.contains("horizontalstrike")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + this.height / 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, path.getVerticalOffset() + this.height / 2);
        }
        if (this.notationList.contains("box")) {
            g.drawRect(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + 2, this.width - 2, path.getVerticalOffset() + this.height - 4);
        }
        if (this.notationList.contains("roundedbox")) {
            g.drawRoundRect(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + 2, this.width - 2, this.height - 4, 6, 6);
        }
        if (this.notationList.contains("circle")) {
            g.drawOval(path.getHorizontalOffset() + this.getHorizontalOffset(), 0, Math.max(this.width, this.height) - 2, Math.max(this.width, this.height) - 2);
        }
        if (this.notationList.contains("longdiv")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, path.getVerticalOffset() + 2);
            g.drawArc(path.getHorizontalOffset() + this.getHorizontalOffset() - 3, path.getVerticalOffset() + 2, 4, this.height - 2, 90, -180);
        }
        if (this.notationList.contains("actuarial")) {
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + 1, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, path.getVerticalOffset() + 2);
            g.drawLine(path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, path.getVerticalOffset() + 2, path.getHorizontalOffset() + this.getHorizontalOffset() + this.width - 1, path.getVerticalOffset() + this.height);
        }
        this.notationList.contains("radical");
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        String notationAttr = ((WmiMathEncloseModel.WmiMathEncloseAttributeSet)this.getModel().getAttributesForRead()).getNotation();
        if (notationAttr != null) {
            String[] notations = notationAttr.split(" ");
            int i = 0;
            while (i < notations.length) {
                this.notationList.add(notations[i]);
                ++i;
            }
        }
        super.layoutView();
        if (this.notationList.contains("box") || this.notationList.contains("roundedbox") || this.notationList.contains("circle")) {
            this.widthPadding = WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(WIDTH_PADDING, null), (WmiFontAttributeSet)this.getModel().getAttributesForRead(), this.getDocumentView().isPrintView());
            this.heightPadding = WmiMathViewUtil.getPixelValueForDimension(WmiDimensionUnit.createDimension(HEIGHT_PADDING, null), (WmiFontAttributeSet)this.getModel().getAttributesForRead(), this.getDocumentView().isPrintView());
        } else if (this.notationList.contains("longdiv")) {
            this.widthPadding = 0;
            this.heightPadding = 0;
        } else if (this.notationList.contains("actuarial")) {
            this.widthPadding = 3;
            this.heightPadding = 2;
        } else if (this.notationList.contains("left") || this.notationList.contains("right")) {
            this.widthPadding = 3;
            this.heightPadding = 0;
        } else if (this.notationList.contains("top") || this.notationList.contains("bottom")) {
            this.widthPadding = 0;
            this.heightPadding = 2;
        }
        int i = 0;
        while (i < this.getChildCount()) {
            WmiGenericView child = (WmiGenericView)this.getChild(i);
            child.setHorizontalOffset(child.getHorizontalOffset() + this.widthPadding);
            child.setBaseline(child.getBaseline() + this.heightPadding);
            ++i;
        }
        this.width += this.widthPadding * 2;
        this.height += this.heightPadding * 2;
    }
}

