/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class WmiMathGlyphView
extends WmiMathTextView {
    public static int DEFAULT_FONT_SIZE = 12;
    private static int FONT_MISSING_COLOR = 0xFF0000;
    private String fontName;
    private int index;
    private GlyphVector v;
    private WmiMathGlyphModel.WmiMathGlyphAttributeSet attrs;
    private WmiTextLayout layout = null;

    public WmiMathGlyphView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        Color oldColor = g.getColor();
        if (this.v != null) {
            Color foreground = new Color(this.attrs.getForeground());
            g.setColor(foreground);
            ((Graphics2D)g).drawGlyphVector(this.v, path.getHorizontalOffset() + this.getHorizontalOffset(), path.getVerticalOffset() + this.getVerticalOffset() + this.baseline);
        } else {
            super.draw(g, path, bounds);
        }
        g.setColor(oldColor);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        super.layoutView();
        try {
            this.attrs = (WmiMathGlyphModel.WmiMathGlyphAttributeSet)this.getModel().getAttributesForRead();
            this.fontName = this.attrs.getFontFamily();
            this.index = this.attrs.getIndex();
            Font f = new Font(this.fontName, 0, this.getDocumentView().getZoomFactor() * DEFAULT_FONT_SIZE / 100);
            int numGlyphs = f.getNumGlyphs();
            if (!this.fontName.equals("") && this.index >= 0 && this.index < numGlyphs) {
                FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
                int[] indexList = new int[]{this.index};
                this.v = f.createGlyphVector(frc, indexList);
                GlyphMetrics m = this.v.getGlyphMetrics(0);
                Rectangle2D mr = m.getBounds2D();
                this.width = (int)Math.round(mr.getWidth()) + 2;
                this.width += (int)Math.floor(mr.getMinX() + mr.getWidth() + mr.getMinX() - (double)m.getAdvance());
                this.height = (int)Math.round(mr.getHeight());
            } else {
                String str = this.attrs.getAlt();
                boolean isMath = WmiModelUtil.findAncestorOfTag(this.getModel(), WmiModelTag.MATH) != null;
                this.layout = WmiTextLayout.createTextLayout(str, f, this.getDocumentView(), isMath);
                WmiFontAttributeSet errorAttrs = (WmiFontAttributeSet)this.attrs.copyAttributes();
                errorAttrs.setForeground(FONT_MISSING_COLOR);
                this.setLayout(this.layout, errorAttrs, 0);
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public void applyKerningAdjustment(boolean pre, boolean post) {
        if (this.v != null) {
            GlyphMetrics gm = this.v.getGlyphMetrics(0);
            this.width = (int)((float)this.width + gm.getAdvanceX());
        }
    }
}

