/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFractionView;
import com.maplesoft.mathdoc.view.math.WmiMathInlineView;
import com.maplesoft.mathdoc.view.math.WmiMathSpaceView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import com.maplesoft.mathdoc.view.math.WmiOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderOverView;
import com.maplesoft.mathdoc.view.math.WmiUnderView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAngleBracketRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiBaselineProvider;
import com.maplesoft.mathdoc.view.math.renderers.WmiBraceRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyAccentRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyArrowRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiHorizontalStretchyBraceRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiIntegralRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiLimitRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiOperatorRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiParenRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiSquareBracketRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiUnaryMinusRenderer;
import com.maplesoft.mathdoc.view.math.renderers.WmiVerticalOffsetProvider;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;

public class WmiMathOperatorView
extends WmiMathTextView {
    private static HashMap specialRendererMap = null;
    private static HashMap specialRendererMapEsstix = null;
    private static HashMap operatorSpaceDimensions = new HashMap();
    private static HashSet stretchyOperatorSet = null;
    private static final String ALT_ABS_BAR = "\u2223";
    private static final String LEFT_BRACKETING_BAR = "\u23a2";
    private static final String RIGHT_BRACKETING_BAR = "\u23a5";
    private static final String DOUBLE_VERTICAL_BAR = "\u2225";
    private static final String DOUBLE_VERTICAL_BAR_ALT = "\u2016";
    private static final String LEFT_CEIL = "\u2308";
    private static final String RIGHT_CEIL = "\u2309";
    private static final String LEFT_FLOOR = "\u230a";
    private static final String RIGHT_FLOOR = "\u230b";
    private static final String LEFT_WHITE_SQUARE = "\u27e6";
    private static final String RIGHT_WHITE_SQUARE = "\u27e7";
    private static final String LEFT_ANGLE_BRACKET = "\u2329";
    private static final String RIGHT_ANGLE_BRACKET = "\u232a";
    private static final String LEFT_DOUBLE_ANGLE_BRACKET = "\u300a";
    private static final String RIGHT_DOUBLE_ANGLE_BRACKET = "\u300b";
    private static final String CONTOUR_INTEGRAL = "\u222e";
    private static final String DOUBLE_CONTOUR_INTEGRAL = "\u222f";
    private static final String TRIPLE_CONTOUR_INTEGRAL = "\u2230";
    private static final String CW_CONTOUR_INTEGRAL = "\u2232";
    private static final String CCW_CONTOUR_INTEGRAL = "\u2233";
    private static final String CIRCULATION_FUNCTION = "\u2a10";
    private static final String CW_INTEGRAL = "\u2231";
    private static final String FINITE_PART_INTEGRAL = "\u2a0d";
    private static final String QUATGERNION_INTEGRAL = "\u2a16";
    private static final String DOUBLE_INTEGRAL = "\u222c";
    private static final String TRIPLE_INTEGRAL = "\u222d";
    private static final String UMINUS_FONT_NAME = "/com/maplesoft/mathdoc/font/resources/ESSTIX8_.TTF";
    private static final String UMINUS = "\u2212";
    private static final float FRACTION_PREPAD_ADJUST = 2.0f;
    private int stretchHeight = 0;
    private int stretchWidth = 0;
    WmiOperatorRenderer renderer = null;
    private int leftPadding = 0;
    private int rightPadding = 0;
    private int underlineHorizontalOffs = 0;
    private int underlineEndHorizontalOffs;
    public static final WmiBaselineProvider LARGE_OP_BASELINE_PROVIDER;
    private WmiBaselineProvider baselineSource = null;
    private WmiVerticalOffsetProvider voffsSource = null;

    static {
        specialRendererMap = new HashMap();
        specialRendererMap.put("(", new WmiParenRenderer.WmiLeftParenRenderer());
        specialRendererMap.put(")", new WmiParenRenderer.WmiRightParenRenderer());
        specialRendererMap.put("{", new WmiBraceRenderer.WmiLeftBraceRenderer());
        specialRendererMap.put("}", new WmiBraceRenderer.WmiRightBraceRenderer());
        specialRendererMap.put(UMINUS, new WmiUnaryMinusRenderer());
        specialRendererMap.put("\u222b", new WmiIntegralRenderer());
        specialRendererMap.put(CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiContourIntegralRenderer());
        specialRendererMap.put(DOUBLE_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiDoubleContourIntegralRenderer());
        specialRendererMap.put(TRIPLE_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiTripleContourIntegralRenderer());
        specialRendererMap.put(CW_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiCWContourIntegralRenderer());
        specialRendererMap.put(CCW_CONTOUR_INTEGRAL, new WmiIntegralRenderer.WmiCCWContourIntegralRenderer());
        specialRendererMap.put(CIRCULATION_FUNCTION, new WmiIntegralRenderer.WmiCirculationFunctionRenderer());
        specialRendererMap.put(CW_INTEGRAL, new WmiIntegralRenderer.WmiCWIntegrationRenderer());
        specialRendererMap.put(FINITE_PART_INTEGRAL, new WmiIntegralRenderer.WmiFinitePartIntegrationRenderer());
        specialRendererMap.put(QUATGERNION_INTEGRAL, new WmiIntegralRenderer.WmiQuaternionIntegrationRenderer());
        specialRendererMap.put(DOUBLE_INTEGRAL, new WmiIntegralRenderer.WmiDoubleIntegralRenderer());
        specialRendererMap.put(TRIPLE_INTEGRAL, new WmiIntegralRenderer.WmiTripleIntegralRenderer());
        specialRendererMap.put(String.valueOf('\u00af'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('\u00af')));
        specialRendererMap.put(String.valueOf('^'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('^')));
        specialRendererMap.put(String.valueOf('~'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('~')));
        specialRendererMap.put(String.valueOf('\u2190'), new WmiHorizontalStretchyArrowRenderer('\u2190'));
        specialRendererMap.put(String.valueOf('\u2192'), new WmiHorizontalStretchyArrowRenderer('\u2192'));
        specialRendererMap.put(String.valueOf('\u2194'), new WmiHorizontalStretchyArrowRenderer('\u2194'));
        specialRendererMap.put(String.valueOf('\u21c0'), new WmiHorizontalStretchyArrowRenderer('\u21c0'));
        specialRendererMap.put(String.valueOf('\u21c1'), new WmiHorizontalStretchyArrowRenderer('\u21c1'));
        specialRendererMap.put(String.valueOf('\u21bc'), new WmiHorizontalStretchyArrowRenderer('\u21bc'));
        specialRendererMap.put(String.valueOf('\u21bd'), new WmiHorizontalStretchyArrowRenderer('\u21bd'));
        specialRendererMap.put(String.valueOf('\u0305'), new WmiHorizontalStretchyArrowRenderer('\u0305'));
        specialRendererMap.put(String.valueOf('\u21cc'), new WmiHorizontalStretchyArrowRenderer('\u21cc'));
        specialRendererMap.put(String.valueOf('\u21cb'), new WmiHorizontalStretchyArrowRenderer('\u21cb'));
        specialRendererMap.put(String.valueOf('\u21d0'), new WmiHorizontalStretchyArrowRenderer('\u21d0'));
        specialRendererMap.put(String.valueOf('\u21d2'), new WmiHorizontalStretchyArrowRenderer('\u21d2'));
        specialRendererMap.put(String.valueOf('\u21da'), new WmiHorizontalStretchyArrowRenderer('\u21da'));
        specialRendererMap.put(String.valueOf('\u21db'), new WmiHorizontalStretchyArrowRenderer('\u21db'));
        specialRendererMap.put(String.valueOf('\u219a'), new WmiHorizontalStretchyArrowRenderer('\u219a'));
        specialRendererMap.put(String.valueOf('\u219b'), new WmiHorizontalStretchyArrowRenderer('\u219b'));
        specialRendererMap.put(String.valueOf('\u21c7'), new WmiHorizontalStretchyArrowRenderer('\u21c7'));
        specialRendererMap.put(String.valueOf('\u21c9'), new WmiHorizontalStretchyArrowRenderer('\u21c9'));
        specialRendererMap.put(String.valueOf('\u21c6'), new WmiHorizontalStretchyArrowRenderer('\u21c6'));
        specialRendererMap.put(String.valueOf('\u21c4'), new WmiHorizontalStretchyArrowRenderer('\u21c4'));
        specialRendererMap.put(String.valueOf('\u21d4'), new WmiHorizontalStretchyArrowRenderer('\u21d4'));
        specialRendererMap.put(String.valueOf('\u21cf'), new WmiHorizontalStretchyArrowRenderer('\u21cf'));
        specialRendererMap.put(String.valueOf('\u21cd'), new WmiHorizontalStretchyArrowRenderer('\u21cd'));
        specialRendererMap.put(String.valueOf('\u21ce'), new WmiHorizontalStretchyArrowRenderer('\u21ce'));
        specialRendererMap.put(String.valueOf('\u21a6'), new WmiHorizontalStretchyArrowRenderer('\u21a6'));
        specialRendererMap.put(String.valueOf('\u2905'), new WmiHorizontalStretchyArrowRenderer('\u2905'));
        specialRendererMap.put(String.valueOf('\u219e'), new WmiHorizontalStretchyArrowRenderer('\u219e'));
        specialRendererMap.put(String.valueOf('\u21a0'), new WmiHorizontalStretchyArrowRenderer('\u21a0'));
        specialRendererMap.put(String.valueOf('\u21a2'), new WmiHorizontalStretchyArrowRenderer('\u21a2'));
        specialRendererMap.put(String.valueOf('\u21a3'), new WmiHorizontalStretchyArrowRenderer('\u21a3'));
        specialRendererMap.put(String.valueOf('\u22c0'), new WmiHorizontalStretchyAccentRenderer('\u22c0'));
        specialRendererMap.put(String.valueOf('\u2227'), new WmiHorizontalStretchyAccentRenderer('\u2227'));
        specialRendererMap.put(String.valueOf('\u02c6'), new WmiHorizontalStretchyAccentRenderer('\u02c6'));
        specialRendererMap.put(String.valueOf('\ufe37'), new WmiHorizontalStretchyBraceRenderer(String.valueOf('\ufe37')));
        specialRendererMap.put(String.valueOf('\ufe38'), new WmiHorizontalStretchyBraceRenderer(String.valueOf('\ufe38')));
        specialRendererMap.put("lim", new WmiLimitRenderer());
        WmiSquareBracketRenderer.WmiSingleVerticalBarRenderer absRenderer = new WmiSquareBracketRenderer.WmiSingleVerticalBarRenderer();
        specialRendererMap.put("|", absRenderer);
        specialRendererMap.put(ALT_ABS_BAR, absRenderer);
        specialRendererMap.put(LEFT_BRACKETING_BAR, absRenderer);
        specialRendererMap.put(RIGHT_BRACKETING_BAR, absRenderer);
        specialRendererMap.put(DOUBLE_VERTICAL_BAR, new WmiSquareBracketRenderer.WmiDoubleVerticalBarRenderer());
        specialRendererMap.put(DOUBLE_VERTICAL_BAR_ALT, new WmiSquareBracketRenderer.WmiDoubleVerticalBarRenderer());
        specialRendererMap.put(LEFT_CEIL, new WmiSquareBracketRenderer.WmiLeftCeilingRenderer());
        specialRendererMap.put(RIGHT_CEIL, new WmiSquareBracketRenderer.WmiRightCeilingRenderer());
        specialRendererMap.put(LEFT_FLOOR, new WmiSquareBracketRenderer.WmiLeftFloorRenderer());
        specialRendererMap.put(RIGHT_FLOOR, new WmiSquareBracketRenderer.WmiRightFloorRenderer());
        specialRendererMap.put(LEFT_WHITE_SQUARE, new WmiSquareBracketRenderer.WmiDoubleLeftBracketRenderer());
        specialRendererMap.put(RIGHT_WHITE_SQUARE, new WmiSquareBracketRenderer.WmiDoubleRightBracketRenderer());
        specialRendererMap.put("[", new WmiSquareBracketRenderer.WmiLeftSquareBracketRenderer());
        specialRendererMap.put("]", new WmiSquareBracketRenderer.WmiRightSquareBracketRenderer());
        specialRendererMap.put(LEFT_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u2329'));
        specialRendererMap.put(RIGHT_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u232a'));
        specialRendererMap.put(LEFT_DOUBLE_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u300a'));
        specialRendererMap.put(RIGHT_DOUBLE_ANGLE_BRACKET, new WmiAngleBracketRenderer('\u300b'));
        if (!RuntimePlatform.isMac()) {
            RuntimePlatform.setEsstix(true);
            specialRendererMapEsstix = new HashMap();
            specialRendererMapEsstix.put(String.valueOf('\u00af'), new WmiHorizontalStretchyAccentRenderer(String.valueOf('\u00af')));
            specialRendererMapEsstix.put("lim", new WmiLimitRenderer());
            RuntimePlatform.setEsstix(false);
        }
        stretchyOperatorSet = new HashSet();
        stretchyOperatorSet.add("(");
        stretchyOperatorSet.add(")");
        stretchyOperatorSet.add("{");
        stretchyOperatorSet.add("}");
        stretchyOperatorSet.add("[");
        stretchyOperatorSet.add("]");
        stretchyOperatorSet.add("|");
        stretchyOperatorSet.add(ALT_ABS_BAR);
        stretchyOperatorSet.add(DOUBLE_VERTICAL_BAR);
        stretchyOperatorSet.add("\u222b");
        stretchyOperatorSet.add(CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(DOUBLE_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(TRIPLE_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(CW_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(CCW_CONTOUR_INTEGRAL);
        stretchyOperatorSet.add(CIRCULATION_FUNCTION);
        stretchyOperatorSet.add(CW_INTEGRAL);
        stretchyOperatorSet.add(FINITE_PART_INTEGRAL);
        stretchyOperatorSet.add(QUATGERNION_INTEGRAL);
        stretchyOperatorSet.add(DOUBLE_INTEGRAL);
        stretchyOperatorSet.add(TRIPLE_INTEGRAL);
        stretchyOperatorSet.add(LEFT_CEIL);
        stretchyOperatorSet.add(RIGHT_CEIL);
        stretchyOperatorSet.add(LEFT_FLOOR);
        stretchyOperatorSet.add(RIGHT_FLOOR);
        stretchyOperatorSet.add(LEFT_WHITE_SQUARE);
        stretchyOperatorSet.add(RIGHT_WHITE_SQUARE);
        stretchyOperatorSet.add(LEFT_ANGLE_BRACKET);
        stretchyOperatorSet.add(RIGHT_ANGLE_BRACKET);
        stretchyOperatorSet.add(LEFT_DOUBLE_ANGLE_BRACKET);
        stretchyOperatorSet.add(RIGHT_DOUBLE_ANGLE_BRACKET);
        operatorSpaceDimensions.put("veryverythinmathspace", WmiDimensionUnit.createDimension("0.0555556em", null));
        operatorSpaceDimensions.put("verythinmathspace", WmiDimensionUnit.createDimension("0.111111em", null));
        operatorSpaceDimensions.put("thinmathspace", WmiDimensionUnit.createDimension("0.166667em", null));
        operatorSpaceDimensions.put("mediummathspace", WmiDimensionUnit.createDimension("0.222222em", null));
        operatorSpaceDimensions.put("thickmathspace", WmiDimensionUnit.createDimension("0.277778em", null));
        operatorSpaceDimensions.put("verythickmathspace", WmiDimensionUnit.createDimension("0.333333em", null));
        operatorSpaceDimensions.put("veryverythickmathspace", WmiDimensionUnit.createDimension("0.388889em", null));
        LARGE_OP_BASELINE_PROVIDER = new WmiLargeOpBaselineProvider();
    }

    public WmiMathOperatorView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiMathOperatorModel model;
            String label;
            if (this.isLargeOp()) {
                this.baselineSource = LARGE_OP_BASELINE_PROVIDER;
            }
            super.layoutView();
            String text = this.getText();
            this.initializeRenderer();
            if (this.renderer != null) {
                if (this.renderer.applyRenderer(this, 0)) {
                    this.renderer.layoutView(this, 0);
                } else {
                    this.renderer = null;
                }
            }
            boolean uminus = false;
            if (text.equals(UMINUS) && "&uminus0;".equals(label = (model = (WmiMathOperatorModel)this.getModel()).getSemanticLabel())) {
                uminus = true;
            }
            if (!uminus) {
                this.addPadding();
            }
            if (text.equals("&minus;") && this.getNextView(2) instanceof WmiFractionView) {
                this.leftPadding += Math.round(0.02f * (float)this.getZoomFactor());
            }
        }
    }

    public void resetStretchy() throws WmiNoReadAccessException {
        String text = this.getText();
        if (stretchyOperatorSet.contains(text)) {
            this.resetRenderer();
        }
    }

    public void resetRenderer() throws WmiNoReadAccessException {
        if (this.renderer != null) {
            this.renderer = null;
            this.markInvalid(1);
            this.layoutView();
        }
    }

    public boolean layoutStretchView(int height) throws WmiNoReadAccessException {
        boolean applied = false;
        this.initializeRenderer();
        if (this.renderer != null && this.renderer.isStretchy()) {
            if (this.renderer.applyRenderer(this, height)) {
                applied = true;
                this.renderer.layoutView(this, height);
            } else {
                this.renderer = null;
            }
        }
        return applied;
    }

    protected void initializeRenderer() throws WmiNoReadAccessException {
        String text = this.getText();
        this.renderer = WmiMathOperatorView.getRenderer(text);
    }

    public static WmiOperatorRenderer getRenderer(String text) {
        WmiOperatorRenderer renderer = null;
        renderer = RuntimePlatform.isMac() || !RuntimePlatform.isEsstix() ? (WmiOperatorRenderer)specialRendererMap.get(text) : (WmiOperatorRenderer)specialRendererMapEsstix.get(text);
        return renderer;
    }

    @Override
    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int zoom = super.getCorrectedZoomFactor();
        if (this.isLargeOp()) {
            zoom = Math.round((float)zoom * 2.0f);
        }
        return zoom;
    }

    protected boolean isLargeOp() throws WmiNoReadAccessException {
        WmiModel model = this.getModel();
        WmiAttributeSet attributes = model.getAttributesForRead();
        boolean large = false;
        if (attributes instanceof WmiMathOperatorModel.WmiMathOperatorAttributeSet) {
            large = ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)attributes).isLargeOp() && !stretchyOperatorSet.contains(this.getText());
        }
        return large;
    }

    public boolean isStretchyOp() throws WmiNoReadAccessException {
        return stretchyOperatorSet.contains(this.getText());
    }

    @Override
    public boolean enableKernAdjust() {
        return false;
    }

    @Override
    public int getUnderlineHorizontalOffset() {
        return this.underlineHorizontalOffs;
    }

    @Override
    public int getUnderlineHorizontalEndOffset() {
        return this.underlineEndHorizontalOffs;
    }

    public void setStretchHeight(int height) throws WmiNoReadAccessException {
        if (this.stretchHeight == 0) {
            this.stretchHeight = height;
        }
    }

    public int getStretchHeight() {
        return this.stretchHeight;
    }

    public void setStretchWidth(int width) throws WmiNoReadAccessException {
        this.stretchWidth = width;
    }

    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public int getHeight() {
        if (this.stretchHeight > 0 && this.stretchHeight > this.height) {
            return this.stretchHeight;
        }
        return super.getHeight();
    }

    @Override
    public int getWidth() {
        if (this.stretchWidth > 0 && this.stretchWidth > this.width) {
            return this.stretchWidth;
        }
        return super.getWidth();
    }

    @Override
    public int getLeftPadding() {
        return this.leftPadding;
    }

    @Override
    public int getRightPadding() {
        return this.rightPadding;
    }

    @Override
    public void invalidate(int flag) {
        super.invalidate(flag);
        this.stretchHeight = 0;
        this.stretchWidth = 0;
    }

    public void setBaselineProvider(WmiBaselineProvider baselineSource) {
        this.baselineSource = baselineSource;
    }

    @Override
    public int getBaseline() {
        return this.baselineSource != null ? this.baselineSource.calculateBaseline(this) : super.getBaseline();
    }

    public void setVerticalOffsetProvider(WmiVerticalOffsetProvider provider) {
        this.voffsSource = provider;
    }

    @Override
    public int getVerticalOffset() {
        return this.voffsSource != null ? this.voffsSource.calculateVerticalOffset(this) : super.getVerticalOffset();
    }

    public int getOriginalVerticalOffset() {
        return super.getVerticalOffset();
    }

    protected int getOriginalBaseline() {
        return super.getBaseline();
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        if (this.renderer != null && !this.renderer.isLayoutOnly()) {
            this.renderer.draw(g, path, bounds, this);
        } else {
            super.draw(g, path, bounds);
        }
    }

    public void drawText(Graphics g, WmiRenderPath path, Rectangle bounds) {
        super.draw(g, path, bounds);
    }

    public boolean hasRenderer() {
        return this.getRenderer() != null;
    }

    public WmiOperatorRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public int getHorizontalOffset(int index) {
        return this.getCaretPosition(index, true);
    }

    @Override
    protected int getCaretPosition(int index, boolean before) {
        int pos = 0;
        pos = this.renderer != null ? (index == 0 && before ? 0 : this.getWidth()) : super.getCaretPosition(index, before);
        return pos;
    }

    @Override
    public int[] getCaretBounds(int offset) throws WmiNoReadAccessException {
        int[] res = null;
        if (this.renderer != null && !this.renderer.isLayoutOnly()) {
            WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(this);
            res = new int[4];
            WmiMathDocumentView docView = this.getDocumentView();
            Point pt = WmiViewUtil.getAbsoluteOffset(this);
            if (container != null && container != docView) {
                Point origin = WmiViewUtil.getAbsoluteOffset(container);
                pt.x -= origin.x;
                pt.y -= origin.y;
            }
            res[0] = pt.x;
            res[1] = pt.y;
            res[2] = res[0] + this.width;
            res[3] = res[1] + this.height;
        } else {
            res = super.getCaretBounds(offset);
        }
        return res;
    }

    @Override
    public int getOffset(Point pt) {
        int pos = 0;
        pos = this.renderer != null ? (pt.x >= this.getWidth() / 2 ? 1 : 0) : super.getOffset(pt);
        return pos;
    }

    private void addPadding() throws WmiNoReadAccessException {
        int baseEm;
        WmiMathDocumentView docView;
        try {
            if (this.isOverUnderElement()) {
                return;
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        boolean applyLeftPadding = true;
        boolean applyRightPadding = true;
        if (this.renderer == null) {
            WmiView leftView = null;
            WmiView rightView = null;
            WmiCompositeView parent = this.getParentView();
            if (parent instanceof WmiInlineView) {
                int index = parent.indexOf(this);
                if (index > 0) {
                    leftView = parent.getChild(index - 1);
                }
                if (index < parent.getChildCount() - 1) {
                    rightView = parent.getChild(index + 1);
                }
            } else {
                applyRightPadding = false;
                applyLeftPadding = false;
            }
            if (leftView instanceof WmiMathOperatorView) {
                applyLeftPadding = false;
            }
            if (leftView instanceof WmiMathSpaceView && ((WmiMathSpaceView)leftView).getWidth() > 0) {
                applyLeftPadding = false;
            }
            if (rightView instanceof WmiMathOperatorView) {
                applyRightPadding = false;
            }
            if (rightView instanceof WmiMathSpaceView) {
                WmiMathSpaceView space = (WmiMathSpaceView)rightView;
                if (!space.isLayoutValid()) {
                    space.layoutView();
                }
                if (space.getWidth() > 0) {
                    applyRightPadding = false;
                }
            }
        }
        float lspace = 0.0f;
        float rspace = 0.0f;
        boolean ptPad = false;
        WmiFontAttributeSet set = this.getFontAttributes();
        if (set instanceof WmiMathOperatorModel.WmiMathOperatorAttributeSet) {
            WmiMathOperatorModel.WmiMathOperatorAttributeSet attribs = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)set;
            lspace = attribs.getLSpace();
            rspace = attribs.getRSpace();
            ptPad = attribs.hasOperatorStyle(16384);
        }
        boolean forPrint = (docView = this.getDocumentView()) != null ? docView.isPrintView() : false;
        WmiTextLayout layout = this.getLayout();
        Font font = layout != null ? layout.getFont() : null;
        WmiFontMetrics metrics = font != null ? WmiFontResolver.getFontMetrics(font) : null;
        int n = baseEm = metrics != null && !ptPad ? metrics.getFontProperty(3, forPrint) : 1;
        if (lspace > 0.0f && applyLeftPadding) {
            this.leftPadding = Math.round(lspace * (float)baseEm);
            this.width += this.leftPadding;
            this.underlineHorizontalOffs = -this.leftPadding;
        } else {
            this.leftPadding = 0;
        }
        if (rspace > 0.0f && applyRightPadding) {
            this.rightPadding = Math.round(rspace * (float)baseEm);
            this.width += this.rightPadding;
        } else {
            this.rightPadding = 0;
        }
    }

    private boolean isOverUnderElement() throws WmiNoReadAccessException {
        WmiCompositeView parent = this.getParentView();
        WmiView child = this;
        if (parent instanceof WmiMathInlineView && parent.getChildCount() == 2 && WmiModelUtil.isEmptyIdentifierModel(parent.getChild(0).getModel())) {
            child = parent;
            parent = parent.getParentView();
        }
        if (parent instanceof WmiOverView) {
            return ((WmiOverView)parent).getChild(1) == child;
        }
        if (parent instanceof WmiUnderView) {
            return ((WmiUnderView)parent).getChild(1) == child;
        }
        if (parent instanceof WmiUnderOverView) {
            return ((WmiUnderOverView)parent).getChild(2) == child || ((WmiUnderOverView)parent).getChild(1) == child;
        }
        return false;
    }

    public static WmiDimensionUnit getNamedDimension(String key) {
        return (WmiDimensionUnit)operatorSpaceDimensions.get(key);
    }

    public static void updateOperatorSpaceDimension(String space, String width) {
        operatorSpaceDimensions.put(space, WmiDimensionUnit.createDimension(width, null));
    }

    @Override
    public int computePostKernAdjustment() {
        int kernAdjust = 0;
        if (this.enableKernAdjust()) {
            kernAdjust = this.hasRenderer() ? this.renderer.computePostKernAdjustment(this) : super.computePostKernAdjustment();
        }
        return kernAdjust;
    }

    @Override
    public int computePreKernAdjustment() {
        int kernAdjust = 0;
        if (this.enableKernAdjust()) {
            kernAdjust = this.hasRenderer() ? this.renderer.computePreKernAdjustment(this) : super.computePreKernAdjustment();
        }
        return kernAdjust;
    }

    public boolean forcePostKernAdjustment() {
        return this.hasRenderer() ? this.renderer.forcePostKernAdjustment(this) : false;
    }

    public boolean forcePreKernAdjustment() {
        return this.hasRenderer() ? this.renderer.forcePreKernAdjustment(this) : false;
    }

    @Override
    public int computeSpaceAbove() {
        return this.hasRenderer() ? this.renderer.computeSpaceAbove(this) : super.computeSpaceAbove();
    }

    @Override
    public int computeSpaceBelow() {
        return this.hasRenderer() ? this.renderer.computeSpaceBelow(this) : super.computeSpaceBelow();
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        int index = this.getSplitIndex(horizontalOffset, breakWidth, thresholdCost);
        if (index > 0 || index == 0 && !paragraph.isStartOfLine(this)) {
            WmiCompositeView parent = this.getParentView();
            String text = this.getText();
            int consume = text != null && text.equals(" ") ? 1 : 0;
            paragraph.split(parent, index, consume);
            success = 2;
        }
        return success;
    }

    @Override
    public int doExplicitLinebreak(WmiParagraphView paragraph) throws WmiNoReadAccessException {
        return 0;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) throws WmiNoReadAccessException {
        return 0;
    }

    @Override
    public boolean hasGoodBreakpoint(int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        return this.getSplitIndex(horizontalOffset, breakWidth, thresholdCost) >= 0;
    }

    private int getSplitIndex(int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        boolean success = false;
        int index = 0;
        String text = this.getText();
        int ch = 0;
        if (text != null) {
            boolean breakAfter;
            if (text.length() > 0) {
                ch = text.charAt(0);
            }
            boolean bl = breakAfter = ch == 59 || ch == 58 || ch == 44 || ch == 33;
            if (!breakAfter || horizontalOffset + this.getWidth() < breakWidth) {
                WmiCompositeView parent;
                if (!(text.length() == 0 && thresholdCost < 2 || ch == 32 && thresholdCost < 1 || (index = (parent = this.getParentView()).indexOf(this)) < 0)) {
                    if (breakAfter) {
                        ++index;
                    }
                    success = true;
                }
            } else if (thresholdCost == 2) {
                WmiCompositeView parent = this.getParentView();
                index = parent.indexOf(this);
                success = index >= 0;
            }
        }
        return success ? index : -1;
    }

    private static class WmiLargeOpBaselineProvider
    implements WmiBaselineProvider {
        private WmiLargeOpBaselineProvider() {
        }

        @Override
        public int calculateBaseline(WmiMathOperatorView view) {
            int rbaseline = view.getOriginalBaseline();
            rbaseline = (int)((float)rbaseline - (float)view.getHeight() * 0.1f);
            return rbaseline;
        }
    }
}

