/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiNonSplitableInlineView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiMathPaddedView
extends WmiNonSplitableInlineView {
    public WmiMathPaddedView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        super.draw(g, path, bounds);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            super.layoutView();
            WmiModel model = this.getModel();
            if (model instanceof WmiMathPaddedModel) {
                WmiMathPaddedModel.WmiMathPaddedAttributeSet attrs = (WmiMathPaddedModel.WmiMathPaddedAttributeSet)model.getAttributesForRead();
                WmiPositionedView childView = (WmiPositionedView)this.getChild(0);
                int newWidth = this.computeDimension(attrs.getWidth(), attrs, this.getWidth());
                int originalHeight = this.getHeight();
                int originalBaseline = this.getBaseline();
                int originalDepth = originalHeight - originalBaseline;
                int newBaseline = this.computeDimension(attrs.getHeight(), attrs, this.getBaseline());
                this.setBaseline(newBaseline);
                this.setHeight(newBaseline + originalDepth);
                int newDepth = this.computeDimension(attrs.getDepth(), attrs, originalDepth);
                this.setHeight(originalBaseline + newDepth);
                childView.setVerticalOffset(this.getBaseline() - originalBaseline);
                int originalWidth = this.getWidth();
                int lspace = this.computeDimension(attrs.getLSpace(), attrs, this.getHorizontalOffset());
                childView.setHorizontalOffset(lspace);
                this.setWidth(Math.max(newWidth += lspace, 0));
            }
        }
    }

    private int computeDimension(WmiMathPaddedModel.WmiMathSpaceDimensionUnit unit, WmiMathPaddedModel.WmiMathPaddedAttributeSet attrs, int originalValue) {
        int newValue = originalValue;
        if (unit.getDimension().equals("")) {
            newValue = unit.getUnit().equals("%") ? (unit.getSign() == 0 ? Math.round((float)originalValue * unit.getUnitsValue() / 100.0f) : originalValue + Math.round((float)originalValue * unit.getUnitsValue() / 100.0f * (float)unit.getSign())) : (unit.getSign() == 0 ? WmiMathViewUtil.getPixelValueForDimension(unit, attrs, this.getDocumentView().isPrintView()) : originalValue + WmiMathViewUtil.getPixelValueForDimension(unit, attrs, this.getDocumentView().isPrintView()) * unit.getSign());
        } else {
            String dimension = unit.getDimension();
            WmiPositionedView childView = (WmiPositionedView)this.getChild(0);
            int v = 0;
            if (dimension.equals("width")) {
                v = childView.getWidth();
            } else if (dimension.equals("height")) {
                v = childView.getHeight();
            } else if (dimension.equals("depth")) {
                v = childView.getVerticalOffset();
            } else if (dimension.equals("lspace")) {
                v = childView.getHorizontalOffset();
            }
            if (unit.getUnit().equals("")) {
                newValue = unit.getSign() != 0 ? v + Math.round(unit.getUnitsValue() * (float)v * (float)unit.getSign()) : Math.round(unit.getUnitsValue() * (float)v);
            } else if (unit.getUnit().equals("%")) {
                newValue = unit.getSign() == 0 ? Math.round((float)v * unit.getUnitsValue() / 100.0f) : originalValue + Math.round((float)v * unit.getUnitsValue() / 100.0f * (float)unit.getSign());
            }
        }
        return newValue;
    }

    public int getOffset(Point pt) {
        return 0;
    }

    @Override
    public void setPositionMarker(int offset) {
    }

    public int getTraversableCount() {
        return 0;
    }

    @Override
    public boolean isNavagableView() {
        return false;
    }

    @Override
    public void adjustVerticalLayout() throws WmiNoReadAccessException {
    }
}

