/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathAlignGroupView;
import com.maplesoft.mathdoc.view.math.WmiMathTableRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableView;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;

public class WmiMathTableCellView
extends WmiParagraphView {
    private static final int CHILD_INDEX = 0;
    private static final boolean DISPLAY_TABLE_BOX = false;
    private Integer verticalAlignment = WmiMathTableView.ALIGN_STYLE_UNSET;
    private Integer horizontalAlignment = WmiMathTableView.ALIGN_STYLE_UNSET;
    private int rowSpan;
    private int columnSpan;
    private int cellBreakWidth;
    private int rowIndex;
    private int columnIndex;
    private ArrayList alignGroupAlignments = new ArrayList();

    public WmiMathTableCellView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        this.layoutView(true);
    }

    @Override
    public int getLinebreakWidth() {
        return this.cellBreakWidth;
    }

    public void layoutWithAlignment() throws WmiNoReadAccessException {
        WmiMathTableRowView row = (WmiMathTableRowView)this.getParentView();
        WmiMathTableView table = (WmiMathTableView)row.getParentView();
        ArrayList maxAlignGroupWidths = table.maxAlignGroupWidths[this.columnIndex];
        WmiInlineView inline = (WmiInlineView)this.getChild(0);
        int alignGroupOffset = 0;
        int alignGroupCounter = 0;
        WmiMathAlignGroupView groupView = (WmiMathAlignGroupView)WmiViewUtil.findFirstDescendantOfTag(inline, WmiModelTag.MATH_ALIGN_GROUP);
        while (groupView != null) {
            int childIndex;
            ArrayList alignGroupWidths = table.alignGroupWidths[this.rowIndex][this.columnIndex];
            ((WmiPositionedView)((Object)groupView.getParentView())).setHorizontalOffset(0);
            int leftMaxWidth = (Integer)maxAlignGroupWidths.get(alignGroupCounter * 2);
            int rightMaxWidth = (Integer)maxAlignGroupWidths.get(alignGroupCounter * 2 + 1);
            int offset = leftMaxWidth - (Integer)alignGroupWidths.get(alignGroupCounter * 2);
            WmiCompositeView parent = groupView.getParentView().getParentView();
            if (parent instanceof WmiPositionedView) {
                ((WmiPositionedView)((Object)parent)).setHorizontalOffset(0);
            }
            WmiPositionedView view = (WmiPositionedView)WmiViewUtil.findNextSibling(groupView);
            view.setHorizontalOffset(alignGroupOffset + offset);
            offset += view.getWidth();
            int i = childIndex = parent.indexOf(groupView.getParentView()) + 1;
            while (i < parent.getChildCount()) {
                view = (WmiPositionedView)parent.getChild(i);
                if (WmiViewUtil.findFirstDescendantOfTag(view, WmiModelTag.MATH_ALIGN_GROUP) != null) break;
                view.setHorizontalOffset(alignGroupOffset + offset);
                offset += view.getWidth();
                ++i;
            }
            alignGroupOffset += leftMaxWidth + rightMaxWidth;
            ++alignGroupCounter;
            groupView = (WmiMathAlignGroupView)WmiViewUtil.findNextDescendantOfTag(inline, groupView, WmiModelTag.MATH_ALIGN_GROUP);
        }
    }

    public void layoutView(boolean linebreak) throws WmiNoReadAccessException {
        this.layoutView(linebreak, false);
    }

    public void layoutView(boolean linebreak, boolean alignment) throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs = (WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet)this.getModel().getAttributesForRead();
            this.getRowAlignment(attrs);
            this.getColumnAlignment(attrs);
            this.getRowSpan(attrs);
            this.getColumnSpan(attrs);
            this.getAlignGroupAlignments(attrs);
            WmiMathTableView table = this.getTableView();
            int allowedWidth = 0;
            if (table != null) {
                int i = this.columnIndex;
                while (i < this.columnIndex + this.columnSpan) {
                    allowedWidth += table.getMaximumColumnWidth(i);
                    ++i;
                }
            } else {
                allowedWidth = Integer.MAX_VALUE;
            }
            this.cellBreakWidth = allowedWidth > 0 && linebreak ? allowedWidth : Integer.MAX_VALUE;
            super.layoutView();
            this.width = 0;
            int size = this.getChildCount();
            int i = 0;
            while (i < size) {
                WmiPositionedView child = (WmiPositionedView)this.getChild(i);
                if (child.getWidth() > this.width) {
                    this.width = child.getWidth();
                }
                ++i;
            }
            this.adjustAlignment(this.width);
            if (size == 1 && alignment && this.findAlignmentElement() != null) {
                this.layoutWithAlignment();
                this.width = table.getMaximumColumnWidth(this.columnIndex);
            }
            if (table != null) {
                table.cellHeights[this.rowIndex][this.columnIndex] = this.height;
            }
            this.markValid(1);
            this.checkRepaint();
        }
    }

    private WmiView findAlignmentElement() {
        return WmiViewUtil.findFirstDescendantOfTag(this, WmiModelTag.MATH_ALIGN_GROUP);
    }

    private WmiMathTableView getTableView() {
        WmiCompositeView parent = this.getParentView();
        WmiCompositeView grandParent = parent != null ? parent.getParentView() : null;
        return grandParent instanceof WmiMathTableView ? (WmiMathTableView)grandParent : null;
    }

    private WmiMathTableRowView getRowView() {
        WmiCompositeView parent = this.getParentView();
        return parent instanceof WmiMathTableRowView ? (WmiMathTableRowView)parent : null;
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds) {
        WmiMathTableRowView rowView = this.getRowView();
        WmiMathTableView tableView = this.getTableView();
        if (tableView != null && tableView.drawOverlappedLabel() && rowView != null && !rowView.isLabelRow() && (tableView.getSide() == WmiMathTableView.LEFT_OVERLAP_SIDE && rowView.indexOf(this) == 0 || tableView.getSide() == WmiMathTableView.RIGHT_OVERLAP_SIDE && rowView.indexOf(this) == rowView.getChildCount() - 1)) {
            return;
        }
        super.draw(g, path, bounds);
    }

    @Override
    public void setLinebreakWidth(int width) {
        this.cellBreakWidth = width;
    }

    public Integer getVerticalAlignment() {
        return this.verticalAlignment;
    }

    private void getRowAlignment(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs) {
        String alignment;
        String string = alignment = attrs.getRowAlign() != null ? attrs.getRowAlign() : "";
        if (alignment.equals("top")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_TOP;
        } else if (alignment.equals("bottom")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_BOTTOM;
        } else if (alignment.equals("center") || alignment.equals("baseline")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_CENTER;
        } else if (alignment.equals("axis")) {
            this.verticalAlignment = WmiMathTableView.ALIGN_STYLE_AXIS;
        }
    }

    public Integer getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    private void getColumnAlignment(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs) {
        WmiMathTableView table;
        String alignment = attrs.getColumnAlign() != null ? attrs.getColumnAlign() : "";
        WmiMathTableRowView row = this.getRowView();
        if (alignment.equals("left")) {
            this.horizontalAlignment = WmiMathTableView.ALIGN_STYLE_LEFT;
        } else if (alignment.equals("right")) {
            this.horizontalAlignment = WmiMathTableView.ALIGN_STYLE_RIGHT;
        } else if (alignment.equals("center")) {
            this.horizontalAlignment = WmiMathTableView.ALIGN_STYLE_CENTER;
        } else if (row != null && row.isLabelRow() && (table = this.getTableView()) != null) {
            this.horizontalAlignment = table.getSide() == WmiMathTableView.LEFT_OVERLAP_SIDE ? WmiMathTableView.ALIGN_STYLE_LEFT : WmiMathTableView.ALIGN_STYLE_RIGHT;
        }
    }

    private void getAlignGroupAlignments(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs) {
        String alignment = attrs.getGroupAlign() != null ? attrs.getGroupAlign() : "";
        String[] s = alignment.split(" ");
        int kid = 0;
        while (kid <= this.getChildCount()) {
            if (kid < s.length && !s[kid].trim().equals("")) {
                String[] list = s[kid].split(" ");
                int i = 0;
                while (i < list.length) {
                    if (list[i].equals("left")) {
                        this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_LEFT);
                    } else if (list[i].equals("right")) {
                        this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_RIGHT);
                    } else if (list[i].equals("center")) {
                        this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_CENTER);
                    } else {
                        this.alignGroupAlignments.add(WmiMathTableView.ALIGN_STYLE_DECIMALPOINT);
                    }
                    ++i;
                }
            }
            ++kid;
        }
    }

    public ArrayList getAlignmentGroupAlignments() {
        return this.alignGroupAlignments;
    }

    public void setCellIndex(int row, int column) {
        if (row != this.rowIndex || column != this.columnIndex) {
            this.rowIndex = row;
            this.columnIndex = column;
            this.markInvalid(1);
        }
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void adjustVerticalAlignment(WmiMathTableView table, WmiMathTableRowView row) {
        boolean useRowSpan = false;
        int rowIndex = table.indexOf(row);
        int accumOffs = table.getMaximumRowHeight(rowIndex);
        int colIndex = table.getColumnIndex(rowIndex, row.indexOf(this));
        if (++rowIndex < table.getChildCount()) {
            while (rowIndex < table.getChildCount() && table.getCellHeight(rowIndex, colIndex) == 0) {
                useRowSpan = true;
                accumOffs += table.getMaximumRowHeight(rowIndex);
                accumOffs += table.getRowSpacing(rowIndex - 1);
                ++rowIndex;
            }
        }
        if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_TOP) {
            this.setVerticalOffset(0);
        } else if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_BOTTOM) {
            if (useRowSpan) {
                this.setVerticalOffset(accumOffs - this.getHeight());
            } else {
                this.setVerticalOffset(row.getMaxHeight() - this.getHeight());
            }
        } else if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_CENTER && !useRowSpan) {
            WmiPositionedView child = (WmiPositionedView)this.getChild(0);
            if (child.getBaseline() < row.getMaxBaseline()) {
                this.setVerticalOffset(row.getMaxBaseline() - this.getHeight());
            }
        } else if (this.verticalAlignment == WmiMathTableView.ALIGN_STYLE_AXIS || useRowSpan) {
            if (useRowSpan) {
                this.setVerticalOffset((accumOffs - this.getHeight()) / 2);
            } else {
                this.setVerticalOffset((row.getMaxHeight() - this.getHeight()) / 2);
            }
        }
    }

    private void getRowSpan(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs) {
        this.rowSpan = attrs.getRowSpan() != null ? attrs.getRowSpan() : 1;
    }

    public int getRowSpan() {
        if (this.rowSpan > 0) {
            return this.rowSpan;
        }
        try {
            WmiMathTableModel.WmiMathTableDataModel model = (WmiMathTableModel.WmiMathTableDataModel)this.getModel();
            WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs = (WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet)model.getAttributesForRead();
            this.getRowSpan(attrs);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        return this.rowSpan;
    }

    private void getColumnSpan(WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs) {
        this.columnSpan = attrs.getColumnSpan() != null ? attrs.getColumnSpan() : 1;
    }

    public int getColumnSpan() {
        if (this.columnSpan > 0) {
            return this.columnSpan;
        }
        try {
            WmiMathTableModel.WmiMathTableDataModel model = (WmiMathTableModel.WmiMathTableDataModel)this.getModel();
            WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs = (WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet)model.getAttributesForRead();
            this.getColumnSpan(attrs);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        return this.columnSpan;
    }
}

