/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTextFragmentView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import java.awt.Point;

public class WmiMathTextFragmentView
extends WmiTextFragmentView {
    public WmiMathTextFragmentView(WmiModel model, WmiMathDocumentView docView, int start, int end) throws WmiNoReadAccessException {
        super(model, docView, start, end);
    }

    public WmiMathTextFragmentView(WmiModel model, WmiMathDocumentView docView, int start) throws WmiNoReadAccessException {
        super(model, docView, start);
    }

    public WmiMathTextFragmentView(WmiTextView source, WmiMathDocumentView docView) throws WmiNoReadAccessException {
        super(source, docView);
    }

    @Override
    public void setPositionMarker(int offset) {
        try {
            WmiMathDocumentView docView = this.getDocumentView();
            if (docView != null) {
                int[] mcaretBounds;
                WmiCaret caret = docView.getCaret();
                boolean setMarker = false;
                if (!(caret instanceof WmiMathCaret)) {
                    caret = new WmiMathCaret(docView);
                    setMarker = true;
                }
                WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(this);
                int[] obounds = super.getCaretBounds(container, offset);
                if (caret instanceof WmiMathCaret) {
                    ((WmiMathCaret)caret).setUprightPosition(obounds[0], obounds[2]);
                }
                int n = (mcaretBounds = this.getCaretBounds(container, offset))[2] > obounds[2] ? mcaretBounds[2] : obounds[2];
                mcaretBounds[2] = n;
                caret.updateCaretBounds(container, mcaretBounds[0], mcaretBounds[1], mcaretBounds[2], mcaretBounds[3]);
                caret.updateView(this, offset);
                if (setMarker) {
                    docView.setPositionMarker(caret);
                }
                caret.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int zoom = this.getZoomFactor();
        boolean scriptSize = false;
        WmiModel model = this.getModel();
        WmiCompositeModel parent = model.getParent();
        while (parent instanceof WmiMathModel) {
            scriptSize = ((WmiMathModel)((Object)parent)).useScriptSize(model);
            if (scriptSize) {
                zoom = Math.round((float)zoom * 0.8f);
                break;
            }
            model = parent;
            parent = model.getParent();
        }
        return zoom;
    }

    @Override
    public int doForcedLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth) throws WmiNoReadAccessException {
        boolean found = false;
        WmiMathDocumentView docView = this.getDocumentView();
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        WmiMathTokenModel terminatorModel = WmiMathFactory.createMathOperatorToken(docModel, "\\", this.getContext());
        WmiMathOperatorView terminatorView = new WmiMathOperatorView(terminatorModel, docView);
        terminatorView.layoutView();
        int limit = breakWidth - horizontalOffset - terminatorView.getWidth();
        Point pt = new Point(limit, 0);
        int textOffset = this.getOffset(pt);
        if (textOffset > 0) {
            int index;
            found = true;
            WmiTextView[] fragments = WmiMathTextFragmentView.splitMathTextView(this, textOffset, 0);
            WmiCompositeView parent = this.getParentView();
            int n = index = parent != null ? parent.indexOf(this) : -1;
            if (index >= 0) {
                parent.replaceChild(fragments[0], index);
                fragments[0].setParentView(parent);
                parent.insertView(terminatorView, index + 1);
                parent.insertView(fragments[1], index + 2);
                parent.markInvalid(1);
                ((WmiPositionedView)((Object)parent)).layoutView();
                paragraph.split(parent, index + 2, 0);
                found = true;
                this.release();
            }
        }
        return found ? 2 : 0;
    }

    private WmiMathContext getContext() throws WmiNoReadAccessException {
        WmiAttributeSet attrs;
        WmiMathContext context = null;
        WmiView view = WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH);
        if (view != null && view.getModel() instanceof WmiMathWrapperModel && (attrs = view.getModel().getAttributesForRead()) instanceof WmiFontAttributeSet) {
            context = new WmiMathContext((WmiFontAttributeSet)attrs);
        }
        if (context == null) {
            context = new WmiMathContext(null);
        }
        return context;
    }

    public static WmiTextView[] splitMathTextView(WmiTextView text, int offset, int consume) throws WmiNoReadAccessException {
        WmiTextLayout rightLayout;
        WmiMathDocumentView docView = text.getDocumentView();
        WmiMathTextFragmentView left = new WmiMathTextFragmentView(text, docView);
        WmiMathTextFragmentView right = left.splitFragmentView(offset, consume);
        WmiTextLayout wmiTextLayout = rightLayout = right != null ? right.getLayout() : null;
        if (rightLayout != null && rightLayout.getWidth() == 0) {
            right.layout = null;
        }
        WmiTextView[] views = new WmiTextView[]{left, right};
        left.markInvalid(1);
        right.markInvalid(1);
        return views;
    }

    private WmiMathTextFragmentView splitFragmentView(int offset, int consume) throws WmiNoReadAccessException {
        WmiMathTextFragmentView fragment = new WmiMathTextFragmentView(this, this.getDocumentView());
        fragment.layout = this.layout != null ? this.layout.splitLayout(offset, consume) : null;
        this.endOffset = this.startOffset + offset - 1;
        fragment.startOffset = this.endOffset + consume + 1;
        fragment.markInvalid(1);
        this.markInvalid(1);
        return fragment;
    }
}

