/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class WmiMathViewUtil {
    public static final float DEFAULT_FONT_SIZE = 20.0f;
    private static final Font DEFAULT_RESOLVE_FONT = new Font("Times New Roman", 0, 20);
    private static FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);

    private static int fontSizeAtWrapperLimit(WmiInlineView mathWrapperView, Point pt) throws WmiNoReadAccessException {
        WmiAttributeSet attr;
        WmiPositionedView testView;
        WmiModel testModel;
        int fontSize = 0;
        WmiViewPosition pos = WmiViewUtil.findNearestView(mathWrapperView, pt);
        if (pos != null && (testModel = (testView = pos.getView()).getModel()) instanceof WmiMathModel && (attr = testModel.getAttributes()) instanceof WmiFontAttributeSet) {
            fontSize = ((WmiFontAttributeSet)attr).getSize();
        }
        return fontSize;
    }

    public static int getMathKerningSize(WmiInlineView mathWrapperView) throws WmiNoReadAccessException {
        int maxFontSize = 0;
        maxFontSize = Math.max(maxFontSize, WmiMathViewUtil.fontSizeAtWrapperLimit(mathWrapperView, new Point(0, 0)));
        maxFontSize = Math.max(maxFontSize, WmiMathViewUtil.fontSizeAtWrapperLimit(mathWrapperView, new Point(0, mathWrapperView.getHeight())));
        maxFontSize = Math.max(maxFontSize, WmiMathViewUtil.fontSizeAtWrapperLimit(mathWrapperView, new Point(mathWrapperView.getWidth(), mathWrapperView.getHeight())));
        maxFontSize = Math.max(maxFontSize, WmiMathViewUtil.fontSizeAtWrapperLimit(mathWrapperView, new Point(mathWrapperView.getWidth(), 0)));
        return (int)((double)maxFontSize * 0.37);
    }

    public static int getPixelValueForDimension(WmiDimensionUnit dunit, WmiFontAttributeSet attributes, boolean forPrintDisplay) {
        int pxValue = 0;
        float unitsValue = dunit.getUnitsValue();
        String unit = dunit.getUnit();
        WmiDimensionUnit defaultUnit = dunit.getDefaultUnit();
        if ("px".equals(unit) || "pt".equals(unit)) {
            pxValue = (int)unitsValue;
        } else if ("pc".equals(unit)) {
            pxValue = Math.round(unitsValue * 12.0f);
        } else if ("in".equals(unit)) {
            pxValue = Math.round(unitsValue * 72.0f);
        } else if ("cm".equals(unit)) {
            pxValue = Math.round(unitsValue * 28.346457f);
        } else if ("mm".equals(unit)) {
            pxValue = Math.round(unitsValue * 28.346457f / 10.0f);
        } else if ("%".equals(unit)) {
            int defaultPixels = defaultUnit == null ? 0 : WmiMathViewUtil.getPixelValueForDimension(defaultUnit, attributes, forPrintDisplay);
            pxValue = Math.round((float)defaultPixels * unitsValue / 100.0f);
        } else if ("em".equals(unit)) {
            Font font = WmiFontResolver.getFont(attributes, 100, forPrintDisplay);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
            int baseEm = metrics.getFontProperty(3, forPrintDisplay);
            pxValue = Math.round((float)baseEm * unitsValue);
        } else if ("ex".equals(unit)) {
            Font font = WmiFontResolver.getFont(attributes, 100, forPrintDisplay);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
            int baseEx = metrics.getFontProperty(1, forPrintDisplay);
            pxValue = Math.round((float)baseEx * unitsValue);
        } else {
            if (WmiMathOperatorView.getNamedDimension(unit) != null) {
                WmiDimensionUnit namedUnit = WmiMathOperatorView.getNamedDimension(unit);
                return WmiMathViewUtil.getPixelValueForDimension(namedUnit, attributes, forPrintDisplay);
            }
            int defaultPixels = defaultUnit == null ? 0 : WmiMathViewUtil.getPixelValueForDimension(defaultUnit, attributes, forPrintDisplay);
            pxValue = Math.round((float)defaultPixels * unitsValue);
        }
        return pxValue;
    }

    public static Image renderMathMLEntity(String entityName, int padding, WmiFontAttributeSet set, boolean getUnicodeCharacter) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String renderString = entityName;
        Font font = DEFAULT_RESOLVE_FONT;
        char c = WmiMathEntityNameMapper.getUnicodeCharacter(entityName);
        if (c != '\u0000' && getUnicodeCharacter) {
            String unicodeString = Character.toString(c);
            font = WmiFontResolver.getFontForCharacter(unicodeString, DEFAULT_RESOLVE_FONT);
            renderString = WmiFontResolver.mapCharactersForFont(unicodeString, font, 1);
        }
        BufferedImage buffy = null;
        if (font != null) {
            font = font.deriveFont((float)set.getSize());
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
            Rectangle2D r = font.getStringBounds(renderString, frc);
            LineMetrics lm = font.getLineMetrics(renderString, frc);
            int width = (int)r.getWidth();
            int height = (int)r.getHeight();
            int descent = (int)lm.getDescent();
            buffy = new BufferedImage(width + 2 * padding, height + 2 * padding, 2);
            Graphics2D buffg = buffy.createGraphics();
            buffg.setColor(new Color(set.getForeground()));
            buffg.setFont(font);
            ((Graphics)buffg).drawString(renderString, padding, height - descent + padding);
            buffg.dispose();
        }
        return buffy;
    }

    public static Image renderMathML(String mathml, WmiMathDocumentView docView, int padding, boolean centerVerticalWithBaseline) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderMathML(mathml, docView, padding, null, centerVerticalWithBaseline, null);
    }

    public static Image renderMathML(String mathml, WmiMathDocumentView docView, int padding, boolean centerVerticalWithBaseline, WmiFontAttributeSet defaultAttrs) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderMathML(mathml, docView, padding, null, centerVerticalWithBaseline, defaultAttrs);
    }

    public static Image renderTypeMK(Dag typeMK, WmiMathDocumentView docView, int padding, boolean centerVerticalWithBaseline, WmiFontAttributeSet defaultAttrs) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathViewUtil.renderTypeMK(typeMK, docView, padding, null, centerVerticalWithBaseline, defaultAttrs);
    }

    public static Image renderMathML(String mathml, WmiMathDocumentView docView, int padding, int[] baseline, boolean centerVerticalWithBaseline, WmiFontAttributeSet defaultAttrs) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
        WmiMathContext context = defaultAttrs != null ? new WmiMathContext(defaultAttrs) : null;
        WmiMathModel model = WmiInsertMathMLCommand.convertMathMLToModel(mathml, doc, context);
        return WmiMathViewUtil.renderMathModel(docView, model, padding, baseline, centerVerticalWithBaseline);
    }

    public static Image renderTypeMK(Dag typeMK, WmiMathDocumentView docView, int padding, int[] baseline, boolean centerVerticalWithBaseline, WmiFontAttributeSet defaultAttrs) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
        WmiMathModel model = WmiMathFactory.createMath(doc, typeMK, new WmiMathContext(defaultAttrs));
        return WmiMathViewUtil.renderMathModel(docView, model, padding, baseline, centerVerticalWithBaseline);
    }

    public static Image renderMathModel(WmiMathDocumentView docView, WmiMathModel model, int padding, int[] baseline, boolean centerVerticalWithBaseline) throws WmiNoReadAccessException {
        WmiViewFactory factory = docView.getViewFactory();
        WmiView view = factory.createView(model, docView);
        BufferedImage buffy = null;
        if (view instanceof WmiPositionedView) {
            WmiPositionedView posView = (WmiPositionedView)view;
            posView.layoutView();
            int y = 0;
            int width = posView.getWidth() + 2 * padding;
            int height = posView.getHeight() + 2 * padding;
            int viewBaseline = posView.getBaseline();
            if (baseline != null) {
                baseline[0] = viewBaseline + padding;
            }
            if (centerVerticalWithBaseline) {
                height = Math.max(viewBaseline, height - viewBaseline);
                y = height - viewBaseline;
                height *= 2;
            } else {
                y = padding;
            }
            height = height <= 0 ? 1 : height;
            width = width <= 0 ? 1 : width;
            buffy = new BufferedImage(width, height, 2);
            Graphics2D g = buffy.createGraphics();
            Rectangle r = new Rectangle(0, 0, width, height);
            WmiRenderPath path = new WmiRenderPath(docView);
            path.push(padding, y);
            posView.draw(g, path, r);
            g.dispose();
        }
        return buffy;
    }
}

