/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiSubscriptView;
import com.maplesoft.mathdoc.view.math.WmiSuperscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import java.awt.Point;
import java.util.ArrayList;

public class WmiMultiscriptView
extends WmiTraversableCompositeMathView {
    private static final int BASE_INDEX = 0;
    private static final int SUB_SUP_OR_PRE_INDEX = 1;
    private static final int PRE_SUPERSCRIPTS_INDEX = 0;
    private static final int PRE_SUBSCRIPTS_INDEX = 1;
    private static final int POST_SUPERSCRIPTS_INDEX = 2;
    private static final int POST_SUBSCRIPTS_INDEX = 3;
    private ArrayList[] positions = new ArrayList[4];
    private int hoffset = 0;
    private int greatestSubscriptHeight = 0;
    private boolean allScriptsFilled = false;

    public WmiMultiscriptView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            super.layoutView();
            this.hoffset = 0;
            this.greatestSubscriptHeight = 0;
            int i = 0;
            while (i < this.positions.length) {
                this.positions[i] = new ArrayList();
                ++i;
            }
            WmiFontMetrics metrics = WmiViewUtil.getFontMetrics(this);
            WmiPositionedView base = (WmiPositionedView)this.getChild(0);
            if (!base.isLayoutValid()) {
                base.layoutView();
            }
            this.populatePositionArrays();
            int superScriptBaseline = Math.max(this.getLargestBaseline(this.positions[0]), this.getLargestBaseline(this.positions[2]));
            int lowestBaseVOffset = Math.max(this.getLargestVOffs(this, base, this.positions[0], metrics), this.getLargestVOffs(this, base, this.positions[2], metrics));
            int subScriptOffset = Math.max(this.getLargestSubscriptOffset(base, metrics, this.positions[1]), this.getLargestSubscriptOffset(base, metrics, this.positions[3]));
            base.setVerticalOffset(lowestBaseVOffset);
            this.layoutSideOfMultiscript(this.positions[1], this.positions[0], true, subScriptOffset += lowestBaseVOffset, superScriptBaseline);
            base.setHorizontalOffset(this.hoffset);
            this.hoffset += base.getWidth();
            if (this.positions[2] != null && this.positions[2].size() > 0) {
                WmiPositionedView firstPostSuperscript = (WmiPositionedView)this.positions[2].get(0);
                if (firstPostSuperscript instanceof WmiTextView) {
                    this.hoffset += ((WmiTextView)firstPostSuperscript).computePreKernAdjustment();
                }
                if (base instanceof WmiTextView) {
                    this.hoffset += ((WmiTextView)base).computePostKernAdjustment();
                }
            }
            this.layoutSideOfMultiscript(this.positions[3], this.positions[2], false, subScriptOffset, superScriptBaseline);
            this.width = this.hoffset;
            this.baseline = lowestBaseVOffset + base.getBaseline();
            this.height = subScriptOffset + this.greatestSubscriptHeight;
            this.addNavigationLinks();
        }
    }

    private int getLargestVOffs(WmiView parent, WmiPositionedView base, ArrayList views, WmiFontMetrics metrics) throws WmiNoReadAccessException {
        int largestVOffs = 0;
        int kids = views.size();
        int i = 0;
        while (i < kids) {
            int thisoffs = WmiSuperscriptView.getBaseVOffset(parent, base, (WmiPositionedView)views.get(i), metrics);
            largestVOffs = largestVOffs > thisoffs ? largestVOffs : thisoffs;
            ++i;
        }
        return largestVOffs;
    }

    private void populatePositionArrays() throws WmiNoReadAccessException {
        int numKids = this.getChildCount();
        boolean layoutPrescripts = false;
        boolean subMarker = true;
        int i = 1;
        while (i < numKids) {
            WmiView view = this.getChild(i);
            if (view instanceof WmiPositionedView && !view.isLayoutValid()) {
                ((WmiPositionedView)view).layoutView();
            }
            if (view instanceof WmiPrescriptMarkerView) {
                layoutPrescripts = true;
                subMarker = true;
            } else {
                if (layoutPrescripts) {
                    if (subMarker) {
                        this.positions[1].add(view);
                    } else {
                        this.positions[0].add(view);
                    }
                } else if (subMarker) {
                    this.positions[3].add(view);
                } else {
                    this.positions[2].add(view);
                }
                subMarker = !subMarker;
            }
            ++i;
        }
    }

    private void layoutSideOfMultiscript(ArrayList subscripts, ArrayList superscripts, boolean leftSide, int subScriptOffset, int superScriptBaseline) {
        int scriptCount = Math.min(subscripts.size(), superscripts.size());
        int direction = leftSide ? -1 : 1;
        int startLocation = leftSide ? scriptCount - 1 : 0;
        WmiPositionedView subScript = null;
        WmiPositionedView superScript = null;
        int i = startLocation;
        while (i > -1 && i < scriptCount) {
            subScript = (WmiPositionedView)subscripts.get(i);
            superScript = (WmiPositionedView)superscripts.get(i);
            subScript.setHorizontalOffset(this.hoffset);
            subScript.setVerticalOffset(subScriptOffset);
            this.greatestSubscriptHeight = Math.max(subScript.getHeight(), this.greatestSubscriptHeight);
            superScript.setHorizontalOffset(this.hoffset);
            superScript.setVerticalOffset(superScriptBaseline - superScript.getBaseline());
            this.hoffset += Math.max(subScript.getWidth(), superScript.getWidth());
            i += direction;
        }
        if (leftSide && subScript != null) {
            WmiPositionedView base = (WmiPositionedView)this.getChild(0);
            if (subScript instanceof WmiTextView) {
                this.hoffset += ((WmiTextView)subScript).computePostKernAdjustment();
            }
            if (base instanceof WmiTextView) {
                this.hoffset += ((WmiTextView)base).computePreKernAdjustment();
            }
        }
    }

    private int getLargestBaseline(ArrayList views) {
        int baselineValue = 0;
        int superScriptCount = views.size();
        int i = 0;
        while (i < superScriptCount) {
            int thisScriptBaseline = ((WmiPositionedView)views.get(i)).getBaseline();
            baselineValue = baselineValue > thisScriptBaseline ? baselineValue : thisScriptBaseline;
            ++i;
        }
        return baselineValue;
    }

    private int getLargestSubscriptOffset(WmiPositionedView base, WmiFontMetrics metrics, ArrayList views) throws WmiNoReadAccessException {
        int subscriptOffset = 0;
        int superScriptCount = views.size();
        int i = 0;
        while (i < superScriptCount) {
            WmiPositionedView child = (WmiPositionedView)views.get(i);
            int thisOffset = WmiSubscriptView.getSubscriptVOffset(this, base, child, metrics);
            subscriptOffset = subscriptOffset > thisOffset ? subscriptOffset : thisOffset;
            ++i;
        }
        return subscriptOffset;
    }

    @Override
    public void addNavigationLinks() {
        WmiMScriptNavLinkBuilder linkBuilder = new WmiMScriptNavLinkBuilder(this);
        linkBuilder.createNavigationLinks();
    }

    private void setMainEntryPoint(WmiPositionedView target, int location) {
        block8: {
            boolean locked = WmiModelLock.readLock(target.getModel(), false);
            try {
                try {
                    if (target instanceof WmiTextView && ((WmiTextView)target).getLength() == 0) {
                        this.setNextView(null, location);
                        break block8;
                    }
                    this.setNextView(target, location);
                }
                catch (WmiNoReadAccessException rle) {
                    this.setNextView(null, location);
                    if (locked) {
                        WmiModelLock.readUnlock(target.getModel());
                    }
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(target.getModel());
                }
            }
        }
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public WmiPositionedView getNextView(int direction) {
        if (this.allScriptsFilled) {
            WmiPositionedView baseView;
            WmiCaret caret = this.getDocumentView().getCaret();
            WmiPositionedView caretView = caret.getView();
            int caretOffSet = caret.getOffset();
            if ((caretView != this && direction == 0 || direction == 1) && ((baseView = (WmiPositionedView)this.getChild(0)) == caretView || WmiViewUtil.isViewAncestorOfView(baseView, caretView))) {
                int innerX;
                int baseX = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)baseView).x;
                int caretX = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)caretView).x;
                if (caretView instanceof WmiTextView) {
                    caretX += ((WmiTextView)caretView).getHorizontalOffset(caretOffSet);
                }
                if ((innerX = caretX - baseX) <= baseView.getWidth() / 2) {
                    if (direction == 1) {
                        return (WmiPositionedView)this.getChild(4);
                    }
                    if (direction == 0) {
                        return (WmiPositionedView)this.getChild(5);
                    }
                } else {
                    if (direction == 1) {
                        return (WmiPositionedView)this.getChild(1);
                    }
                    if (direction == 0) {
                        return (WmiPositionedView)this.getChild(2);
                    }
                }
            }
        }
        return super.getNextView(direction);
    }

    private static class WmiMScriptNavLinkBuilder {
        private WmiMultiscriptView mscript;

        private WmiMScriptNavLinkBuilder(WmiMultiscriptView view) {
            this.mscript = view;
        }

        private void createNavigationLinks() {
            boolean baseIndex = false;
            int prescriptIndex = this.getPrescriptMarkverViewIndex();
            int length = this.mscript.getChildCount();
            WmiPositionedView base = (WmiPositionedView)this.mscript.getChild(0);
            WmiPositionedView[] postViews = new WmiPositionedView[]{};
            WmiPositionedView[] preViews = new WmiPositionedView[]{};
            if (prescriptIndex < 0) {
                postViews = this.createSubChildren(1, length - 1);
            } else {
                postViews = this.createSubChildren(1, prescriptIndex - 1);
                preViews = this.createSubChildren(prescriptIndex + 1, length - prescriptIndex - 1);
            }
            WmiPositionedView[] postTops = this.getTopBottomArray(postViews, true);
            WmiPositionedView[] postBottoms = this.getTopBottomArray(postViews, false);
            WmiPositionedView[] preTops = this.getTopBottomArray(preViews, true);
            WmiPositionedView[] preBottoms = this.getTopBottomArray(preViews, false);
            if (postViews.length > 0) {
                this.buildPostNavigationLinks(base, postTops, postBottoms);
                base.setNextView(this.getNextAppropriateView(postTops, postBottoms, -1, true), 3);
            } else {
                base.setNextView(null, 3);
            }
            if (preViews.length > 0) {
                this.buildPreNavigationLinks(base, preTops, preBottoms);
                base.setNextView(this.getNextAppropriateView(preTops, preBottoms, -1, true), 2);
            } else {
                base.setNextView(null, 2);
            }
            if (postViews.length > 0 && preViews.length > 0) {
                if (preTops[0].isNavagableView() && postTops[0].isNavagableView()) {
                    base.setNextView(null, 0);
                } else if (preTops[0].isNavagableView()) {
                    base.setNextView(preTops[0], 0);
                } else if (postTops[0].isNavagableView()) {
                    base.setNextView(postTops[0], 0);
                } else {
                    base.setNextView(null, 0);
                }
                if (preBottoms[0].isNavagableView() && postBottoms[0].isNavagableView()) {
                    base.setNextView(null, 0);
                } else if (preBottoms[0].isNavagableView()) {
                    base.setNextView(preBottoms[0], 0);
                } else if (postBottoms[0].isNavagableView()) {
                    base.setNextView(postBottoms[0], 0);
                } else {
                    base.setNextView(null, 0);
                }
            } else if (postViews.length > 0) {
                base.setNextView(postTops[0], 0);
                base.setNextView(postBottoms[0], 1);
            } else if (preViews.length > 0) {
                base.setNextView(preTops[0], 0);
                base.setNextView(preBottoms[0], 1);
            } else {
                base.setNextView(null, 0);
                base.setNextView(null, 1);
            }
            this.mscript.setNextView(this.getEntryPoint(base, preTops, preBottoms), -4);
            this.mscript.setNextView(this.getEntryPoint(base, postTops, postBottoms), -3);
            if (this.hasNavagableView(preTops) && this.hasNavagableView(postTops)) {
                this.mscript.setNextView(null, -2);
            } else {
                this.mscript.setNextView(base, -2);
            }
            if (this.hasNavagableView(preBottoms) && this.hasNavagableView(postBottoms)) {
                this.mscript.setNextView(null, -2);
            } else {
                this.mscript.setNextView(base, -2);
            }
        }

        private void buildPostNavigationLinks(WmiPositionedView base, WmiPositionedView[] topViews, WmiPositionedView[] bottomViews) {
            if (topViews.length == bottomViews.length) {
                boolean firstFound = false;
                int i = 0;
                while (i < topViews.length) {
                    topViews[i].setNextView(bottomViews[i], 1);
                    bottomViews[i].setNextView(topViews[i], 0);
                    topViews[i].setNextView(this.getNextAppropriateView(topViews, bottomViews, i, true), 3);
                    bottomViews[i].setNextView(this.getNextAppropriateView(topViews, bottomViews, i, false), 3);
                    if (!firstFound && (topViews[i].isNavagableView() || bottomViews[i].isNavagableView())) {
                        topViews[i].setNextView(base, 2);
                        bottomViews[i].setNextView(base, 2);
                        firstFound = true;
                    } else {
                        topViews[i].setNextView(this.getPreviousAppropriateView(topViews, bottomViews, i, true), 2);
                        bottomViews[i].setNextView(this.getPreviousAppropriateView(topViews, bottomViews, i, false), 2);
                    }
                    ++i;
                }
            }
        }

        private void buildPreNavigationLinks(WmiPositionedView base, WmiPositionedView[] topViews, WmiPositionedView[] bottomViews) {
            if (topViews.length == bottomViews.length) {
                boolean firstFound = false;
                int i = 0;
                while (i < topViews.length) {
                    topViews[i].setNextView(bottomViews[i], 1);
                    bottomViews[i].setNextView(topViews[i], 0);
                    topViews[i].setNextView(this.getNextAppropriateView(topViews, bottomViews, i, true), 2);
                    bottomViews[i].setNextView(this.getNextAppropriateView(topViews, bottomViews, i, false), 2);
                    if (!firstFound && (topViews[i].isNavagableView() || bottomViews[i].isNavagableView())) {
                        topViews[i].setNextView(base, 3);
                        bottomViews[i].setNextView(base, 3);
                        firstFound = true;
                    } else {
                        topViews[i].setNextView(this.getPreviousAppropriateView(topViews, bottomViews, i, true), 3);
                        bottomViews[i].setNextView(this.getPreviousAppropriateView(topViews, bottomViews, i, false), 3);
                    }
                    ++i;
                }
            }
        }

        private WmiPositionedView getNextAppropriateView(WmiPositionedView[] topViews, WmiPositionedView[] bottomViews, int currentIndex, boolean top) {
            int startIndex;
            WmiPositionedView next = null;
            if (topViews.length != bottomViews.length) {
                return next;
            }
            int i = startIndex = currentIndex + 1;
            while (i < topViews.length) {
                WmiPositionedView topView = topViews[i];
                WmiPositionedView bottomView = bottomViews[i];
                if (top) {
                    if (topView.isNavagableView()) {
                        next = topView;
                        break;
                    }
                    if (bottomView.isNavagableView()) {
                        next = bottomView;
                        break;
                    }
                } else {
                    if (bottomView.isNavagableView()) {
                        next = bottomView;
                        break;
                    }
                    if (topView.isNavagableView()) {
                        next = topView;
                        break;
                    }
                }
                ++i;
            }
            return next;
        }

        private boolean hasNavagableView(WmiPositionedView[] views) {
            int i = 0;
            while (i < views.length) {
                if (views[i].isNavagableView()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private WmiPositionedView getEntryPoint(WmiPositionedView base, WmiPositionedView[] topViews, WmiPositionedView[] bottomViews) {
            int startIndex;
            WmiPositionedView entry = base;
            if (topViews.length != bottomViews.length) {
                return entry;
            }
            int i = startIndex = topViews.length - 1;
            while (i >= 0) {
                WmiPositionedView topView = topViews[i];
                WmiPositionedView bottomView = bottomViews[i];
                if (topView.isNavagableView()) {
                    entry = topView;
                    break;
                }
                if (bottomView.isNavagableView()) {
                    entry = bottomView;
                    break;
                }
                --i;
            }
            return entry;
        }

        private int getPrescriptMarkverViewIndex() {
            int i = 0;
            while (i < this.mscript.children.length) {
                if (this.mscript.children[i] instanceof WmiPrescriptMarkerView) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private WmiPositionedView getPreviousAppropriateView(WmiPositionedView[] topViews, WmiPositionedView[] bottomViews, int currentIndex, boolean top) {
            int startIndex;
            WmiPositionedView previous = null;
            if (topViews.length != bottomViews.length) {
                return previous;
            }
            int i = startIndex = currentIndex - 1;
            while (i >= 0) {
                WmiPositionedView topView = topViews[i];
                WmiPositionedView bottomView = bottomViews[i];
                if (top) {
                    if (topView.isNavagableView()) {
                        previous = topView;
                        break;
                    }
                    if (bottomView.isNavagableView()) {
                        previous = bottomView;
                        break;
                    }
                } else {
                    if (bottomView.isNavagableView()) {
                        previous = bottomView;
                        break;
                    }
                    if (topView.isNavagableView()) {
                        previous = topView;
                        break;
                    }
                }
                --i;
            }
            return previous;
        }

        private WmiPositionedView[] createSubChildren(int start, int length) {
            WmiPositionedView[] newArray = new WmiPositionedView[length];
            int i = 0;
            while (i < length) {
                newArray[i] = (WmiPositionedView)this.mscript.children[start + i];
                ++i;
            }
            return newArray;
        }

        private WmiPositionedView[] getTopBottomArray(WmiPositionedView[] views, boolean top) {
            WmiPositionedView[] result = new WmiPositionedView[views.length / 2];
            int j = top ? 1 : 0;
            int i = 0;
            while (i < result.length) {
                result[i] = views[j];
                ++i;
                j += 2;
            }
            return result;
        }
    }

    public static class WmiNoneMarkerView
    extends WmiGenericView {
        public WmiNoneMarkerView(WmiModel model, WmiMathDocumentView view) {
            super(model, view);
        }

        @Override
        public boolean isNavagableView() {
            return false;
        }
    }

    public static class WmiPrescriptMarkerView
    extends WmiGenericView {
        public WmiPrescriptMarkerView(WmiModel model, WmiMathDocumentView view) {
            super(model, view);
        }

        @Override
        public boolean isNavagableView() {
            return false;
        }
    }
}

