/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.view.WmiAdjustableTextBounds;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiTextAdjustmentUtils;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMultiscriptView;
import com.maplesoft.mathdoc.view.math.WmiTraversableCompositeMathView;
import java.awt.Point;

public class WmiSuperscriptView
extends WmiTraversableCompositeMathView
implements WmiAdjustableTextBounds {
    private static final int BASE_INDEX = 0;
    private static final int EXPONENT_INDEX = 1;
    public static final double ITALICS_ADJUSTMENT_FACTOR = 0.19438030913772;
    private static final double FONT_VERTICAL_ADJUSTMENT_FACTOR = 0.55;

    public WmiSuperscriptView(WmiModel model, WmiMathDocumentView docView) {
        super(model, docView);
    }

    @Override
    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            super.layoutView();
            WmiFontMetrics metrics = WmiViewUtil.getFontMetrics(this);
            WmiPositionedView base = (WmiPositionedView)this.getChild(0);
            WmiPositionedView superscript = (WmiPositionedView)this.getChild(1);
            if (base != null && superscript != null) {
                int superHOffset = WmiSuperscriptView.getSuperscriptHOffset(base, superscript);
                superscript.setHorizontalOffset(superHOffset);
                WmiPositionedView adjustedBase = base;
                if (base instanceof WmiMultiscriptView) {
                    adjustedBase = (WmiPositionedView)((WmiCompositeView)((Object)adjustedBase)).getChild(0);
                }
                int baseVOffset = WmiSuperscriptView.getBaseVOffset(this, adjustedBase, superscript, metrics);
                if (base != adjustedBase) {
                    superscript.setVerticalOffset(base.getBaseline() - adjustedBase.getBaseline());
                }
                base.setVerticalOffset(baseVOffset);
                this.height = baseVOffset + base.getHeight() - superscript.getVerticalOffset();
                this.width = superHOffset + superscript.getWidth();
                this.baseline = base.getBaseline() + baseVOffset;
                this.addNavigationLinks();
            }
        }
    }

    public static int getSuperscriptHOffset(WmiPositionedView base, WmiPositionedView superscript) {
        int hOffset = base.getWidth();
        if (base instanceof WmiAdjustableTextBounds) {
            hOffset += ((WmiAdjustableTextBounds)((Object)base)).computePostKernAdjustment();
        }
        if (superscript instanceof WmiAdjustableTextBounds) {
            hOffset += ((WmiAdjustableTextBounds)((Object)superscript)).computePreKernAdjustment();
        }
        return hOffset;
    }

    public static int getBaseVOffset(WmiView parent, WmiPositionedView base, WmiPositionedView superscript) throws WmiNoReadAccessException {
        WmiFontMetrics metrics = null;
        if (parent instanceof WmiGenericView) {
            metrics = WmiViewUtil.getFontMetrics((WmiGenericView)parent);
        }
        return WmiSuperscriptView.getBaseVOffset(parent, base, superscript, metrics);
    }

    public static int getBaseVOffset(WmiView parent, WmiPositionedView base, WmiPositionedView superscript, WmiFontMetrics metrics) throws WmiNoReadAccessException {
        WmiMathDocumentView doc;
        int superAscent = superscript.getBaseline();
        int superDescent = superscript.getHeight() - superAscent;
        int voffset = 0;
        int additionalOffset = 0;
        int fheight = metrics != null ? metrics.getFontProperty(5, parent.getDocumentView().isPrintView()) : 8;
        int standardFontOffset = (int)Math.round((double)fheight * 0.55);
        WmiAttributeSet parentAtts = parent.getModel().getAttributes();
        if (parentAtts instanceof WmiSuperscriptModel.WmiSuperscriptAttributeSet) {
            additionalOffset = ((WmiSuperscriptModel.WmiSuperscriptAttributeSet)parentAtts).getSuperscriptShift();
        }
        if ((doc = base.getDocumentView()) != null) {
            int zoom = doc.getZoomFactor();
            additionalOffset = Math.round(zoom * additionalOffset / 100);
        }
        voffset = superAscent;
        voffset -= standardFontOffset;
        voffset += superDescent;
        return voffset += additionalOffset;
    }

    @Override
    public void addNavigationLinks() {
        WmiPositionedView base = (WmiPositionedView)this.getChild(0);
        WmiPositionedView superscript = (WmiPositionedView)this.getChild(1);
        if (base != null && superscript != null) {
            base.setNextView(superscript, 3);
            superscript.setNextView(base, 2);
            this.setNextView(null, -2);
            this.setNextView(base, -1);
            this.setNextView(base, -4);
            this.setNextView(superscript, -3);
        }
    }

    @Override
    public WmiPositionedView getNextView(int direction) {
        WmiPositionMarker marker;
        WmiMathDocumentView docView = this.getDocumentView();
        boolean inSuperscript = false;
        if (docView != null && (marker = docView.getPositionMarker()) != null) {
            inSuperscript = marker.getView() == this.getChild(1);
        }
        int lookupDirection = inSuperscript && direction == 1 ? 3 : direction;
        return super.getNextView(lookupDirection);
    }

    @Override
    public WmiPositionedView getViewForNavigation(int location, Point pt) {
        WmiPositionedView view = this.getNextView(location);
        if (view == null) {
            return this.getNearestChildView(pt);
        }
        return view;
    }

    @Override
    public int computePreKernAdjustment() {
        return WmiTextAdjustmentUtils.computePreKernAdjustment(this, 0);
    }

    @Override
    public int computePostKernAdjustment() {
        return WmiTextAdjustmentUtils.computePostKernAdjustment(this, 1);
    }

    @Override
    public int computeSpaceAbove() {
        return WmiTextAdjustmentUtils.computeSpaceAbove(this, 1);
    }

    @Override
    public int computeSpaceBelow() {
        return WmiTextAdjustmentUtils.computeSpaceBelow(this, 0);
    }

    @Override
    public int getNearestSearchRule() {
        return 2;
    }

    @Override
    public int doImplicitLinebreak(WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        return WmiSuperscriptView.doImplicitScriptBreak(this, paragraph, horizontalOffset, breakWidth, thresholdCost);
    }

    public static int doImplicitScriptBreak(WmiCompositeView script, WmiParagraphView paragraph, int horizontalOffset, int breakWidth, int thresholdCost) throws WmiNoReadAccessException {
        int success = 0;
        WmiInlineView inline = null;
        WmiPositionedView base = (WmiPositionedView)script.getChild(0);
        if (base instanceof WmiCompositeView && base.hasGoodBreakpoint(horizontalOffset, breakWidth, thresholdCost)) {
            inline = WmiSuperscriptView.convertToInline(script);
        } else if (thresholdCost > 1) {
            inline = WmiSuperscriptView.convertToInline(script);
        }
        if (inline != null) {
            WmiCompositeView parent = script.getParentView();
            int index = parent.indexOf(script);
            int offset = ((WmiPositionedView)((Object)script)).getHorizontalOffset();
            if (index >= 0) {
                parent.replaceChild(inline, index);
                inline.setParentView(parent);
                inline.setHorizontalOffset(offset);
                success = 1;
            }
        }
        return success;
    }

    private static WmiInlineView convertToInline(WmiCompositeView parent) throws WmiNoReadAccessException {
        WmiModel model = parent.getModel();
        WmiMathDocumentView docView = parent.getDocumentView();
        WmiInlineView inline = new WmiInlineView(model, docView);
        inline.releaseObserver();
        WmiPositionedView base = (WmiPositionedView)parent.getChild(0);
        WmiPositionedView exponent = (WmiPositionedView)parent.getChild(1);
        inline.appendView(WmiSuperscriptView.createPaddedView(parent, base));
        inline.appendView(WmiSuperscriptView.createPaddedView(parent, exponent));
        inline.layoutView();
        return inline;
    }

    private static WmiInlineView createPaddedView(WmiCompositeView parent, WmiPositionedView view) throws WmiNoReadAccessException {
        WmiInlineView inline = new WmiInlineView(view.getModel(), view.getDocumentView());
        inline.releaseObserver();
        inline.appendView(view);
        inline.setBaselineAdjustment(((WmiPositionedView)((Object)parent)).getBaseline() - view.getVerticalOffset() - view.getBaseline());
        inline.layoutView();
        return inline;
    }
}

