/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.linebreaker;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.view.WmiAdaptiveLayoutView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiLinebrokenView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiForceBreakSet;
import com.maplesoft.mathdoc.view.math.linebreaker.WmiLineBreaker;
import com.maplesoft.mathdoc.view.math.renderers.WmiOperatorRenderer;

public class WmiDefaultLineBreaker
implements WmiLineBreaker {
    private static final float INDENT_SCALE_FACTOR = 0.2f;
    private static final float SPACING_SCALE_FACTOR = 0.0f;

    @Override
    public void linebreak(WmiLinebrokenView target, WmiView source, WmiForceBreakSet forceSet, int widthHint, boolean forceLine) throws WmiNoReadAccessException {
        if (source instanceof WmiCompositeView) {
            this.linebreakComposite(target, (WmiCompositeView)source, forceSet, widthHint, forceLine);
        } else if (source != null) {
            this.linebreakChild(target, source, forceSet, widthHint, forceLine);
        }
    }

    public synchronized WmiRowView lineBreakChildren(WmiCompositeView view, int width) throws WmiNoReadAccessException {
        return null;
    }

    public void linebreakComposite(WmiLinebrokenView target, WmiCompositeView source, WmiForceBreakSet forceSet, int widthHint, boolean forceLine) throws WmiNoReadAccessException {
        if (this.keepOnLine(target, source, forceSet, widthHint)) {
            this.addChild(target, source);
        } else {
            int size = source.getChildCount();
            int i = 0;
            while (i < size) {
                WmiView child = source.getChild(i);
                if (child != null) {
                    this.linebreakChild(target, child, forceSet, widthHint, forceLine);
                }
                ++i;
            }
        }
    }

    public void linebreakChild(WmiLinebrokenView target, WmiView source, WmiForceBreakSet forceSet, int widthHint, boolean forceLine) throws WmiNoReadAccessException {
        if (this.keepOnLine(target, source, forceSet, widthHint) && !forceLine && !forceSet.hasModels()) {
            this.addChild(target, source);
        } else if (this.keepOnLine(target, source, forceSet, widthHint) || forceLine) {
            WmiDefaultLineBreaker.nextLinebreak(target, source, forceSet, widthHint, false);
        } else {
            if (!(source instanceof WmiCompositeView)) {
                if (!forceLine && !this.isEmptyLine(target)) {
                    this.finishCurrentRow(target, forceSet);
                    this.createNewRow(target);
                }
            } else if (!forceLine && !this.hasGoodBreakPoint(target, source, forceSet, widthHint, 0)) {
                this.finishCurrentRow(target, forceSet);
                this.createNewRow(target);
            }
            if (this.keepOnLine(target, source, forceSet, widthHint)) {
                this.addChild(target, source);
            } else {
                WmiDefaultLineBreaker.nextLinebreak(target, source, forceSet, widthHint, false);
            }
        }
    }

    protected boolean isEmptyLine(WmiLinebrokenView target) {
        boolean isEmpty = true;
        int size = target.getChildCount();
        if (size > 0) {
            WmiInlineView inline = (WmiInlineView)target.getChild(size - 1);
            isEmpty = inline.getChildCount() == 0;
        }
        return isEmpty;
    }

    protected void createNewRow(WmiLinebrokenView target) throws WmiNoReadAccessException {
        if (!this.isLastRowEmpty(target)) {
            target.addRow();
        }
        int indent = this.getIndent(target);
        WmiModel model = target.getModel();
        WmiMathDocumentModel docModel = model.getDocument();
        int spacing = (int)((float)docModel.getZoomFactor() * 0.0f);
        int size = target.getChildCount();
        if (size > 0) {
            WmiInlineView lastRow = (WmiInlineView)target.getChild(size - 1);
            lastRow.setPadding(indent, 0);
            lastRow.setPadding(spacing, 2);
            lastRow.setPadding(target.getBreakWidth(), 1);
        }
    }

    protected int getIndent(WmiLinebrokenView target) throws WmiNoReadAccessException {
        int indent = target.getMathIndentLevel();
        WmiModel model = target.getModel();
        WmiMathDocumentModel docModel = model.getDocument();
        indent *= docModel.getZoomFactor();
        indent = (int)((float)indent * 0.2f);
        return indent;
    }

    protected void finishCurrentRow(WmiLinebrokenView target, WmiForceBreakSet forceSet) throws WmiNoReadAccessException {
        WmiInlineView lastRow;
        int size;
        int width = this.getLineWidth(target);
        int breakWidth = target.getBreakWidth();
        if (breakWidth > width && (size = target.getChildCount()) > 0 && (lastRow = (WmiInlineView)target.getChild(size - 1)).getChildCount() > 0) {
            lastRow.setPadding(breakWidth - width, 1);
        }
    }

    private boolean isLastRowEmpty(WmiLinebrokenView target) {
        WmiInlineView lastRow;
        boolean ret = false;
        int size = target.getChildCount();
        if (size > 0 && (lastRow = (WmiInlineView)target.getChild(size - 1)).getChildCount() == 0) {
            ret = true;
        }
        return ret;
    }

    protected WmiPositionedView addChild(WmiLinebrokenView target, WmiView source) throws WmiNoReadAccessException {
        int size = target.getChildCount();
        if (size == 0) {
            target.addRow();
            ++size;
        }
        WmiInlineView inline = (WmiInlineView)target.getChild(size - 1);
        inline.applyMathRules(true);
        inline.lockOperatorSize(true);
        if (source instanceof WmiAdaptiveLayoutView) {
            ((WmiAdaptiveLayoutView)source).restoreOriginalView();
        }
        inline.appendView(source);
        return (WmiPositionedView)source;
    }

    protected boolean fitsOnNewLine(WmiLinebrokenView target, WmiView source) throws WmiNoReadAccessException {
        int indent = this.getIndent(target);
        int breakWidth = target.getBreakWidth();
        return source instanceof WmiPositionedView ? breakWidth > ((WmiPositionedView)source).getWidth() + indent : false;
    }

    protected boolean keepOnLine(WmiLinebrokenView target, WmiView source, WmiForceBreakSet forceSet, int widthHint) throws WmiNoReadAccessException {
        boolean fits = false;
        int size = target.getChildCount();
        if (size > 0 && source instanceof WmiPositionedView) {
            WmiPositionedView test = (WmiPositionedView)source;
            int availableWidth = target.getBreakWidth() - this.getLineWidth(target);
            if (source instanceof WmiAdaptiveLayoutView) {
                test = (WmiPositionedView)((WmiAdaptiveLayoutView)((Object)test)).getPreferredView(availableWidth, -1);
            }
            boolean bl = fits = ((WmiPositionedView)source).getWidth() <= availableWidth;
        }
        if (fits) {
            WmiModel sourceModel = source.getModel();
            fits = !forceSet.contains(sourceModel);
        }
        return fits;
    }

    protected int getLineWidth(WmiLinebrokenView target) throws WmiNoReadAccessException {
        int width = 0;
        int size = target.getChildCount();
        if (size > 0) {
            WmiInlineView lastRow = (WmiInlineView)target.getChild(size - 1);
            width = lastRow.getPadding(0);
            size = lastRow.getChildCount();
            int i = 0;
            while (i < size) {
                WmiPositionedView child = (WmiPositionedView)lastRow.getChild(i);
                width += child.getWidth();
                ++i;
            }
        }
        return width;
    }

    @Override
    public boolean hasGoodBreakPoint(WmiLinebrokenView target, WmiView source, WmiForceBreakSet forceSet, int widthHint, int startIndex) throws WmiNoReadAccessException {
        boolean goodBreak = false;
        return goodBreak;
    }

    public static void nextLinebreak(WmiLinebrokenView target, WmiView source, WmiForceBreakSet forceSet, int widthHint, boolean forceLine) throws WmiNoReadAccessException {
    }

    protected void addBracket(WmiLinebrokenView target, WmiForceBreakSet forceSet, WmiCompositeModel parent, WmiPositionedView source, String bracketCode, WmiMathDocumentModel docModel, WmiMathDocumentView docView, WmiMathContext context) throws WmiNoReadAccessException {
        WmiMathTokenModel opBracket = WmiMathFactory.createMathOperatorToken(docModel, bracketCode, context);
        try {
            opBracket.setParent(parent);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        WmiMathOperatorView bracket = new WmiMathOperatorView(opBracket, docView);
        bracket.invalidate(1);
        bracket.layoutView();
        int stretchHeight = source.getHeight();
        bracket.setStretchHeight(stretchHeight);
        WmiOperatorRenderer renderer = WmiMathOperatorView.getRenderer(bracketCode);
        renderer.layoutView(bracket, stretchHeight);
        bracket.setBaseline(source.getBaseline());
        int widthHint = target.getBreakWidth() - this.getLineWidth(target);
        if (!this.keepOnLine(target, bracket, forceSet, widthHint)) {
            this.finishCurrentRow(target, forceSet);
            this.createNewRow(target);
        }
        this.addChild(target, bracket);
    }
}

