/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;

public class WmiAngleBracketRenderer
extends WmiGlyphRenderer {
    public static final char LEFT_ANGLE_BRACKET_CHAR = '\u2329';
    public static final char RIGHT_ANGLE_BRACKET_CHAR = '\u232a';
    public static final char LEFT_DOUBLE_ANGLE_BRACKET_CHAR = '\u300a';
    public static final char RIGHT_DOUBLE_ANGLE_BRACKET_CHAR = '\u300b';
    private static final float[][] LEFT_ANGLE_OUTLINE = new float[][]{{0.2337796f, 0.9897013f}, {0.2028836f, 1.0f}, {0.0f, 0.49948502f}, {0.2028836f, 0.0f}, {0.2337796f, 0.010298651f}, {0.06591143f, 0.49948502f}, new float[0]};
    private static final int[] LEFT_ANGLE_MORPH_RULES;
    private static final float[][] DOUBLE_LEFT_ANGLE_OUTLINE;
    private static final int[] DOUBLE_LEFT_ANGLE_MORPH_RULES;
    float[][] outline;
    int[] morphRules;
    boolean rightBracket = false;

    static {
        int[] nArray = new int[7];
        nArray[0] = 3;
        nArray[1] = 3;
        nArray[2] = 22;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 22;
        LEFT_ANGLE_MORPH_RULES = nArray;
        DOUBLE_LEFT_ANGLE_OUTLINE = new float[][]{{0.4407827f, 0.9897013f}, {0.4098867f, 1.0f}, {0.2070031f, 0.49948502f}, {0.4098867f, 0.0f}, {0.4407827f, 0.010298651f}, {0.2729145f, 0.49948502f}, new float[0], {0.2337796f, 0.9897013f}, {0.2028836f, 1.0f}, {0.0f, 0.49948502f}, {0.2028836f, 0.0f}, {0.2337796f, 0.010298651f}, {0.06591143f, 0.49948502f}, new float[0]};
        int[] nArray2 = new int[14];
        nArray2[0] = 3;
        nArray2[1] = 3;
        nArray2[2] = 22;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 22;
        nArray2[6] = 22;
        nArray2[7] = 3;
        nArray2[8] = 3;
        nArray2[9] = 22;
        nArray2[10] = 1;
        nArray2[11] = 1;
        nArray2[12] = 22;
        DOUBLE_LEFT_ANGLE_MORPH_RULES = nArray2;
    }

    public WmiAngleBracketRenderer(char stretchyChar) {
        switch (stretchyChar) {
            case '\u2329': 
            case '\u232a': {
                this.outline = LEFT_ANGLE_OUTLINE;
                this.morphRules = LEFT_ANGLE_MORPH_RULES;
                break;
            }
            case '\u300a': 
            case '\u300b': {
                this.outline = DOUBLE_LEFT_ANGLE_OUTLINE;
                this.morphRules = DOUBLE_LEFT_ANGLE_MORPH_RULES;
            }
        }
        switch (stretchyChar) {
            case '\u232a': 
            case '\u300b': {
                this.rightBracket = true;
            }
        }
    }

    @Override
    protected float[][] getGlyphOutline() {
        return this.outline;
    }

    @Override
    protected int[] getStretchRules() {
        return this.morphRules;
    }

    @Override
    protected boolean isBracket() {
        return true;
    }

    @Override
    protected void morphGlyph(float[][] data, Font f, int size) {
        float fontSize = f.getSize2D();
        this.stretchScale(data, fontSize, size, this.getStretchRules());
        if (this.rightBracket) {
            this.horizontalReflection(data);
        }
    }

    @Override
    public boolean forcePreKernAdjustment(WmiMathOperatorView view) {
        return !this.rightBracket;
    }

    @Override
    public boolean forcePostKernAdjustment(WmiMathOperatorView view) {
        return this.rightBracket;
    }
}

