/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAbstractOperatorRenderer;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashMap;

public class WmiBracketRenderer
extends WmiAbstractOperatorRenderer {
    public static final float BRACKET_APPLY_SCALE_FACTOR = 1.5f;
    protected static final int TOP_INDEX = 0;
    protected static final int FILL_INDEX = 1;
    protected static final int BOTTOM_INDEX = 2;
    protected static final int SINGLE_INDEX = 3;
    protected static final String MULTICHARACTER_BRACKET_FONT_MAPLEPI = "/com/maplesoft/mathdoc/font/resources/MaplePi.ttf";
    protected static final String MULTICHARACTER_BRACKET_FONT_ESSTIX = "/com/maplesoft/mathdoc/font/resources/ESSTIX8_.TTF";
    protected static final String OVERSIZED_BRACKET_FONT = "/com/maplesoft/mathdoc/font/resources/ESSTIX7_.TTF";
    protected static Font multicharacterFontSourceMaplePi = null;
    protected static Font multicharacterFontSourceEsstix = null;
    protected static Font oversizeBracketFontSource = null;
    protected char[] data;
    protected BracketCache cache = new BracketCache();

    static {
        try {
            multicharacterFontSourceMaplePi = ResourceLoader.getResourceAsFont(MULTICHARACTER_BRACKET_FONT_MAPLEPI);
            multicharacterFontSourceEsstix = ResourceLoader.getResourceAsFont(MULTICHARACTER_BRACKET_FONT_ESSTIX);
            oversizeBracketFontSource = ResourceLoader.getResourceAsFont(OVERSIZED_BRACKET_FONT);
        }
        catch (IOException ioe) {
            WmiErrorLog.log(ioe);
        }
        catch (FontFormatException ffe) {
            WmiErrorLog.log(ffe);
        }
    }

    protected WmiBracketRenderer() {
    }

    protected WmiBracketRenderer(char[] data) {
        this.data = data;
    }

    protected WmiBracketRenderer(char top, char fill, char bottom) {
        this.data = new char[3];
        this.data[0] = top;
        this.data[1] = fill;
        this.data[2] = bottom;
    }

    public static Font getOversizedBracketFont() {
        if (oversizeBracketFontSource == null) {
            try {
                oversizeBracketFontSource = ResourceLoader.getResourceAsFont(WmiBracketRenderer.getOversizedBracketFontName());
            }
            catch (FontFormatException ffe) {
                WmiErrorLog.log(ffe);
            }
            catch (IOException ioe) {
                WmiErrorLog.log(ioe);
            }
        }
        return oversizeBracketFontSource;
    }

    public static String getOversizedBracketFontName() {
        return OVERSIZED_BRACKET_FONT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutView(WmiMathOperatorView view, int height) throws WmiNoReadAccessException {
        WmiBracketRenderer.getOversizedBracketFont();
        view.setStretchHeight(height);
        view.setHeight(height);
        Font renderFont = this.getFont(view);
        BracketCache bracketCache = this.cache;
        synchronized (bracketCache) {
            RenderedBracket bracket = this.cache.getBracket(renderFont, height);
            if (bracket == null) {
                bracket = this.createBracket(renderFont, height);
            }
            if (bracket != null) {
                boolean forPrint = view.getDocumentView().isPrintView();
                bracket.validateLayout(forPrint);
                int w = bracket.getWidth(forPrint);
                int leftPad = view.getLeftPadding();
                int rightPad = view.getRightPadding();
                view.setWidth(w + leftPad + rightPad);
            }
        }
    }

    protected RenderedBracket createBracket(Font font, int height) {
        DefaultRenderedBracket bracket = new DefaultRenderedBracket(this.data, font, this.getOversizeBracketFontSource(), height, this.canShrink(), this.forceFont());
        this.cache.setBracket(font, height, bracket);
        return bracket;
    }

    protected Font forceFont() {
        return null;
    }

    protected boolean canShrink() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds, WmiMathOperatorView view) {
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        Font renderFont = this.getFont(view);
        WmiFontAttributeSet attributes = view.getFontAttributes();
        g.setFont(renderFont);
        int xOffset = path.getHorizontalOffset();
        int yOffset = path.getVerticalOffset();
        int width = view.getWidth();
        int x = view.getHorizontalOffset();
        boolean highlighted = false;
        if (path.getSelection() != null && path.getSelection().contains(view) != 0) {
            highlighted = path.isSelected(x + xOffset, width);
        }
        if (highlighted) {
            WmiMathDocumentView docView = view.getDocumentView();
            Color foreground = docView.getColor(3);
            g.setColor(foreground);
        } else {
            if (attributes.isOpaque()) {
                g.setColor(new Color(attributes.getBackground()));
                g.fillRect(xOffset + view.getHorizontalOffset(), yOffset, width, view.getHeight());
            }
            g.setColor(new Color(attributes.getForeground()));
        }
        BracketCache bracketCache = this.cache;
        synchronized (bracketCache) {
            RenderedBracket bracket = this.cache.getBracket(renderFont, view.getHeight());
            if (bracket == null) {
                bracket = this.createBracket(renderFont, view.getHeight());
            }
            if (bracket != null) {
                boolean forPrint = view.getDocumentView().isPrintView();
                bracket.validateLayout(forPrint);
                bracket.draw(g, xOffset + view.getHorizontalOffset() + view.getLeftPadding(), yOffset + view.getVerticalOffset(), forPrint);
            } else {
                WmiErrorLog.log(new Exception("Failed to find bracket: height = " + view.getHeight()));
            }
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    public Font getOversizeBracketFontSource() {
        return oversizeBracketFontSource;
    }

    @Override
    public boolean applyRenderer(WmiMathOperatorView view, int height) {
        boolean apply = false;
        if (height > 0) {
            Font font = this.getFont(view);
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(font);
            int ascent = metrics.getFontProperty(3, view.getDocumentView().isPrintView());
            apply = (float)height > 1.5f * (float)ascent;
        }
        return apply;
    }

    public static class BracketCache {
        private HashMap map = new HashMap();

        public synchronized RenderedBracket getBracket(Font font, int size) {
            RenderedBracket bracket = null;
            RenderedBracket[] value = (RenderedBracket[])this.map.get(font);
            if (value != null && size < value.length) {
                bracket = value[size];
            }
            return bracket;
        }

        public synchronized void setBracket(Font font, int size, RenderedBracket bracket) {
            RenderedBracket[] brackets = (RenderedBracket[])this.map.get(font);
            if (brackets == null || brackets.length <= size) {
                int sizeMod = size == 0 ? 2 : size * 2;
                RenderedBracket[] newValue = new RenderedBracket[sizeMod];
                if (brackets != null) {
                    System.arraycopy(brackets, 0, newValue, 0, brackets.length);
                }
                brackets = newValue;
            }
            brackets[size] = bracket;
            this.map.put(font, brackets);
        }
    }

    protected static class DefaultRenderedBracket
    implements RenderedBracket {
        private int[] screenPositions;
        private int[] printPositions;
        private Font font;
        private Font screenFont = null;
        private Font printFont = null;
        private char[] data;
        private int screenWidth = 0;
        private int printWidth = 0;
        private Font oversize;
        boolean shrinkable;
        private int height;

        protected DefaultRenderedBracket(char[] data, Font f, Font oversize, int height, boolean shrinkable) {
            this(data, f, oversize, height, shrinkable, null);
        }

        protected DefaultRenderedBracket(char[] data, Font f, Font oversize, int height, boolean shrinkable, Font forceFont) {
            this.data = data;
            this.oversize = oversize;
            this.shrinkable = shrinkable;
            this.height = height;
            this.screenPositions = null;
            this.printPositions = null;
            this.font = forceFont != null ? forceFont.deriveFont(0, f.getSize2D()) : (RuntimePlatform.isEsstix() ? multicharacterFontSourceEsstix.deriveFont(0, f.getSize2D()) : multicharacterFontSourceMaplePi.deriveFont(0, f.getSize2D()));
        }

        protected String getSingleCharacterFont() {
            return WmiBracketRenderer.OVERSIZED_BRACKET_FONT;
        }

        @Override
        public boolean singleCharacterBracketAllowed() {
            return true;
        }

        @Override
        public void validateLayout(boolean forPrinting) {
            if (forPrinting && this.printPositions == null || !forPrinting && this.screenPositions == null) {
                this.layoutBracket(forPrinting);
            }
        }

        protected void layoutBracket(boolean forPrinting) {
            int[] positions;
            int width = 0;
            Font f = this.font;
            WmiFontMetrics metrics = WmiFontResolver.getFontMetrics(f);
            char ch = this.data[0];
            int topAscent = metrics.getCharacterProperty(4, ch, forPrinting);
            int topDescent = metrics.getCharacterProperty(5, ch, forPrinting);
            int topHeight = topAscent + topDescent;
            width = metrics.getCharacterProperty(2, ch, forPrinting) + metrics.getCharacterProperty(3, ch, forPrinting);
            ch = this.data[1];
            int fillAscent = metrics.getCharacterProperty(4, ch, forPrinting);
            int fillDescent = metrics.getCharacterProperty(5, ch, forPrinting);
            int fillHeight = fillAscent + fillDescent;
            ch = this.data[2];
            int bottomAscent = metrics.getCharacterProperty(4, ch, forPrinting);
            int bottomDescent = metrics.getCharacterProperty(5, ch, forPrinting);
            int bottomHeight = bottomAscent + bottomDescent;
            width += metrics.getCharacterProperty(1, ch, forPrinting);
            if (this.height < topHeight + bottomHeight && this.singleCharacterBracketAllowed()) {
                int fontsize = f.getSize();
                metrics = WmiFontResolver.getFontMetrics(f = this.oversize.deriveFont(0, fontsize));
                topAscent = metrics.getCharacterProperty(4, ch = this.data[3], forPrinting);
                topHeight = topAscent + (topDescent = metrics.getCharacterProperty(5, ch, forPrinting));
                float scale = (float)this.height / (float)topHeight;
                int adjustedPointSize = Math.round(scale * (float)fontsize);
                if (adjustedPointSize != fontsize) {
                    f = this.oversize.deriveFont(0, adjustedPointSize);
                    metrics = WmiFontResolver.getFontMetrics(f);
                    ch = this.data[3];
                    topAscent = metrics.getCharacterProperty(4, ch, forPrinting);
                }
                width = metrics.getCharacterProperty(2, ch, forPrinting);
                positions = new int[]{topAscent};
            } else {
                int residual = this.height - topHeight - bottomHeight;
                int fillCount = 1 + residual / fillHeight;
                int trim = fillHeight * fillCount - residual;
                int overlap = (int)Math.ceil((float)trim / (float)(fillCount + 2));
                fillCount = 1 + residual / (fillHeight - overlap);
                int offset = 0;
                if (overlap > topHeight / 4 && this.shrinkable && fillCount > 0) {
                    int newHeight = topHeight + bottomHeight + --fillCount * fillHeight;
                    overlap = 0;
                    offset = 1 + (this.height - newHeight) / 2;
                }
                positions = new int[fillCount + 2];
                positions[0] = topAscent + offset;
                positions[fillCount + 1] = this.height - bottomDescent - offset;
                int fillPos = topHeight + fillAscent - overlap + offset;
                int i = 0;
                while (i < fillCount) {
                    positions[i + 1] = fillPos;
                    fillPos += fillHeight - overlap;
                    ++i;
                }
                if (fillCount > 1) {
                    positions[positions.length - 2] = this.height - bottomHeight - offset - fillDescent + 2;
                }
            }
            if (forPrinting) {
                this.printWidth = width;
                this.printPositions = positions;
                this.printFont = f;
            } else {
                this.screenWidth = width;
                this.screenPositions = positions;
                this.screenFont = f;
            }
        }

        @Override
        public void draw(Graphics g, int x, int y, boolean forPrinting) {
            int[] positions;
            Font saveFont = g.getFont();
            Object antialias = null;
            if (g instanceof Graphics2D) {
                antialias = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (forPrinting) {
                positions = this.printPositions;
                g.setFont(this.printFont);
            } else {
                positions = this.screenPositions;
                g.setFont(this.screenFont);
            }
            if (positions != null) {
                int size = positions.length;
                if (size == 1) {
                    g.drawString(Character.toString(this.data[3]), x, y + positions[0]);
                } else {
                    g.drawString(Character.toString(this.data[0]), x, y + positions[0]);
                    String fill = Character.toString(this.data[1]);
                    int i = 1;
                    while (i < size - 1) {
                        g.drawString(fill, x, y + positions[i]);
                        ++i;
                    }
                    g.drawString(Character.toString(this.data[2]), x, y + positions[size - 1]);
                }
            }
            g.setFont(saveFont);
            if (antialias != null) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias);
            }
        }

        @Override
        public int getWidth(boolean forPrint) {
            return forPrint ? this.printWidth : this.screenWidth;
        }
    }

    public static interface RenderedBracket {
        public void draw(Graphics var1, int var2, int var3, boolean var4);

        public int getWidth(boolean var1);

        public void validateLayout(boolean var1);

        public boolean singleCharacterBracketAllowed();
    }
}

