/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;

public abstract class WmiParenRenderer
extends WmiGlyphRenderer {
    private static final float MAX_PRIMARY_STRETCH = 0.5f;
    private static final float SMALL_MEDIUM_TRANSITION_SCALE = 1.3f;
    private static final float MEDIUM_LARGE_TRANSITION_SCALE = 1.6f;
    private static final float[][] BIG_PAREN_OUTLINE = new float[][]{{0.3701031f, 0.9852577f}, {0.3536082f, 1.0f}, {0.0484536f, 0.8731959f, 0.0484536f, 0.5103093f}, {0.0484536f, 0.4896907f}, {0.0484536f, 0.1268041f, 0.3636082f, 0.0f}, {0.3701031f, 0.0247423f}, {0.1783505f, 0.1556702f, 0.1474227f, 0.243299f}, {0.108866f, 0.3523704f, 0.108866f, 0.4896907f}, {0.108866f, 0.5103093f}, {0.108866f, 0.6690722f, 0.1474227f, 0.756701f}, {0.1783505f, 0.8379381f, 0.3701031f, 0.9852577f}};
    private static int[] BIG_PAREN_MORPH = new int[]{3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3};
    private static final float[][] MEDIUM_PAREN_OUTLINE = new float[][]{{0.17951669f, 1.0f}, {0.10471807f, 0.9309551f, 0.050632913f, 0.7848101f}, {0.0f, 0.64787114f, 0.0f, 0.5373993f}, {0.0f, 0.46144995f}, {0.0f, 0.3521289f, 0.050632913f, 0.21403913f}, {0.10471807f, 0.06904488f, 0.17951669f, 0.0f}, {0.17951669f, 0.0287687f}, {0.10471807f, 0.16915995f, 0.081703104f, 0.25546604f}, {0.0575374f, 0.3475259f, 0.0575374f, 0.49942464f}, {0.0575374f, 0.6513234f, 0.081703104f, 0.74453396f}, {0.10471807f, 0.83084005f, 0.17951669f, 0.9712313f}, {0.17951669f, 1.0f}, new float[0]};
    private static final int[] MEDIUM_PAREN_MORPH;
    private static final float[][] SMALL_PAREN_OUTLINE;
    private static final int[] SMALL_PAREN_MORPH;
    private static final float[][][] OUTLINES;
    private static final int[][] MORPHS;

    static {
        int[] nArray = new int[13];
        nArray[0] = 3;
        nArray[1] = 3;
        nArray[2] = 3;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 6;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        MEDIUM_PAREN_MORPH = nArray;
        SMALL_PAREN_OUTLINE = new float[][]{{0.22147653f, 0.97449666f}, {0.20536913f, 1.0f}, {0.0f, 0.87248325f, 0.0f, 0.49f}, {0.0f, 0.5f}, {0.0f, 0.51f}, {0.0f, 0.1261745f, 0.20536913f, 0.0f}, {0.22147653f, 0.024161074f}, {0.13020135f, 0.102013424f, 0.09932886f, 0.24295303f}, {0.08053692f, 0.33020136f, 0.08053692f, 0.49f}, {0.08053692f, 0.5f}, {0.08053692f, 0.51f}, {0.08053692f, 0.6684564f, 0.09932886f, 0.7557047f}, {0.13020135f, 0.89664435f, 0.22147653f, 0.97449666f}, new float[0]};
        int[] nArray2 = new int[14];
        nArray2[0] = 3;
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[10] = 3;
        nArray2[11] = 3;
        nArray2[12] = 3;
        SMALL_PAREN_MORPH = nArray2;
        OUTLINES = new float[][][]{SMALL_PAREN_OUTLINE, MEDIUM_PAREN_OUTLINE, BIG_PAREN_OUTLINE};
        MORPHS = new int[][]{SMALL_PAREN_MORPH, MEDIUM_PAREN_MORPH, BIG_PAREN_MORPH};
    }

    @Override
    protected float[][] getGlyphOutline() {
        return SMALL_PAREN_OUTLINE;
    }

    @Override
    protected int[] getStretchRules() {
        return SMALL_PAREN_MORPH;
    }

    @Override
    public WmiGlyphRenderer.RenderedGlyph createGlyph(Font font, int size) {
        float fontSize = font.getSize2D();
        float scale = (float)size / fontSize;
        int index = 0;
        if (scale > 1.6f) {
            index = 2;
        } else {
            fontSize *= scale;
            if (scale > 1.3f) {
                index = 1;
            }
        }
        int[] rules = MORPHS[index];
        float[][] source = OUTLINES[index];
        float[][] clone = new float[source.length][];
        int i = 0;
        while (i < source.length) {
            float[] segment = source[i];
            clone[i] = new float[segment.length];
            System.arraycopy(segment, 0, clone[i], 0, segment.length);
            ++i;
        }
        this.morphGlyph(clone, fontSize, size, rules);
        return new WmiGlyphRenderer.RenderedGlyph(clone);
    }

    @Override
    protected boolean isBracket() {
        return true;
    }

    @Override
    public boolean forcePreKernAdjustment(WmiMathOperatorView view) {
        return true;
    }

    @Override
    public boolean forcePostKernAdjustment(WmiMathOperatorView view) {
        return true;
    }

    protected void morphGlyph(float[][] data, float fontSize, int size, int[] morphRules) {
    }

    protected void applyScaling(float[][] data, float fontSize, int size, int[] morphRules) {
        if (morphRules == BIG_PAREN_MORPH) {
            float[] segment;
            this.uniformScale(data, fontSize);
            float stretch = ((float)size - fontSize) / fontSize;
            float midpoint = 0.5f * fontSize;
            float shift = 0.5f * ((float)size - fontSize);
            boolean applySecondaryStretch = false;
            if (stretch > 0.5f) {
                stretch = 0.5f;
                applySecondaryStretch = true;
                shift = 0.5f * stretch * fontSize;
            }
            int i = 0;
            while (i < data.length) {
                segment = data[i];
                if (segment.length == 2) {
                    segment[1] = segment[1] + (shift - (midpoint - segment[1]) * stretch);
                    if (segment[1] < 0.0f) {
                        if (stretch == 0.5f) {
                            System.out.print("** ");
                        }
                        System.out.println(String.valueOf(fontSize) + ", " + segment[1]);
                    }
                } else if (segment.length == 4) {
                    segment[1] = segment[1] + (shift - (midpoint - segment[1]) * stretch);
                    segment[3] = segment[3] + (shift - (midpoint - segment[3]) * stretch);
                }
                ++i;
            }
            if (applySecondaryStretch) {
                midpoint = 0.5f * (stretch + 1.0f) * fontSize;
                shift = (float)size - 2.0f * midpoint;
                i = 0;
                while (i < data.length) {
                    segment = data[i];
                    if (segment.length == 2) {
                        if (segment[1] > midpoint) {
                            segment[1] = segment[1] + shift;
                        }
                    } else if (segment.length == 4) {
                        if (segment[1] > midpoint) {
                            segment[1] = segment[1] + shift;
                        }
                        if (segment[3] > midpoint) {
                            segment[3] = segment[3] + shift;
                        }
                    }
                    ++i;
                }
            }
        } else {
            this.stretchScale(data, fontSize, size, morphRules);
        }
    }

    public static class WmiLeftParenRenderer
    extends WmiParenRenderer {
        @Override
        protected void morphGlyph(float[][] data, float fontSize, int size, int[] morphRules) {
            this.applyScaling(data, fontSize, size, morphRules);
        }
    }

    public static class WmiRightParenRenderer
    extends WmiParenRenderer {
        @Override
        protected void morphGlyph(float[][] data, float fontSize, int size, int[] morphRules) {
            this.applyScaling(data, fontSize, size, morphRules);
            this.rotate180(data);
        }
    }
}

