/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiAbstractOperatorRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class WmiSetMinusRenderer
extends WmiAbstractOperatorRenderer {
    @Override
    public void layoutView(WmiMathOperatorView view) throws WmiNoReadAccessException {
    }

    @Override
    public void draw(Graphics g, WmiRenderPath path, Rectangle bounds, WmiMathOperatorView view) {
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        Font font = view.getFont();
        WmiFontAttributeSet attributes = view.getFontAttributes();
        int xOffset = path.getHorizontalOffset();
        int yOffset = path.getVerticalOffset();
        int xViewOffs = view.getHorizontalOffset();
        int yViewOffs = view.getVerticalOffset();
        int xViewPos = xViewOffs + xOffset;
        int width = view.getWidth();
        boolean highlighted = path.isSelected(xOffset + xViewOffs, width);
        if (highlighted) {
            WmiMathDocumentView docView = view.getDocumentView();
            Color background = docView.getColor(4);
            Color foreground = docView.getColor(3);
            g.setColor(background);
            g.fillRect(xViewPos, yOffset, width, view.getHeight());
            g.setColor(foreground);
        } else {
            if (attributes.isOpaque()) {
                g.setColor(new Color(attributes.getBackground()));
                g.fillRect(xViewPos, yOffset, width, view.getHeight());
            }
            g.setColor(new Color(attributes.getForeground()));
        }
        WmiTextLayout setMinus = WmiTextLayout.createTextLayout("\u2216", font, view.getDocumentView());
        setMinus.draw(g, xViewPos, yOffset + yViewOffs + view.getHeight());
        g.setFont(oldFont);
        g.setColor(oldColor);
    }
}

