/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.ConversionException;
import com.maplesoft.util.ConversionStyle;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DOMBuilderConversion
implements ConversionStyle {
    @Override
    public String getConversionSchemeID() {
        return "BuildDOM:";
    }

    @Override
    public ConversionStyle createWithArgument(String argument) {
        return new DOMBuilderConversion();
    }

    @Override
    public Object convert(Object source, String targetFormat) throws ConversionException, IllegalArgumentException {
        if (!(targetFormat.equalsIgnoreCase("dom") || targetFormat.equalsIgnoreCase("org.w3c.dom.Document") || targetFormat.equalsIgnoreCase("document"))) {
            throw new IllegalArgumentException("com.maplesoft.util.DOMBuilderConversion: only supports dom output");
        }
        if (!(source instanceof String) && !(source instanceof File)) {
            throw new IllegalArgumentException("com.maplesoft.util.DOMBuilderConversion: only supports String and File source");
        }
        try {
            Document result = null;
            DocumentBuilder db = this.getDocumentBuilder();
            InputSource is = null;
            if (source instanceof String) {
                String sourceStr = (String)source;
                if (sourceStr.indexOf("\n") > -1 || sourceStr.indexOf("\t") > -1) {
                    StringBuffer sourceMod = new StringBuffer((String)source);
                    int i = 0;
                    while (i < sourceMod.length()) {
                        char c = sourceMod.charAt(i);
                        if (c == '\n') {
                            sourceMod.replace(i, i + 1, "&#x0A;");
                        } else if (c == '\t') {
                            sourceMod.replace(i, i + 1, "&#x09;");
                        }
                        ++i;
                    }
                    source = sourceMod.toString();
                }
                is = new InputSource(new StringReader((String)source));
            } else {
                is = new InputSource(new FileInputStream((File)source));
            }
            result = db.parse(is);
            return result;
        }
        catch (Exception e1) {
            throw new ConversionException(e1);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        dbf.setIgnoringElementContentWhitespace(false);
        return dbf.newDocumentBuilder();
    }

    @Override
    public Object convert(InputStream source, String targetFormat) throws ConversionException, IllegalArgumentException {
        try {
            if (!(targetFormat.equalsIgnoreCase("dom") || targetFormat.equalsIgnoreCase("org.w3c.dom.Document") || targetFormat.equalsIgnoreCase("document"))) {
                throw new IllegalArgumentException("com.maplesoft.util.DOMBuilderConversion: only supports dom output");
            }
            Document result = null;
            DocumentBuilder db = this.getDocumentBuilder();
            InputSource is = new InputSource(source);
            result = db.parse(is);
            return result;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }
}

