/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.ConversionException;
import com.maplesoft.util.ConversionStyle;
import java.io.InputStream;

public class EntityStringConversion
implements ConversionStyle {
    private boolean convertStandardEntities = true;

    @Override
    public String getConversionSchemeID() {
        return "expentity:";
    }

    public EntityStringConversion() {
    }

    @Override
    public ConversionStyle createWithArgument(String argument) {
        return new EntityStringConversion(argument);
    }

    public EntityStringConversion(String argument) {
        if (argument.equals("escape-only")) {
            this.convertStandardEntities = false;
        }
    }

    @Override
    public Object convert(Object source, String targetFormat) throws ConversionException, IllegalArgumentException {
        if (!(targetFormat.equalsIgnoreCase("string") || targetFormat.equalsIgnoreCase("xml") || targetFormat.equals("java.lang.String"))) {
            throw new IllegalArgumentException("com.maplesoft.util.EntityStringConversion: only supports String or XML output");
        }
        if (!(source instanceof String)) {
            throw new IllegalArgumentException("com.maplesoft.util.EntityStringConversion: only supports String source");
        }
        try {
            String result = this.modifyString((String)source, null);
            return result;
        }
        catch (Exception e1) {
            throw new ConversionException(e1);
        }
    }

    private String modifyString(String target, String entity) {
        StringBuffer modification = new StringBuffer(target);
        int ampposition = 0;
        int semiposition = 0;
        boolean success = false;
        do {
            success = false;
            ampposition = modification.indexOf("&");
            if (ampposition <= -1 || (semiposition = modification.indexOf(";")) <= -1) continue;
            String entityt = modification.substring(ampposition, semiposition + 1);
            if (entityt.equals(entity) || entity == null && this.entityMatch(entityt)) {
                entity = entity == null ? entityt : entity;
                modification.replace(ampposition, semiposition + 1, this.entityReplace(entity));
                success = true;
            }
            semiposition = 0;
            ampposition = 0;
        } while (ampposition > -1 && semiposition > -1 && success);
        return modification.toString();
    }

    public boolean entityMatch(String entity) {
        return entity.equals("&quot;") || entity.equals("&lt;") || entity.equals("&gt;") || entity.equals("&apos;") || entity.equals("&#8;") || entity.equals("&#12;") || entity.equals("&#13;") || entity.equals("&#9;") || entity.equals("&#10;");
    }

    public String entityReplace(String entity) {
        String val = "";
        if (entity.equals("&quot;")) {
            val = "\"";
        } else if (entity.equals("&lt;")) {
            val = "<";
        } else if (entity.equals("&gt;")) {
            val = ">";
        } else if (entity.equals("&apos;")) {
            val = "&";
        }
        if (this.convertStandardEntities) {
            if (entity.equals("&#8;")) {
                val = "\b";
            } else if (entity.equals("&#12;")) {
                val = "\f";
            } else if (entity.equals("&#10;")) {
                val = "\n";
            } else if (entity.equals("&#13;")) {
                val = "\r";
            } else if (entity.equals("&#9;")) {
                val = "\t";
            }
        }
        return val;
    }

    @Override
    public Object convert(InputStream source, String targetFormat) throws IllegalArgumentException {
        throw new IllegalArgumentException("com.maplesoft.util.EntityStringConversion: does not support InputStreams");
    }
}

