/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.FontTools;
import com.maplesoft.util.MapleFontLoader;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringToolsJapanese;
import java.awt.Font;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class FontSwingTools {
    private static final int JAPANESE_UI_FONT_SIZE = 12;
    protected static final Font JAPANESE_UI_FONT = new Font(MapleFontLoader.mapFontFamilyName(FontTools.JAPANESE_UI_FONT_NAME), 0, 12);

    public static void setLocalizedFont(JComponent component) {
        Locale locale;
        if (!RuntimePlatform.isMac() && RuntimeLocale.isJapanese() && !(locale = Locale.getDefault()).equals(Locale.JAPAN) && !locale.equals(Locale.JAPANESE)) {
            String text = null;
            if (component instanceof AbstractButton) {
                text = ((AbstractButton)component).getText();
            } else if (component instanceof JLabel) {
                text = ((JLabel)component).getText();
            }
            if (text != null && StringToolsJapanese.isJapaneseText(text)) {
                component.setFont(JAPANESE_UI_FONT);
            }
        }
    }

    public static void setLocalizedFont(TitledBorder border) {
        Locale locale;
        if (!RuntimePlatform.isMac() && RuntimeLocale.isJapanese() && !(locale = Locale.getDefault()).equals(Locale.JAPAN) && !locale.equals(Locale.JAPANESE) && StringToolsJapanese.isJapaneseText(border.getTitle())) {
            border.setTitleFont(JAPANESE_UI_FONT);
        }
    }
}

