/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.Quantize;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class GifExport {
    private static final int MAX_GIF_COLOURS = 255;
    private BufferedImage[] images;
    private int delay = 1;
    private GifCompressor compressor;
    private int[] colormap;
    private int nColors = 255;

    public GifExport(BufferedImage image) {
        this(new BufferedImage[]{image}, 1);
    }

    public GifExport(BufferedImage[] theImages, int theDelay) {
        this(theImages, theDelay, 255);
    }

    public GifExport(BufferedImage[] theImages, int theDelay, int ncolors) {
        this.images = theImages;
        this.delay = theDelay;
        if (this.delay < 1) {
            this.delay = 1;
        }
        if (ncolors > 0 && ncolors <= 255) {
            this.nColors = ncolors;
        }
        this.quantize();
    }

    private void quantize() {
        int[][] pixels = new int[this.images[0].getWidth()][this.images.length * this.images[0].getHeight()];
        int i = 0;
        while (i < this.images.length) {
            int n = 0;
            while (n < this.images[0].getWidth()) {
                int m = 0;
                while (m < this.images[0].getHeight()) {
                    pixels[n][m + this.images[0].getHeight() * i] = this.images[i].getRGB(n, m);
                    ++m;
                }
                ++n;
            }
            ++i;
        }
        this.colormap = Quantize.quantizeImage(pixels, this.nColors);
        byte[] red = new byte[this.colormap.length];
        byte[] green = new byte[this.colormap.length];
        byte[] blue = new byte[this.colormap.length];
        byte[] alpha = new byte[this.colormap.length];
        Arrays.fill(alpha, (byte)-1);
        alpha[0] = 0;
        int q = 0;
        while (q < this.colormap.length) {
            red[q] = (byte)(this.colormap[q] >> 16 & 0xFF);
            green[q] = (byte)(this.colormap[q] >> 8 & 0xFF);
            blue[q] = (byte)(this.colormap[q] >> 0 & 0xFF);
            ++q;
        }
        IndexColorModel colormodel = new IndexColorModel(8, this.colormap.length, red, green, blue, alpha);
        ColorConvertOp cv = new ColorConvertOp(colormodel.getColorSpace(), null);
        int i2 = 0;
        while (i2 < this.images.length) {
            BufferedImage tmp = cv.createCompatibleDestImage(this.images[i2], colormodel);
            int n = 0;
            while (n < this.images[i2].getWidth()) {
                int m = 0;
                while (m < this.images[i2].getHeight()) {
                    tmp.setRGB(n, m, this.colormap[pixels[n][m + this.images[0].getHeight() * i2]]);
                    ++m;
                }
                ++n;
            }
            this.images[i2] = tmp;
            ++i2;
        }
    }

    public boolean export(String filename) {
        boolean success = false;
        try {
            FileOutputStream fstream = new FileOutputStream(filename);
            success = this.export(fstream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return success;
    }

    public boolean export(OutputStream out) {
        boolean success = false;
        try {
            this.writeString(out, "GIF89a");
            this.write16(out, this.images[0].getWidth());
            this.write16(out, this.images[0].getHeight());
            int n = this.colormap.length;
            int BitsPerPixel = n <= 4 ? 2 : (n <= 16 ? 4 : 8);
            byte colormapflag = -128;
            colormapflag = (byte)(colormapflag | 0x70);
            colormapflag = (byte)(colormapflag | (byte)(BitsPerPixel - 1));
            this.write8(out, colormapflag);
            this.write8(out, (byte)0);
            this.write8(out, (byte)0);
            this.exportPalette(out, this.colormap, n);
            if (this.images.length > 1) {
                this.exportLoopBlock(out);
            }
            int i = 0;
            while (i < this.images.length) {
                this.exportControlBlock(out, this.delay, i);
                this.exportImageData(out, this.colormap, BitsPerPixel, i);
                ++i;
            }
            this.write8(out, (byte)59);
            out.flush();
            out.close();
            success = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success;
    }

    protected int computePaletteBits(int paletteSize) {
        int count = 0;
        --paletteSize;
        while (paletteSize != 0) {
            ++count;
            paletteSize >>= 1;
        }
        return count;
    }

    protected void exportLoopBlock(OutputStream ostream) {
        this.write8(ostream, (byte)33);
        this.write8(ostream, (byte)-1);
        this.write8(ostream, (byte)11);
        this.writeString(ostream, "NETSCAPE2.0");
        this.write8(ostream, (byte)3);
        this.write8(ostream, (byte)1);
        this.write16(ostream, 0);
        this.write8(ostream, (byte)0);
    }

    protected void exportControlBlock(OutputStream ostream, int theDelay, int frame) {
        DataBuffer db = this.images[frame].getRaster().getDataBuffer();
        int transp = 0;
        int i = 0;
        while (i < db.getSize()) {
            if (db.getElem(i) == 0) {
                transp = 1;
                break;
            }
            ++i;
        }
        this.write8(ostream, (byte)33);
        this.write8(ostream, (byte)-7);
        this.write8(ostream, (byte)4);
        this.write8(ostream, (byte)(transp | 8));
        this.write16(ostream, (short)theDelay);
        this.write8(ostream, (byte)0);
        this.write8(ostream, (byte)0);
    }

    protected void exportImageData(OutputStream ostream, int[] paletteLookupTable, int paletteBits) {
        this.exportImageData(ostream, paletteLookupTable, paletteBits, 0);
    }

    protected void exportImageData(OutputStream ostream, int[] paletteLookupTable, int paletteBits, int imagenum) {
        Raster raster = this.images[imagenum].getData();
        DataBuffer buffer = raster.getDataBuffer();
        this.compressor = new GifCompressor(buffer);
        this.write8(ostream, (byte)44);
        this.write16(ostream, 0);
        this.write16(ostream, 0);
        this.write16(ostream, this.images[imagenum].getWidth());
        this.write16(ostream, this.images[imagenum].getHeight());
        this.write8(ostream, (byte)0);
        this.write8(ostream, (byte)paletteBits);
        this.compressor.encode(ostream, paletteLookupTable, paletteBits);
        this.write8(ostream, (byte)0);
    }

    protected void exportPalette(OutputStream ostream, int[] colourLookupTable, int paletteSize) {
        int n = paletteSize;
        int bitsPerPixel = n <= 4 ? 2 : (n <= 16 ? 4 : 8);
        int colorMapSize = 1 << bitsPerPixel;
        int i = 0;
        while (i < colorMapSize) {
            if (i < colourLookupTable.length) {
                this.write8(ostream, (byte)(colourLookupTable[i] >> 16 & 0xFF));
                this.write8(ostream, (byte)(colourLookupTable[i] >> 8 & 0xFF));
                this.write8(ostream, (byte)(colourLookupTable[i] & 0xFF));
            } else {
                this.write8(ostream, (byte)0);
                this.write8(ostream, (byte)0);
                this.write8(ostream, (byte)0);
            }
            ++i;
        }
    }

    protected void write8(OutputStream ostream, byte b) {
        try {
            ostream.write(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void write16(OutputStream ostream, int value) {
        try {
            ostream.write(value & 0xFF);
            ostream.write(value >> 8 & 0xFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void writeBytes(OutputStream ostream, byte[] value, int length) {
        try {
            ostream.write(value, 0, length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void writeString(OutputStream ostream, String value) {
        try {
            ostream.write(value.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class GifCompressor {
        private int BIT_LIMIT = 12;
        private int initialBits;
        private int clearCode;
        private int eofCode;
        private int baseCode;
        private int initialBump;
        private int initialClear;
        private int maxCodes;
        private int runlengthPixel = 0;
        private int runlengthCount = 0;
        private int offset = 0;
        private int tableMax = 0;
        private int tablePixel = 0;
        private boolean justCleared = true;
        private OutputStream ostream;
        private int outBits;
        private int outCount;
        private int outBump;
        private int outClear;
        private int obits;
        private int oblen;
        private int obuf;
        private byte[] oblock = new byte[256];
        private DataBuffer buffer;

        protected GifCompressor(DataBuffer dBuffer) {
            this.buffer = dBuffer;
        }

        public void encode(OutputStream outStream, int[] paletteLookupTable, int paletteBits) {
            this.ostream = outStream;
            int size = this.buffer.getSize();
            this.initialize(paletteBits);
            int pixel = 0;
            while (this.offset < size) {
                pixel = this.buffer.getElem(this.offset++);
                if (this.runlengthCount > 0 && pixel != this.runlengthPixel) {
                    this.encodeRun();
                }
                if (this.runlengthPixel == pixel) {
                    ++this.runlengthCount;
                    continue;
                }
                this.runlengthPixel = pixel;
                this.runlengthCount = 1;
            }
            if (this.runlengthCount > 0) {
                this.encodeRun();
            }
            this.output(this.eofCode);
            if (this.obits > 0) {
                this.outputBlock((byte)this.obuf);
            }
            this.blockFlush();
        }

        protected void blockFlush() {
            if (this.oblen > 0) {
                this.writeBlock();
            }
        }

        protected int computeTriangleCount(int count, int nrepcodes) {
            int cost = 0;
            int perrep = nrepcodes * (nrepcodes + 1) / 2;
            while (count >= perrep) {
                cost += nrepcodes;
                count -= perrep;
            }
            if (count > 0) {
                int n = this.intSqrt(count);
                while (n * (n + 1) >= 2 * count) {
                    --n;
                }
                while (n * (n + 1) < 2 * count) {
                    ++n;
                }
                cost += n;
            }
            return cost;
        }

        /*
         * Unable to fully structure code
         */
        protected void encodeClearOrRep(int count) {
            block1: {
                withclr = 1 + this.computeTriangleCount(count, this.maxCodes);
                if (withclr >= count) ** GOTO lbl9
                this.output(this.clearCode);
                this.reset();
                this.encodeFromClear(count);
                break block1;
lbl-1000:
                // 1 sources

                {
                    this.outputPlain(this.runlengthPixel);
                    --count;
lbl9:
                    // 2 sources

                    ** while (count > 0)
                }
            }
        }

        protected void encodeFromClear(int count) {
            int n = 1;
            this.outClear = this.maxCodes;
            this.tablePixel = this.runlengthPixel;
            while (count > 0) {
                if (n == 1) {
                    this.tableMax = 1;
                    this.outputPlain(this.runlengthPixel);
                    --count;
                } else if (count >= n) {
                    this.tableMax = n;
                    this.outputPlain(this.baseCode + n - 2);
                    count -= n;
                } else if (count == 1) {
                    ++this.tableMax;
                    this.outputPlain(this.runlengthPixel);
                    count = 0;
                } else {
                    ++this.tableMax;
                    this.outputPlain(this.baseCode + count - 2);
                    count = 0;
                }
                if (this.outCount == 0) {
                    n = 1;
                    continue;
                }
                ++n;
            }
            this.outClear = this.initialClear;
            if (this.outCount >= this.outClear) {
                this.output(this.clearCode);
                this.reset();
            }
        }

        protected void encodeRun() {
            if (this.runlengthCount == 1) {
                this.outputPlain(this.runlengthPixel);
            } else if (this.justCleared) {
                this.encodeFromClear(this.runlengthCount);
            } else if (this.tableMax < 2 || this.tablePixel != this.runlengthPixel) {
                this.encodeClearOrRep(this.runlengthCount);
            } else {
                this.encodeWithTable(this.runlengthCount);
            }
            this.runlengthCount = 0;
        }

        protected void encodeWithTable(int count) {
            int repleft;
            int repmax = count / this.tableMax;
            int leftover = count % this.tableMax;
            int n = repleft = leftover != 0 ? 1 : 0;
            if (this.outCount + repmax + repleft > this.maxCodes) {
                repmax = this.maxCodes - this.outCount;
                leftover = count - repmax * this.tableMax;
                repleft = 1 + this.computeTriangleCount(leftover, this.maxCodes);
            }
            if (1 + this.computeTriangleCount(count, this.maxCodes) < repmax + repleft) {
                this.output(this.clearCode);
                this.reset();
                this.encodeFromClear(count);
                return;
            }
            this.outClear = this.maxCodes;
            while (repmax > 0) {
                this.outputPlain(this.baseCode + this.tableMax - 2);
                --repmax;
            }
            if (leftover != 0) {
                if (this.justCleared) {
                    this.encodeFromClear(leftover);
                } else if (leftover == 1) {
                    this.outputPlain(this.runlengthPixel);
                } else {
                    this.outputPlain(this.baseCode + leftover - 2);
                }
            }
            this.outClear = this.initialClear;
            if (this.outCount >= this.outClear) {
                this.output(this.clearCode);
                this.reset();
            }
        }

        protected void initialize(int paletteBits) {
            this.obuf = 0;
            this.obits = 0;
            this.oblen = 0;
            this.initialBits = paletteBits + 1;
            this.clearCode = 1 << this.initialBits - 1;
            this.eofCode = this.clearCode + 1;
            this.baseCode = this.eofCode + 1;
            this.initialBump = (1 << this.initialBits - 1) - 1;
            this.initialClear = this.initialBits <= 4 ? 50 : this.initialBump - 1;
            this.maxCodes = (1 << this.BIT_LIMIT) - ((1 << this.initialBits - 1) + 3);
            this.reset();
            this.output(this.clearCode);
            this.runlengthCount = 0;
        }

        protected int intSqrt(int x) {
            int r = 0;
            int v = 0;
            int retValue = 0;
            if (x < 2) {
                retValue = x;
            } else {
                v = x;
                r = 1;
                while (v != 0) {
                    v >>= 2;
                    r <<= 1;
                }
                while (true) {
                    if ((v = (x / r + r) / 2) == r || v == r + 1) {
                        retValue = r;
                        break;
                    }
                    r = v;
                }
            }
            return retValue;
        }

        protected void output(int val) {
            this.obuf |= val << this.obits;
            this.obits += this.outBits;
            while (this.obits >= 8) {
                this.outputBlock((byte)(this.obuf & 0xFF));
                this.obuf >>= 8;
                this.obits -= 8;
            }
        }

        protected void outputBlock(byte c) {
            this.oblock[this.oblen++] = c;
            if (this.oblen >= 255) {
                this.writeBlock();
            }
        }

        protected void outputPlain(int pixel) {
            this.justCleared = false;
            this.output(pixel);
            ++this.outCount;
            if (this.outCount >= this.outBump) {
                ++this.outBits;
                this.outBump += 1 << this.outBits - 1;
            }
            if (this.outCount >= this.outClear) {
                this.output(this.clearCode);
                this.reset();
            }
        }

        protected void reset() {
            this.outBits = this.initialBits;
            this.outBump = this.initialBump;
            this.outClear = this.initialClear;
            this.outCount = 0;
            this.tableMax = 0;
            this.justCleared = true;
        }

        protected void writeBlock() {
            GifExport.this.write8(this.ostream, (byte)this.oblen);
            GifExport.this.writeBytes(this.ostream, this.oblock, this.oblen);
            this.oblen = 0;
        }
    }
}

