/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class Heap {
    private ArrayList array = null;
    private HashMap inverseMap = null;

    protected abstract HeapEntry createHeapEntry(int var1, int var2, Object var3);

    protected Heap(int itemCount) {
        this.array = new ArrayList(itemCount);
        this.inverseMap = new HashMap(itemCount);
    }

    protected Heap() {
        this.array = new ArrayList();
        this.inverseMap = new HashMap();
    }

    private HeapEntry get(int i) {
        if (i < 0 || i >= this.array.size()) {
            return null;
        }
        return (HeapEntry)this.array.get(i);
    }

    private void set(HeapEntry entry, int i) {
        if (i >= 0 && i < this.array.size()) {
            this.array.set(i, entry);
        }
        if (entry != null) {
            entry.index = i;
        }
    }

    private int getParentIndex(int index) {
        if (index == 0) {
            return -1;
        }
        return index - 1 >> 1;
    }

    private int getLeftChildIndex(int index) {
        return (index << 1) + 1;
    }

    private int getRightChildIndex(int index) {
        return (index << 1) + 2;
    }

    private boolean isEmpty(int index) {
        return this.get(index) == null;
    }

    private void swap(int i, int j) {
        HeapEntry obj_i = this.get(i);
        HeapEntry obj_j = this.get(j);
        this.set(obj_i, j);
        this.set(obj_j, i);
    }

    private void bubbleUp(int index) {
        HeapEntry current;
        if (index == 0) {
            return;
        }
        int parentIndex = this.getParentIndex(index);
        HeapEntry parent = this.get(parentIndex);
        if (parent.compareTo(current = this.get(index)) < 0) {
            this.swap(index, parentIndex);
            this.bubbleUp(parentIndex);
        }
    }

    private void bubbleDown(int index) {
        int leftIndex = this.getLeftChildIndex(index);
        int rightIndex = this.getRightChildIndex(index);
        HeapEntry current = this.get(index);
        HeapEntry left = this.get(leftIndex);
        HeapEntry right = this.get(rightIndex);
        if (left != null && left.compareTo(current) > 0 && (right == null || left.compareTo(right) > 0 || current.compareTo(right) > 0)) {
            this.swap(index, leftIndex);
            this.bubbleDown(leftIndex);
        } else if (right != null && right.compareTo(current) > 0) {
            this.swap(index, rightIndex);
            this.bubbleDown(rightIndex);
        }
    }

    public int getValue(Object obj) {
        int value = -1;
        HeapEntry entry = (HeapEntry)this.inverseMap.get(obj);
        if (entry != null) {
            value = entry.value;
        }
        return value;
    }

    public boolean setValue(Object obj, int value) {
        HeapEntry entry = (HeapEntry)this.inverseMap.get(obj);
        if (entry != null) {
            int oldTop = this.extractTopValue();
            entry.value = value;
            HeapEntry parent = this.get(this.getParentIndex(entry.index));
            if (parent != null && parent.compareTo(entry) < 0) {
                this.bubbleUp(entry.index);
            } else {
                this.bubbleDown(entry.index);
            }
            return oldTop != this.extractTopValue();
        }
        return false;
    }

    public boolean contains(Object obj) {
        return this.inverseMap.containsKey(obj);
    }

    protected Object extractTop() {
        HeapEntry entry = this.get(0);
        Object obj = null;
        if (entry != null) {
            obj = entry.obj;
        }
        return obj;
    }

    protected int extractTopValue() {
        HeapEntry entry = this.get(0);
        int value = -1;
        if (entry != null) {
            value = entry.value;
        }
        return value;
    }

    public boolean remove(Object obj) {
        HeapEntry entry = (HeapEntry)this.inverseMap.get(obj);
        if (entry != null) {
            int oldTop = this.extractTopValue();
            this.inverseMap.remove(obj);
            int index = entry.index;
            this.set(null, index);
            int savedIndex = index;
            int nextIndex = 0;
            while (!this.isEmpty(nextIndex = index << 1)) {
                this.swap(index, nextIndex);
                index = nextIndex;
            }
            if (index >= 0 && index < this.array.size()) {
                this.array.remove(index);
            }
            this.bubbleDown(savedIndex);
            return oldTop != this.extractTopValue();
        }
        return false;
    }

    public void clear() {
        this.array.clear();
        this.inverseMap.clear();
    }

    public boolean add(Object obj, int value) {
        int oldTop = -1;
        int index = this.array.size();
        if (index != 0) {
            oldTop = this.extractTopValue();
        }
        HeapEntry entry = this.createHeapEntry(value, index, obj);
        this.array.add(entry);
        this.inverseMap.put(obj, entry);
        this.bubbleUp(index);
        if (index != 0) {
            return oldTop != this.extractTopValue();
        }
        return true;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        this.toString(0, 0, buffy);
        return buffy.toString();
    }

    private void toString(int arrayIndex, int indent, StringBuffer buffy) {
        if (!this.isEmpty(arrayIndex)) {
            int i = 0;
            while (i < indent) {
                buffy.append("    ");
                ++i;
            }
            HeapEntry entry = this.get(arrayIndex);
            buffy.append(String.valueOf(entry.value) + " " + entry.obj + "\n");
            this.toString(this.getLeftChildIndex(arrayIndex), indent + 1, buffy);
            this.toString(this.getRightChildIndex(arrayIndex), indent + 1, buffy);
        }
    }

    protected static abstract class HeapEntry
    implements Comparable {
        public int value;
        public int index;
        public Object obj;

        protected HeapEntry(int hValue, int hIndex, Object hObj) {
            this.value = hValue;
            this.index = hIndex;
            this.obj = hObj;
        }

        public abstract int compareTo(Object var1);
    }

    public static class HeapMax
    extends Heap {
        public HeapMax() {
        }

        public HeapMax(int i) {
            super(i);
        }

        @Override
        protected HeapEntry createHeapEntry(int value, int index, Object obj) {
            return new HeapMaxEntry(value, index, obj);
        }

        public Object extractMax() {
            return this.extractTop();
        }

        public int extractMaxValue() {
            return this.extractTopValue();
        }

        private static class HeapMaxEntry
        extends HeapEntry {
            private HeapMaxEntry(int i, int v, Object o) {
                super(i, v, o);
            }

            @Override
            public int compareTo(Object other) {
                HeapEntry entry = (HeapEntry)other;
                if (this.value > entry.value) {
                    return 1;
                }
                if (this.value < entry.value) {
                    return -1;
                }
                return 0;
            }
        }
    }

    public static class HeapMin
    extends Heap {
        public HeapMin() {
        }

        public HeapMin(int i) {
            super(i);
        }

        @Override
        protected HeapEntry createHeapEntry(int value, int index, Object obj) {
            return new HeapMinEntry(value, index, obj);
        }

        public Object extractMin() {
            return this.extractTop();
        }

        public int extractMinValue() {
            return this.extractTopValue();
        }

        private static class HeapMinEntry
        extends HeapEntry {
            private HeapMinEntry(int i, int v, Object o) {
                super(i, v, o);
            }

            @Override
            public int compareTo(Object other) {
                HeapEntry entry = (HeapEntry)other;
                if (this.value < entry.value) {
                    return 1;
                }
                if (this.value > entry.value) {
                    return -1;
                }
                return 0;
            }
        }
    }
}

