/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;

public class Logger {
    private static HashMap categoryMap = new HashMap();
    private static boolean loggingActivated = false;
    private static Class loggerClass = null;
    private static Class categoryClass = null;
    private static Constructor categoryConstructor = null;
    private static Method initOnMethod = null;
    private static Method initOffMethod = null;
    private static Method debug1Method = null;
    private static Method debug2Method = null;
    private static Method info1Method = null;
    private static Method info2Method = null;
    private static Method warn1Method = null;
    private static Method warn2Method = null;
    private static Method error1Method = null;
    private static Method error2Method = null;
    private static Method emerg1Method = null;
    private static Method emerg2Method = null;
    private static Method isDebugEnabledMethod = null;
    private static Method isInfoEnabledMethod = null;

    protected Logger() {
    }

    private static Object getCategoryObject(String category) {
        Object categoryObject = null;
        if (categoryMap.containsKey(category)) {
            return categoryMap.get(category);
        }
        Object[] args = new Object[]{category};
        try {
            categoryObject = categoryConstructor.newInstance(args);
            categoryMap.put(category, categoryObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return categoryObject;
    }

    private static void initializeMethods() throws ClassNotFoundException, NoSuchMethodException {
        categoryClass = Class.forName("com.ibm.log4j.Category");
        Class[] args = new Class[]{String.class};
        categoryConstructor = categoryClass.getDeclaredConstructor(args);
        Class[] empty = new Class[]{};
        Class[] string1 = new Class[]{String.class};
        Class[] category1 = new Class[]{categoryClass};
        Class[] categorystring2 = new Class[]{categoryClass, String.class};
        initOnMethod = loggerClass.getMethod("initOn", string1);
        initOffMethod = loggerClass.getMethod("initOff", empty);
        debug1Method = loggerClass.getMethod("debug", string1);
        debug2Method = loggerClass.getMethod("debug", categorystring2);
        info1Method = loggerClass.getMethod("info", string1);
        info2Method = loggerClass.getMethod("info", categorystring2);
        warn1Method = loggerClass.getMethod("warn", string1);
        warn2Method = loggerClass.getMethod("warn", categorystring2);
        error1Method = loggerClass.getMethod("error", string1);
        error2Method = loggerClass.getMethod("error", categorystring2);
        emerg1Method = loggerClass.getMethod("emerg", string1);
        emerg2Method = loggerClass.getMethod("emerg", categorystring2);
        isDebugEnabledMethod = loggerClass.getMethod("isDebugEnabled", category1);
        isInfoEnabledMethod = loggerClass.getMethod("isInfoEnabled", category1);
    }

    private static void initializeLogger() {
        try {
            loggerClass = Class.forName("com.ibm.log4j.WMILogging");
            loggingActivated = true;
            Logger.initializeMethods();
        }
        catch (ClassNotFoundException e) {
            loggingActivated = false;
            return;
        }
        catch (NoSuchMethodException e) {
            loggingActivated = false;
            return;
        }
    }

    public static void activate(String configFile) {
        if (!loggingActivated) {
            Logger.initializeLogger();
        }
        Object[] objects = new Object[]{configFile};
        try {
            initOnMethod.invoke((Object)loggerClass, objects);
        }
        catch (Exception e) {
            loggingActivated = false;
            return;
        }
    }

    public static void deactivate() {
        if (!loggingActivated) {
            Logger.initializeLogger();
        }
        Object[] objects = new Object[]{};
        try {
            initOffMethod.invoke((Object)loggerClass, objects);
        }
        catch (Exception e) {
            loggingActivated = false;
        }
    }

    public static void debug(String message) {
        if (loggingActivated) {
            Object[] objects = new Object[]{message};
            try {
                debug1Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void debug(String category, String message) {
        if (loggingActivated) {
            try {
                Object categoryObject = Logger.getCategoryObject(category);
                Object[] objects = new Object[]{categoryObject, message};
                debug2Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void infolog(String message) {
        if (loggingActivated) {
            Object[] objects = new Object[]{message};
            try {
                info1Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void info(Object object) {
        Logger.infolog(object.toString());
    }

    public static void info(int i) {
        Logger.infolog(Integer.toString(i));
    }

    public static void info(char c) {
        Logger.infolog(String.valueOf(c));
    }

    public static void info(long l) {
        Logger.infolog(Long.toString(l));
    }

    public static void info(double d) {
        Logger.infolog(Double.toString(d));
    }

    public static void info(float f) {
        Logger.infolog(Float.toString(f));
    }

    public static void info(boolean b) {
        Logger.infolog(String.valueOf(b));
    }

    public static void info(String category, String message) {
        if (loggingActivated) {
            try {
                Object categoryObject = Logger.getCategoryObject(category);
                Object[] objects = new Object[]{categoryObject, message};
                info2Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void warn(String message) {
        if (loggingActivated) {
            Object[] objects = new Object[]{message};
            try {
                warn1Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void warn(String category, String message) {
        if (loggingActivated) {
            try {
                Object categoryObject = Logger.getCategoryObject(category);
                Object[] objects = new Object[]{categoryObject, message};
                warn2Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void error() {
        Logger.errorlog("\n");
    }

    public static void error(Object object) {
        Logger.errorlog(object.toString());
    }

    public static void errorlog(String message) {
        if (loggingActivated) {
            Object[] objects = new Object[]{message};
            try {
                error1Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void error(String category, String message) {
        if (loggingActivated) {
            try {
                Object categoryObject = Logger.getCategoryObject(category);
                Object[] objects = new Object[]{categoryObject, message};
                error2Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void emerg(String message) {
        if (loggingActivated) {
            Object[] objects = new Object[]{message};
            try {
                emerg1Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void emerg(String category, String message) {
        if (loggingActivated) {
            try {
                Object categoryObject = Logger.getCategoryObject(category);
                Object[] objects = new Object[]{categoryObject, message};
                emerg2Method.invoke((Object)loggerClass, objects);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.toString());
            }
        }
    }

    public static void log(String priority, String category, String message) {
    }

    public static boolean isDebugEnabled(String category) {
        if (!loggingActivated) {
            return false;
        }
        try {
            Object categoryObject = Logger.getCategoryObject(category);
            Object[] objects = new Object[]{categoryObject};
            Object val = isDebugEnabledMethod.invoke((Object)loggerClass, objects);
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInfoEnabled(String category) {
        if (!loggingActivated) {
            return false;
        }
        try {
            Object categoryObject = Logger.getCategoryObject(category);
            Object[] objects = new Object[]{categoryObject};
            Object val = isInfoEnabledMethod.invoke((Object)loggerClass, objects);
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

