/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class MapleFileChooser
extends JFileChooser {
    private static final String COULD_NOT_FIND_FILE = "Could not find file ";
    public static final String WIN_SHORTCUT_EXT = ".lnk";
    protected File[] macSelectedFiles = null;

    public MapleFileChooser() {
    }

    public MapleFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public MapleFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected static File getWindowsShortcut(File file) throws InvocationTargetException {
        File linkedTo = null;
        if (MapleFileChooser.isWindowsShortcut(file)) {
            try {
                Class<?> shellFolderClass = Class.forName("sun.awt.shell.ShellFolder");
                Class[] paramSpecification = new Class[1];
                Object[] finalArguments = new Object[1];
                Method getShellFolderFromSun = null;
                paramSpecification[0] = Class.forName("java.io.File");
                getShellFolderFromSun = shellFolderClass.getMethod("getShellFolder", paramSpecification);
                finalArguments[0] = file;
                Object shellFolder = getShellFolderFromSun.invoke(null, finalArguments);
                Method getLinkLocationFromSun = shellFolderClass.getMethod("getLinkLocation", null);
                Object result = getLinkLocationFromSun.invoke(shellFolder, null);
                if (result instanceof File) {
                    linkedTo = (File)result;
                }
            }
            catch (ClassNotFoundException shellFolderClass) {
            }
            catch (NoSuchMethodException shellFolderClass) {
            }
            catch (IllegalAccessException shellFolderClass) {
            }
            catch (InvocationTargetException ite) {
                FileNotFoundException fileE;
                String msg;
                boolean handled = false;
                Throwable twb = ite.getTargetException();
                if (twb instanceof FileNotFoundException && (msg = (fileE = (FileNotFoundException)twb).getMessage()) != null && msg.startsWith(COULD_NOT_FIND_FILE)) {
                    String linkPath = msg.substring(COULD_NOT_FIND_FILE.length(), msg.length());
                    linkedTo = new File(linkPath);
                    handled = true;
                }
                if (!handled) {
                    throw ite;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return linkedTo;
    }

    public static boolean isWindowsShortcut(File file) {
        boolean isShortcut = false;
        if (file != null) {
            isShortcut = RuntimePlatform.isWindows() && file.getName().toLowerCase().endsWith(WIN_SHORTCUT_EXT);
        }
        return isShortcut;
    }

    protected boolean processApprovedFile(File file) {
        return true;
    }

    private int showAwtFileDialog(Component parent, int type) {
        if (!(parent instanceof Frame)) {
            parent = SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        FileDialog d = new FileDialog((Frame)parent, this.getDialogTitle(), type);
        if (this.macSelectedFiles != null && this.macSelectedFiles[0] != null) {
            File currentDir = this.getCurrentDirectory();
            if (currentDir != null) {
                d.setDirectory(currentDir.getPath());
            } else {
                d.setDirectory(this.macSelectedFiles[0].getParent());
            }
            d.setFile(this.macSelectedFiles[0].getName());
        } else {
            d.setDirectory(this.getCurrentDirectory().getPath());
        }
        final FileFilter filter = this.getFileFilter();
        d.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File candidate = new File(String.valueOf(dir.getPath()) + name);
                return filter.accept(candidate);
            }
        });
        d.setVisible(true);
        String filename = d.getFile();
        int res = 1;
        if (filename != null) {
            res = 0;
            this.setCurrentDirectory(new File(d.getDirectory()));
            this.macSelectedFiles = new File[]{new File(String.valueOf(d.getDirectory()) + filename)};
            this.approveSelection();
        }
        return res;
    }

    @Override
    public void setSelectedFile(File file) {
        if (RuntimePlatform.isMac()) {
            this.macSelectedFiles = new File[]{file};
        } else {
            super.setSelectedFile(file);
        }
    }

    @Override
    public File getSelectedFile() {
        if (RuntimePlatform.isMac()) {
            return this.macSelectedFiles != null ? this.macSelectedFiles[0] : null;
        }
        return super.getSelectedFile();
    }

    @Override
    public File[] getSelectedFiles() {
        if (RuntimePlatform.isMac()) {
            return this.macSelectedFiles;
        }
        return super.getSelectedFiles();
    }

    @Override
    public int showOpenDialog(Component parent) {
        int res = 0;
        res = RuntimePlatform.isMac() ? this.showAwtFileDialog(parent, 0) : super.showOpenDialog(parent);
        return res;
    }

    @Override
    public int showSaveDialog(Component parent) {
        int res = 0;
        res = RuntimePlatform.isMac() ? this.showAwtFileDialog(parent, 1) : super.showSaveDialog(parent);
        return res;
    }

    @Override
    public void approveSelection() {
        File[] selectedFiles = null;
        selectedFiles = this.isMultiSelectionEnabled() ? this.getSelectedFiles() : new File[]{this.getSelectedFile()};
        int approvedFiles = 0;
        int f = 0;
        while (f < selectedFiles.length) {
            File file = selectedFiles[f];
            try {
                File linkedTo = MapleFileChooser.getWindowsShortcut(file);
                if (linkedTo != null) {
                    if (linkedTo.isDirectory()) {
                        this.setCurrentDirectory(linkedTo);
                        this.setSelectedFile(null);
                        this.rescanCurrentDirectory();
                        return;
                    }
                    if (!linkedTo.equals(file)) {
                        this.setSelectedFile(linkedTo);
                        file = this.getSelectedFile();
                    }
                }
            }
            catch (InvocationTargetException ite) {
                return;
            }
            if (this.processApprovedFile(file)) {
                ++approvedFiles;
            }
            ++f;
        }
        if (selectedFiles.length > 0 && approvedFiles == selectedFiles.length) {
            super.approveSelection();
        }
    }
}

