/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.Cp1250Encoder;
import com.maplesoft.util.encoder.Cp1251Encoder;
import com.maplesoft.util.encoder.Cp1252Encoder;
import com.maplesoft.util.encoder.Cp1253Encoder;
import com.maplesoft.util.encoder.Cp1254Encoder;
import com.maplesoft.util.encoder.Cp1256Encoder;
import com.maplesoft.util.encoder.Cp1257Encoder;
import com.maplesoft.util.encoder.Cp1258Encoder;
import com.maplesoft.util.encoder.Cp874Encoder;
import com.maplesoft.util.encoder.Cp936Encoder;
import com.maplesoft.util.encoder.Cp949Encoder;
import com.maplesoft.util.encoder.Cp950Encoder;
import com.maplesoft.util.encoder.KernelEncoder;
import com.maplesoft.util.encoder.MacCenteuroEncoder;
import com.maplesoft.util.encoder.MacChinsimpEncoder;
import com.maplesoft.util.encoder.MacChintradEncoder;
import com.maplesoft.util.encoder.MacCroatianEncoder;
import com.maplesoft.util.encoder.MacCyrillicEncoder;
import com.maplesoft.util.encoder.MacGreekEncoder;
import com.maplesoft.util.encoder.MacIcelandEncoder;
import com.maplesoft.util.encoder.MacJapaneseEncoder;
import com.maplesoft.util.encoder.MacKoreanEncoder;
import com.maplesoft.util.encoder.MacRomanEncoder;
import com.maplesoft.util.encoder.MacRomanianEncoder;
import com.maplesoft.util.encoder.MacThaiEncoder;
import com.maplesoft.util.encoder.MacTurkishEncoder;
import com.maplesoft.util.encoder.ShiftJISEncoder;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public class RuntimeLocale {
    public static final Locale GREEK = new Locale("el");
    public static final Locale HUNGARIAN = new Locale("hu");
    private static final String[] CP1250 = new String[]{"hrv", "ces", "hun", "pol", "ron", "slk", "slv"};
    private static final String[] CP1251 = new String[]{"bul", "rus"};
    private static final String[] CP1252 = new String[]{"cat", "dan", "nld", "eng", "fin", "fra", "deu", "ita", "nor", "por", "spa", "swe"};
    private static final String[] CP1257 = new String[]{"est", "lav", "lit"};
    private static final String CP1253 = "ell";
    private static final String CP1254 = "tur";
    private static final String CP1256 = "ara";
    private static final String CP1258 = "vie";
    private static final String CP874 = "tha";
    private static final String CHINESE = "zho";
    private static final String SHIFT_JIS = "jpn";
    private static final String CP949 = "kor";
    private static final String[] MACCENTEURO = new String[]{"ces", "est", "hun", "lav", "lit", "pol", "slk", "slv", "wen"};
    private static final String[] MACTURKISH = new String[]{"kur", "tur"};
    private static final String[] MACCYRILLIC = new String[]{"bel", "bul", "mkd", "mol", "rus", "srp", "ukr"};
    private static final String[] MACROMAN = new String[]{"sqi", "dan", "nld", "eng", "fin", "fra", "deu", "ita", "nor", "por", "spa", "swe"};
    private static final String MACCHINESE = "zho";
    private static final String MACCROATIAN = "hrv";
    private static final String MACGREEK = "ell";
    private static final String MACICELAND = "isl";
    private static final String MACJAPANESE = "jpn";
    private static final String MACKOREAN = "kor";
    private static final String MACROMANIAN = "ron";
    private static final String MACTHAI = "tha";
    private static boolean isGreek = false;
    private static boolean isJapanese = false;
    private static boolean isKorean = false;
    private static boolean isSimplifiedChinese = false;
    private static KernelEncoder kernelEncoder = null;
    private static AbstractStringEncoder exportEncoder = null;
    private static Locale encodingLocale = null;
    private static Locale displayLocale = null;
    private static Set supportedLocalizations = new HashSet();

    static {
        Locale locale = Locale.getDefault();
        if (RuntimePlatform.isMac() || RuntimePlatform.isWindows()) {
            RuntimeLocale.setFlags(locale);
        }
        RuntimeLocale.addSupportedLocalization(Locale.ENGLISH);
        RuntimeLocale.addSupportedLocalization(Locale.JAPANESE);
    }

    private static void setFlags(Locale l) {
        isGreek = RuntimeLocale.areLocalesEqual(l, GREEK);
        isJapanese = !isGreek && RuntimeLocale.areLocalesEqual(l, Locale.JAPANESE);
        isKorean = !isJapanese && RuntimeLocale.areLocalesEqual(l, Locale.KOREAN);
        isSimplifiedChinese = !isKorean && RuntimeLocale.areLocalesEqual(l, Locale.SIMPLIFIED_CHINESE);
    }

    public static void setDisplayLocale(Locale l) {
        if (l == null) {
            throw new NullPointerException("Display locale cannot be null");
        }
        if (!RuntimeLocale.isSupported(l = RuntimeLocale.normalize(l)) && !RuntimeLocale.isSupported(l = RuntimeLocale.normalize(Locale.getDefault()))) {
            l = Locale.ENGLISH;
        }
        displayLocale = l;
        RuntimeLocale.setFlags(l);
    }

    public static void setDisplayLocale(String l) {
        RuntimeLocale.setDisplayLocale(RuntimeLocale.decodeLocale(l));
    }

    public static Locale getDisplayLocale() {
        if (displayLocale == null) {
            displayLocale = encodingLocale != null && RuntimeLocale.isSupported(encodingLocale) ? encodingLocale : (RuntimeLocale.isSupported(Locale.getDefault()) ? RuntimeLocale.normalize(Locale.getDefault()) : Locale.ENGLISH);
        }
        return displayLocale;
    }

    public static String getDisplayEnvVariableName() {
        Locale l = RuntimeLocale.getDisplayLocale();
        String messageLocale = "C";
        if (l != null) {
            if (RuntimeLocale.areLocalesEqual(l, Locale.JAPANESE)) {
                if (RuntimePlatform.isWindows()) {
                    messageLocale = "Japanese_Japan.932";
                } else if (RuntimePlatform.isMac() || RuntimePlatform.isUnix()) {
                    messageLocale = "ja_JP";
                }
            } else if (RuntimeLocale.areLocalesEqual(l, Locale.SIMPLIFIED_CHINESE)) {
                if (RuntimePlatform.isWindows()) {
                    messageLocale = "Chinese_People's Republic of China.936";
                } else if (RuntimePlatform.isMac() || RuntimePlatform.isUnix()) {
                    messageLocale = "zh_CN";
                }
            } else if (RuntimeLocale.areLocalesEqual(l, Locale.ENGLISH)) {
                if (RuntimePlatform.isWindows()) {
                    messageLocale = "English_United States.1252";
                } else if (RuntimePlatform.isMac() || RuntimePlatform.isUnix()) {
                    messageLocale = "C";
                }
            }
        }
        return messageLocale;
    }

    public static void setEncodingLocale(Locale l) {
        encodingLocale = RuntimeLocale.normalize(l);
    }

    public static void setEncodingLocale(String l) {
        RuntimeLocale.setEncodingLocale(RuntimeLocale.decodeLocale(l));
    }

    public static Locale decodeLocale(String locale) {
        String language = "";
        String country = "";
        String variant = "";
        String[] la = locale.split("_");
        language = la[0];
        if (la.length > 1) {
            country = la[1];
        }
        if (la.length > 2) {
            variant = la[2];
        }
        return new Locale(language, country, variant);
    }

    public static Locale getEncodingLocale() {
        return encodingLocale != null ? encodingLocale : Locale.getDefault();
    }

    public static void addSupportedLocalization(Locale l) {
        supportedLocalizations.add(RuntimeLocale.normalize(l));
    }

    public static boolean isSupported(Locale l) {
        return supportedLocalizations.contains(RuntimeLocale.normalize(l));
    }

    public static Locale normalize(Locale l) {
        if (l.getLanguage().equals("zh")) {
            if (l.getVariant().length() > 0) {
                l = new Locale("zh", l.getCountry());
            }
        } else if (l.getCountry().length() > 0 || l.getVariant().length() > 0) {
            l = new Locale(l.getLanguage());
        }
        return l;
    }

    public static boolean areLocalesEqual(Locale l1, Locale l2) {
        return RuntimeLocale.normalize(l1).equals(RuntimeLocale.normalize(l2));
    }

    public static boolean isSimplifiedChinese() {
        return isSimplifiedChinese;
    }

    public static boolean isJapanese() {
        return isJapanese;
    }

    public static boolean isKorean() {
        return isKorean;
    }

    public static boolean isGreek() {
        return isGreek;
    }

    public static Iterator getSupportedLocaleIterator() {
        return supportedLocalizations.iterator();
    }

    public static KernelEncoder getKernelEncoder() {
        if (kernelEncoder == null) {
            kernelEncoder = RuntimePlatform.isWindows() ? new KernelEncoder(RuntimeLocale.getExportEncoder()) : new KernelEncoder(new UTF8Encoder());
        }
        return kernelEncoder;
    }

    public static void setKernelEncoder(AbstractStringEncoder e) {
        kernelEncoder = new KernelEncoder(e);
    }

    public static void setExportEncoder(AbstractStringEncoder theEncoder) {
        if (theEncoder == null) {
            theEncoder = RuntimeLocale.selectDefaultExportEncoder();
        }
        exportEncoder = theEncoder;
    }

    public static AbstractStringEncoder getExportEncoder() {
        if (exportEncoder == null) {
            RuntimeLocale.setExportEncoder(RuntimeLocale.selectDefaultExportEncoder());
        }
        return exportEncoder;
    }

    private static AbstractStringEncoder selectDefaultExportEncoder() {
        String language = null;
        Locale l = RuntimeLocale.getEncodingLocale();
        try {
            language = l.getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AbstractStringEncoder theEncoder = null;
        if (language != null) {
            if (RuntimePlatform.isWindows()) {
                if (Arrays.binarySearch(CP1252, language) >= 0) {
                    theEncoder = new Cp1252Encoder();
                } else if (Arrays.binarySearch(CP1251, language) >= 0) {
                    theEncoder = new Cp1251Encoder();
                } else if (Arrays.binarySearch(CP1250, language) >= 0) {
                    theEncoder = new Cp1250Encoder();
                } else if (Arrays.binarySearch(CP1257, language) >= 0) {
                    theEncoder = new Cp1257Encoder();
                } else if (language.equals("jpn")) {
                    theEncoder = new ShiftJISEncoder();
                } else if (language.equals("zho")) {
                    String country = "";
                    try {
                        country = l.getISO3Country();
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    theEncoder = country.equals("CHN") ? new Cp936Encoder() : new Cp950Encoder();
                } else {
                    theEncoder = language.equals("kor") ? new Cp949Encoder() : (language.equals("ell") ? new Cp1253Encoder() : (language.equals(CP1254) ? new Cp1254Encoder() : (language.equals(CP1256) ? new Cp1256Encoder() : (language.equals(CP1258) ? new Cp1258Encoder() : (language.equals("tha") ? new Cp874Encoder() : new Cp1252Encoder())))));
                }
            } else if (RuntimePlatform.isMac()) {
                String country;
                theEncoder = Arrays.binarySearch(MACROMAN, language) >= 0 ? new MacRomanEncoder() : (Arrays.binarySearch(MACCYRILLIC, language) >= 0 ? new MacCyrillicEncoder() : (Arrays.binarySearch(MACCENTEURO, language) >= 0 ? new MacCenteuroEncoder() : (Arrays.binarySearch(MACTURKISH, language) >= 0 ? new MacTurkishEncoder() : (language.equals("jpn") ? new MacJapaneseEncoder() : (language.equals("kor") ? new MacKoreanEncoder() : (language.equals("zho") ? ((country = Locale.getDefault().getISO3Country()).equals("CHN") ? new MacChinsimpEncoder() : new MacChintradEncoder()) : (language.equals(MACCROATIAN) ? new MacCroatianEncoder() : (language.equals("ell") ? new MacGreekEncoder() : (language.equals(MACICELAND) ? new MacIcelandEncoder() : (language.equals(MACROMANIAN) ? new MacRomanianEncoder() : (language.equals("tha") ? new MacThaiEncoder() : new MacRomanEncoder())))))))))));
            }
        }
        if (theEncoder == null) {
            theEncoder = new UTF8Encoder();
        }
        return theEncoder;
    }

    private RuntimeLocale() {
    }
}

