/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.WmiSearchException;
import com.maplesoft.util.WmiSearchVisitor;

public class SearchAlgorithms {
    public static final int FORWARDS = 1;
    public static final int BACKWARDS = -1;

    private SearchAlgorithms() {
    }

    public static Object depthFirstSearch(Object root, ChildOperation ops, MatchCondition condition, int dir) throws WmiSearchException {
        if (root != null && condition.matchesCondition(root)) {
            return root;
        }
        if (!ops.hasChildren(root)) {
            return null;
        }
        if (dir != 1 && dir != -1) {
            throw new IllegalArgumentException("invalid direction");
        }
        int numkids = ops.getChildCount(root);
        int i = 0;
        while (i < numkids) {
            int seachIndex = dir == 1 ? i : numkids - i - 1;
            Object child = ops.getChild(root, seachIndex);
            Object childSearchResult = SearchAlgorithms.depthFirstSearch(child, ops, condition, dir);
            if (childSearchResult != null) {
                return childSearchResult;
            }
            ++i;
        }
        return null;
    }

    public static boolean depthFirstVisit(Object root, ChildOperation ops, MatchCondition searchCondition, MatchCondition stopCondition, int dir, WmiSearchVisitor visitor) throws WmiSearchException {
        boolean continueFlag = true;
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor not defined.");
        }
        if (dir != 1 && dir != -1) {
            throw new IllegalArgumentException("invalid direction");
        }
        int result = 0;
        if (root != null && (searchCondition == null || searchCondition.matchesCondition(root)) && (result = visitor.visitMatch(root)) == 2) {
            return false;
        }
        if (root != null && stopCondition != null && stopCondition.matchesCondition(root)) {
            return true;
        }
        if (ops.hasChildren(root) && result == 0) {
            int numkids = ops.getChildCount(root);
            int start = dir == 1 ? 0 : numkids - 1;
            int end = dir == 1 ? numkids - 1 : 0;
            int i = start;
            while (continueFlag && i <= end) {
                Object child = ops.getChild(root, i);
                continueFlag = SearchAlgorithms.depthFirstVisit(child, ops, searchCondition, stopCondition, dir, visitor);
                numkids = ops.getChildCount(root);
                end = dir == 1 ? numkids - 1 : 0;
                i += dir;
            }
        }
        return continueFlag;
    }

    public static Object parentSearch(Object node, ParentOperation ops, MatchCondition condition) throws WmiSearchException {
        Object traverser = node;
        while (traverser != null) {
            if (condition.matchesCondition(traverser)) break;
            traverser = ops.getParent(traverser);
        }
        return traverser;
    }

    public static interface ChildOperation {
        public boolean hasChildren(Object var1);

        public Object getChild(Object var1, int var2) throws WmiSearchException;

        public int getChildCount(Object var1) throws WmiSearchException;
    }

    public static interface MatchCondition {
        public boolean matchesCondition(Object var1);
    }

    public static interface ParentOperation {
        public Object getParent(Object var1) throws WmiSearchException;
    }
}

