/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.FontTools;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringToolsJapanese;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.Cp949Encoder;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringTools {
    private static Cp949Encoder cp949Encoder = null;
    private static boolean[] delimiterTable = null;
    public static final int TOO_LONG_TO_PASTE = 5000;
    public static final int MAX_LINE_LENGTH = 80;
    private static final float BUFFER_EXPANSION_FACTOR = 1.025f;
    public static final char[] HIRAGANA = new char[]{'\u3040', '\u309f'};
    public static final char[] KATAKANA = new char[]{'\u30a0', '\u30ff'};
    public static final char[] KATAKANA_EXT = new char[]{'\u31f0', '\u31ff'};
    public static final char[] HANGUL1 = new char[]{'\u3130', '\u318f'};
    public static final char[] HANGUL2 = new char[]{'\uac00', '\ud7af'};
    public static final char[] CJK1 = new char[]{'\u3000', '\u303f'};
    public static final char[] CJK2 = new char[]{'\u3200', '\u4dbf'};
    public static final char[] CJK3 = new char[]{'\u4e00', '\u9faf'};
    public static final char[] CJK4 = new char[]{'\ufe30', '\ufe4f'};
    public static final char[] CJK5 = new char[]{'\uff00', '\uffef'};
    public static final int[] CJK6 = new int[]{131072, 173791};
    public static final int[] CJK7 = new int[]{194560, 195103};
    public static final char DOUBLE_RIGHT_ANGLE_BRACKET = '\u300b';
    public static final char DOUBLE_LEFT_ANGLE_BRACKET = '\u300a';
    private static final int LATIN_UNICODE_LIMIT = 639;
    private static final int DELIMITER_TABLE_SIZE = 639;
    private static final int LATIN_1_DELIMITER_LOW = 128;
    private static final int LATIN_1_DELIMITER_HIGH = 191;
    private static final char LATIN_1_EXPLICIT_TIMES = '\u00d7';
    private static final char LATIN_1_INLINE_DIVIDE = '\u00f7';
    private static final int LATIN_EXT_B_DELIMITER_LOW = 448;
    private static final int LATIN_EXT_B_DELIMITER_HIGH = 451;
    private static final char[] DELIMITERS = new char[]{'.', ',', '?', '!', '\"', '\'', '(', ')', ';', ':', '{', '}', '[', ']', '<', '>', '@', '#', '$', '%', '^', '&', '*', '+', '~', '`', '\\', '/', '|', '\u00d7', '\u00f7'};
    public static String MS_MINCHO_ENGLISH = StringToolsJapanese.MINCHO_FONT_NAME;
    public static String MS_MINCHO_JAPANESE = StringToolsJapanese.MINCHO_ALTERNATE_NAME;
    public static String MS_PMINCHO_ENGLISH = StringToolsJapanese.PMINCHO_FONT_NAME;
    public static String MS_PMINCHO_JAPANESE = StringToolsJapanese.PMINCHO_ALTERNATE_NAME;
    public static String MS_GOTHIC_ENGLISH = StringToolsJapanese.GOTHIC_FONT_NAME;
    public static String MS_GOTHIC_JAPANESE = StringToolsJapanese.GOTHIC_ALTERNATE_NAME;
    public static String MS_PGOTHIC_ENGLISH = StringToolsJapanese.PGOTHIC_FONT_NAME;
    public static String MS_PGOTHIC_JAPANESE = StringToolsJapanese.PGOTHIC_ALTERNATE_NAME;
    public static final String JAPANESE_UI_FONT_NAME = FontTools.JAPANESE_UI_FONT_NAME;
    public static final String JAPANESE_CONTENT_FONT_NAME = FontTools.JAPANESE_CONTENT_FONT_NAME;

    private static Cp949Encoder getCP949Encoder() {
        if (cp949Encoder == null) {
            cp949Encoder = new Cp949Encoder();
        }
        return cp949Encoder;
    }

    public static String convertLongInput(String input) {
        String r = input;
        if (r != null && r.length() > 5000) {
            int pos = 0;
            StringBuffer buffy = new StringBuffer(1 + (int)((float)r.length() * 1.025f));
            boolean atEnd = false;
            boolean wasNewlineFound = true;
            while (pos < r.length()) {
                int nextNewlineInsertPos;
                int firstNewline;
                int n = firstNewline = wasNewlineFound ? r.indexOf(10, pos) : -1;
                if (firstNewline == -1) {
                    wasNewlineFound = false;
                }
                int n2 = nextNewlineInsertPos = firstNewline > 0 ? firstNewline : pos + 80;
                if (nextNewlineInsertPos >= r.length() - 1) {
                    nextNewlineInsertPos = r.length() - 1;
                    atEnd = true;
                }
                if (firstNewline == -1 && r.length() - pos > 80 || firstNewline - pos > 80) {
                    buffy.append(r.substring(pos, nextNewlineInsertPos));
                    if (!atEnd) {
                        buffy.append("\\\n");
                    }
                    pos = nextNewlineInsertPos;
                    continue;
                }
                if (buffy == null) continue;
                buffy.append(r.substring(pos, nextNewlineInsertPos + 1));
                pos = nextNewlineInsertPos + 1;
            }
            if (buffy != null) {
                r = buffy.toString();
            }
        }
        return r;
    }

    public static String replace(String source, String findPattern, String replacePattern) {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int offset = 0;
        while ((index = source.indexOf(findPattern, offset)) >= 0) {
            buffer.append(source.substring(offset, index));
            buffer.append(replacePattern);
            offset = index + findPattern.length();
        }
        buffer.append(source.substring(offset));
        return buffer.toString();
    }

    public static String escapeWindowsBackslashes(String s) {
        if (RuntimePlatform.isWindows() && s != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) == '\\') {
                    buffer.append("\\\\");
                } else {
                    buffer.append(s.charAt(i));
                }
                ++i;
            }
            s = buffer.toString();
        }
        return s;
    }

    public static ResourceBundle getResourceBundle(String resourceString) throws MissingResourceException {
        ResourceBundle resourceBundle = null;
        if (resourceString != null) {
            resourceBundle = ResourceBundle.getBundle(resourceString, RuntimeLocale.isJapanese() ? Locale.JAPAN : Locale.getDefault());
        }
        return resourceBundle;
    }

    public static String mapComponentName(String name, ResourceBundle b, int[] mnemonicIndexReference) {
        String reply = name;
        if (reply != null) {
            int index;
            if (b != null) {
                String translation = null;
                try {
                    translation = b.getString(reply);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (translation != null) {
                    reply = translation;
                }
            }
            if ((index = reply.indexOf(126)) >= 0) {
                reply = StringTools.removeTilde(reply);
            }
            if (mnemonicIndexReference != null) {
                mnemonicIndexReference[0] = RuntimePlatform.isMac() ? -1 : index;
            }
        }
        return reply;
    }

    public static String mapString(String name, ResourceBundle b) {
        return StringTools.mapString(name, b, true);
    }

    public static String mapString(String name, ResourceBundle b, boolean assignDefault) {
        String reply;
        String string = reply = assignDefault ? name : null;
        if (name != null && b != null) {
            try {
                String translation = b.getString(name);
                if (translation != null) {
                    reply = translation;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return reply;
    }

    public static String mapString(String name, String arg, ResourceBundle b) {
        String reply = StringTools.mapString(name, b);
        return reply.replaceAll("%1", arg);
    }

    public static String mapString(String name, String[] arg, ResourceBundle b) {
        String reply = StringTools.mapString(name, b);
        int i = 0;
        while (i < arg.length) {
            String replaceLabel = "%" + (i + 1);
            reply = reply.replaceAll(replaceLabel, arg[i]);
            ++i;
        }
        return reply;
    }

    public static String[] mapStringArray(String[] array, ResourceBundle b) {
        String[] r = new String[array.length];
        int i = 0;
        while (i < array.length) {
            r[i] = StringTools.mapString(array[i], b);
            ++i;
        }
        return r;
    }

    public static String removeTilde(String input) {
        String mappedName = input;
        int tilde = input.indexOf(126);
        if (tilde >= 0) {
            if (RuntimePlatform.isMac() && tilde > 0 && input.charAt(tilde - 1) == '(' && input.charAt(tilde + 2) == ')') {
                input = input.replaceAll("\\(~.\\)", "");
            }
            mappedName = input.replaceAll("~", "");
        }
        return mappedName;
    }

    public static boolean isWordDelimiter(char ch) {
        if (delimiterTable == null) {
            delimiterTable = new boolean[639];
            int i = 0;
            while (i <= 32) {
                StringTools.delimiterTable[i] = true;
                ++i;
            }
            i = 33;
            while (i < 639) {
                StringTools.delimiterTable[i] = false;
                ++i;
            }
            i = 0;
            while (i < DELIMITERS.length) {
                StringTools.delimiterTable[StringTools.DELIMITERS[i]] = true;
                ++i;
            }
            i = 128;
            while (i <= 191) {
                StringTools.delimiterTable[i] = true;
                ++i;
            }
            i = 448;
            while (i <= 451) {
                StringTools.delimiterTable[i] = true;
                ++i;
            }
        }
        return ch < '\u027f' ? delimiterTable[ch] : false;
    }

    public static String UTF8Encode(String source, boolean useXmlEncoding) {
        UTF8Encoder encoder = new UTF8Encoder();
        String result = encoder.fromUnicode(source);
        if (useXmlEncoding) {
            result = AbstractStringEncoder.xmlEncode(result);
        }
        return result;
    }

    public static String UTF8Decode(String source) {
        return StringTools.UTF8Decode(source, true);
    }

    public static String UTF8Decode(String source, boolean isXmlEncoded) {
        UTF8Encoder decoder = new UTF8Encoder();
        String result = isXmlEncoded ? AbstractStringEncoder.xmlDecode(source) : source;
        result = decoder.toUnicode(result);
        return result;
    }

    public static boolean isJapaneseHiraganaOrKatakana(char c) {
        return StringTools.inArrayRange(HIRAGANA, c) || StringTools.inArrayRange(KATAKANA, c) || StringTools.inArrayRange(KATAKANA_EXT, c);
    }

    public static boolean isKoreanHangul(char c) {
        return StringTools.inArrayRange(HANGUL1, c) || StringTools.inArrayRange(HANGUL2, c);
    }

    public static boolean isSharedCJKIdeograph(char c) {
        boolean ret = false;
        if (c >= CJK1[0] && (StringTools.inArrayRange(CJK1, c) && c != '\u300a' && c != '\u300b' || StringTools.inArrayRange(CJK2, c) || StringTools.inArrayRange(CJK3, c) || StringTools.inArrayRange(CJK4, c) || StringTools.inArrayRange(CJK5, c))) {
            ret = true;
        }
        return ret;
    }

    public static boolean isCJKCharacter(char c) {
        return StringTools.isJapaneseHiraganaOrKatakana(c) || StringTools.isKoreanHangul(c) || StringTools.isSharedCJKIdeograph(c);
    }

    private static boolean inArrayRange(char[] range, char c) {
        return range[0] <= c && c <= range[1];
    }

    public static String cp949Encode(String source, boolean useXmlEncoding) {
        String result = StringTools.getCP949Encoder().fromUnicode(source);
        return useXmlEncoding ? AbstractStringEncoder.xmlEncode(result) : result;
    }

    public static String cp949Decode(String source, boolean isXmlEncoded) {
        String result = isXmlEncoded ? AbstractStringEncoder.xmlDecode(source) : source;
        return StringTools.getCP949Encoder().toUnicode(result);
    }

    public static boolean isJapaneseText(String text) {
        return StringToolsJapanese.isJapaneseText(text);
    }

    public static boolean isJapaneseFont(String fontName) {
        return StringToolsJapanese.isJapaneseFont(fontName, true);
    }

    public static boolean isJapaneseFont(String fontName, boolean isOctal) {
        return StringToolsJapanese.isJapaneseFont(fontName, isOctal);
    }

    public static String shiftJISEncode(String source, boolean useXmlEncoding) {
        return StringToolsJapanese.shiftJISEncode(source, useXmlEncoding);
    }

    public static String shiftJISDecode(String source) {
        return StringToolsJapanese.shiftJISDecode(source);
    }
}

