/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.WmiMathEntityNameMapper;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WmiEntityConverter {
    private static ArrayList spaceEntities = new ArrayList();

    static {
        spaceEntities.add("InvisibleTimes");
        spaceEntities.add("nbsp");
        spaceEntities.add("NonBreakingSpace");
    }

    private WmiEntityConverter() {
    }

    public static String convertEscapeSequenceToEntityName(String encodedString, boolean stripBackquotes) {
        StringBuffer buffer = new StringBuffer(encodedString);
        boolean foundUnicodeChar = false;
        Pattern p = Pattern.compile("&#[0-9]+;");
        String matcherRange = buffer.toString();
        Matcher m = p.matcher(matcherRange);
        int lastStart = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String number = matcherRange.substring(start + 2, end - 1);
            try {
                try {
                    int value = Integer.parseInt(number);
                    String entity = WmiMathEntityNameMapper.getEntityName((char)value);
                    if (entity != null) {
                        foundUnicodeChar = true;
                        buffer.replace(lastStart + start, lastStart + end, "&" + entity + ";");
                        lastStart = lastStart + start + entity.length() + 2;
                    } else {
                        lastStart = end;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    matcherRange = matcherRange.substring(end);
                    m = p.matcher(matcherRange);
                    continue;
                }
            }
            catch (Throwable throwable) {
                matcherRange = matcherRange.substring(end);
                m = p.matcher(matcherRange);
                throw throwable;
            }
            matcherRange = matcherRange.substring(end);
            m = p.matcher(matcherRange);
        }
        encodedString = buffer.toString();
        if (foundUnicodeChar && stripBackquotes) {
            encodedString = encodedString.replaceAll("`", "");
        }
        return encodedString;
    }

    public static String convertEntityNameToUnicode(String encodedString, boolean stripBackquotes) {
        return WmiEntityConverter.convertEntityNameToUnicode(encodedString, stripBackquotes, false);
    }

    public static String convertEntityNameToUnicode(String encodedString, boolean stripBackquotes, boolean forMaplets) {
        return WmiEntityConverter.convertEntityNameToUnicode(encodedString, stripBackquotes, forMaplets, false);
    }

    public static String convertEntityNameToEscapeSequence(String encodedString, boolean stripBackquotes, boolean forMaplets) {
        return WmiEntityConverter.convertEntityNameToUnicode(encodedString, stripBackquotes, forMaplets, true);
    }

    private static String convertEntityNameToUnicode(String encodedString, boolean stripBackquotes, boolean forMaplets, boolean escapeSequence) {
        StringBuffer buffer = new StringBuffer(encodedString);
        boolean foundUnicodeChar = false;
        Pattern p = forMaplets ? Pattern.compile("&amp;[a-zA-Z]+;") : Pattern.compile("&[a-zA-Z]+;");
        String matcherRange = buffer.toString();
        Matcher m = p.matcher(matcherRange);
        int lastStart = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String name = forMaplets ? matcherRange.substring(start + 5, end - 1) : matcherRange.substring(start + 1, end - 1);
            char entity = WmiMathEntityNameMapper.getUnicodeCharacter(name);
            if (!(entity == '\u0000' || forMaplets && !WmiEntityConverter.isXmlSafeChar(entity) || forMaplets && spaceEntities.contains(name))) {
                String replacement = null;
                replacement = escapeSequence ? "&#" + Integer.toString(entity) + ";" : String.valueOf(entity);
                foundUnicodeChar = true;
                buffer.replace(lastStart + start, lastStart + end, replacement);
                lastStart += start + replacement.length();
            } else {
                lastStart += end;
            }
            matcherRange = matcherRange.substring(end);
            m = p.matcher(matcherRange);
        }
        encodedString = buffer.toString();
        if (foundUnicodeChar && stripBackquotes) {
            encodedString = encodedString.replaceAll("`", "");
        }
        return encodedString;
    }

    private static boolean isXmlSafeChar(char c) {
        return c != '<' && c != '>' && c != '\"' && c != '\'';
    }
}

