/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.util.ConversionException;
import com.maplesoft.util.ConversionStyle;
import com.maplesoft.util.FormatConverter;
import java.io.InputStream;
import org.w3c.dom.Document;

public class XML2DotMConversion
implements ConversionStyle {
    @Override
    public String getConversionSchemeID() {
        return "dotm:";
    }

    @Override
    public ConversionStyle createWithArgument(String argument) {
        return new XML2DotMConversion();
    }

    @Override
    public Object convert(Object source, String targetFormat) throws ConversionException, IllegalArgumentException {
        if (!(targetFormat.equalsIgnoreCase("string") || targetFormat.equalsIgnoreCase("dotm") || targetFormat.equals("java.lang.String"))) {
            throw new IllegalArgumentException("com.maplesoft.util.XML2DotMConversion: only supports String or dotm output");
        }
        if (!(source instanceof Document) && !(source instanceof String)) {
            throw new IllegalArgumentException("com.maplesoft.util.XML2DotMConversion: only supports Document or XML String source");
        }
        try {
            Document docSource = null;
            docSource = source instanceof Document ? (Document)source : (Document)FormatConverter.convert("BuildDOM:", source, "dom");
            String resultDotM = null;
            Dag intermediateDagFromDOM = DagBuilder.createDag(docSource);
            resultDotM = DagBuilder.createDotm(intermediateDagFromDOM, false);
            return resultDotM;
        }
        catch (Exception e1) {
            throw new ConversionException(e1);
        }
    }

    @Override
    public Object convert(InputStream source, String targetFormat) throws IllegalArgumentException {
        throw new IllegalArgumentException("com.maplesoft.util.XML2DotMConversion: does not support InputStreams");
    }
}

