/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.commandlineoptions;

import com.maplesoft.util.commandlineoptions.AbstractOptionHandler;
import com.maplesoft.util.commandlineoptions.CommandOptionException;
import com.maplesoft.util.commandlineoptions.CommandOptionParser;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeometryOptionHandler
extends AbstractOptionHandler {
    private int specifiedWidth = 0;
    private int specifiedHeight = 0;
    private int specifiedXPosition = 0;
    private int specifiedYPosition = 0;
    private boolean wasSet = false;
    public static final String GEOMETRY_OPTION = "geometry";
    public static final String CONCATENATION_CLEANING_SPEC = "eometry";
    public static final String GEOMETRY_REGEX = "(\\d+)x(\\d+)([\\+-])(-?\\d+)([\\+-])(-?\\d+)";

    public GeometryOptionHandler() {
        this.addOptionNames(new String[]{GEOMETRY_OPTION});
    }

    @Override
    public void handle(CommandOptionParser parser, String[] args) throws CommandOptionException {
        try {
            this.wasSet = false;
            String specification = this.cleanSpecification(args[1]);
            Pattern geomPattern = Pattern.compile(GEOMETRY_REGEX);
            Matcher findElements = geomPattern.matcher(specification);
            if (findElements.matches()) {
                String width = findElements.group(1);
                String height = findElements.group(2);
                String anchorX = findElements.group(3);
                String xpos = findElements.group(4);
                String anchorY = findElements.group(5);
                String ypos = findElements.group(6);
                this.specifiedWidth = Integer.parseInt(width);
                this.specifiedHeight = Integer.parseInt(height);
                this.specifiedXPosition = Integer.parseInt(xpos);
                this.specifiedYPosition = Integer.parseInt(ypos);
                Dimension screenDimensions = Toolkit.getDefaultToolkit().getScreenSize();
                if (anchorX.equals("-")) {
                    this.specifiedXPosition = (int)screenDimensions.getWidth() - this.specifiedWidth - this.specifiedXPosition;
                }
                if (anchorY.equals("-")) {
                    this.specifiedYPosition = (int)screenDimensions.getHeight() - this.specifiedHeight - this.specifiedYPosition;
                }
                this.wasSet = true;
            }
        }
        catch (Exception e1) {
            throw new CommandOptionException("Problem with format of geometry specification (" + this.cleanSpecification(args[0]) + ")");
        }
    }

    private String cleanSpecification(String argument) {
        return argument.startsWith(CONCATENATION_CLEANING_SPEC) ? argument.substring(CONCATENATION_CLEANING_SPEC.length()) : argument;
    }

    @Override
    public boolean isConcatenationAllowed() {
        return true;
    }

    @Override
    public int numArgs() {
        return 1;
    }

    public boolean isConfigured() {
        return this.wasSet;
    }

    public int getWidth() {
        return this.specifiedWidth;
    }

    public int getHeight() {
        return this.specifiedHeight;
    }

    public int getXPosition() {
        return this.specifiedXPosition;
    }

    public int getYPosition() {
        return this.specifiedYPosition;
    }
}

