/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.DefaultEncoder;
import com.maplesoft.util.encoder.codepage.AbstractCodePage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public abstract class AbstractStringEncoder {
    public static final String OCTAL_REGEX = "(?s:.*\\\\[0-7]{3}.*)";
    public static final int SINGLE_BYTE = 0;
    public static final int DOUBLE_BYTE = 1;
    private static HashMap nameMap = new HashMap();
    private Mapping mapping;
    private String name;

    protected AbstractStringEncoder(String name) {
        this.name = name;
        this.initialize();
    }

    protected void initialize() {
        if (this.name != null) {
            Object entry = nameMap.get(this.name);
            if (entry == null) {
                AbstractCodePage[] pages = this.getCodePages();
                if (pages != null) {
                    this.mapping = new Mapping();
                    if (pages != null) {
                        int i = 0;
                        while (i < pages.length) {
                            pages[i].encode(this.mapping);
                            ++i;
                        }
                    }
                    nameMap.put(this.name, this.mapping);
                }
            } else {
                this.mapping = (Mapping)entry;
            }
        }
    }

    public int[] toUnicode(int[] encodedValues) {
        return this.mapping.toUnicode(encodedValues);
    }

    public int[] fromUnicode(int[] unicodeValues) {
        return this.mapping.fromUnicode(unicodeValues);
    }

    public int canEncodeUpTo(String unicodeString) {
        int[] unicodeValues = new int[unicodeString.length()];
        int i = 0;
        while (i < unicodeValues.length) {
            unicodeValues[i] = unicodeString.charAt(i);
            ++i;
        }
        return this.mapping.canEncodeUpTo(unicodeValues);
    }

    public boolean canEncodeCharacter(char unicodeChar) {
        return this.mapping.canEncodeUpTo(new int[]{unicodeChar}) == -1;
    }

    private AbstractCodePage[] getCodePages() {
        AbstractCodePage[] pages = null;
        String[] pageRefs = this.getPageRefs();
        if (pageRefs != null) {
            pages = new AbstractCodePage[pageRefs.length];
            int i = 0;
            while (i < pageRefs.length) {
                pages[i] = this.instantiatePage(pageRefs[i]);
                ++i;
            }
        }
        return pages;
    }

    private AbstractCodePage instantiatePage(String suffix) {
        AbstractCodePage cp = null;
        String className = "com.maplesoft.util.encoder.codepage." + this.name + "Page" + suffix;
        try {
            Class<?> klass = Class.forName(className);
            cp = (AbstractCodePage)klass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            cp = null;
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            cp = null;
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            cp = null;
        }
        return cp;
    }

    public String getName() {
        return this.name;
    }

    public abstract String toUnicode(String var1);

    public abstract String fromUnicode(String var1);

    public abstract int getType();

    protected abstract String[] getPageRefs();

    public static String xmlEncode(String source) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char ch = source.charAt(i);
            if (ch > '\u007f' && ch <= '\u00ff' || ch == '\\') {
                result.append('\\');
                result.append(Integer.toOctalString(ch));
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String xmlDecode(String source) {
        StringBuffer result = new StringBuffer();
        int size = source.length();
        int i = 0;
        while (i < size) {
            char ch = source.charAt(i);
            if (i + 3 < size && ch == '\\' && Character.isDigit(source.charAt(i + 1)) && Character.isDigit(source.charAt(i + 2)) && Character.isDigit(source.charAt(i + 3))) {
                int value = (source.charAt(i + 1) - 48) * 64;
                value += (source.charAt(i + 2) - 48) * 8;
                result.append((char)(value += source.charAt(i + 3) - 48));
                i += 4;
                continue;
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    public static String xmlEncodeMWS(String source) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char ch = source.charAt(i);
            if (ch > '\u007f' && ch <= '\u00ff') {
                result.append('\\');
                result.append(Integer.toOctalString(ch));
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String rtfEncode(String source) {
        return AbstractStringEncoder.rtfEncode(source, source, false);
    }

    public static String rtfEncode(String source, String unicode, boolean doubleByte) {
        StringBuffer result = new StringBuffer();
        int size = source.length();
        int i = 0;
        boolean isoEncode = false;
        i = 0;
        while (i < size) {
            if (source.charAt(i) > '\u00ff') {
                isoEncode = true;
                break;
            }
            ++i;
        }
        if (isoEncode) {
            DefaultEncoder encoder = new DefaultEncoder();
            source = encoder.fromUnicode(source);
        }
        if (doubleByte) {
            boolean firstByte = true;
            int pos = 0;
            i = 0;
            while (i < size) {
                char ch = source.charAt(i);
                if (ch > '\u007f' || !firstByte) {
                    boolean isHalfWidth;
                    char unichar = unicode.charAt(pos);
                    boolean bl = isHalfWidth = '\uff66' <= unichar && unichar <= '\uff9f';
                    if (firstByte) {
                        if (!isHalfWidth) {
                            result.append("\\uc2\\u");
                        } else {
                            result.append("\\uc1\\u");
                            ++pos;
                        }
                        result.append((int)unichar);
                    } else {
                        ++pos;
                    }
                    result.append("\\'");
                    result.append(Integer.toHexString(ch));
                    if (!isHalfWidth) {
                        firstByte = !firstByte;
                    }
                } else {
                    result.append(ch);
                    ++pos;
                }
                ++i;
            }
        } else {
            result.append("\\uc1");
            i = 0;
            while (i < size) {
                char ch = source.charAt(i);
                if (ch > '\u007f') {
                    result.append("\\u");
                    result.append((int)ch);
                }
                result.append(ch);
                ++i;
            }
        }
        return result.toString();
    }

    private static class ArrayKey {
        private int[] theArray = null;

        public ArrayKey(int[] theArray) {
            this.theArray = theArray;
        }

        public ArrayKey(int anInteger) {
            int[] array = new int[]{anInteger};
            this.theArray = array;
        }

        public boolean equals(Object o) {
            boolean isEqual = false;
            if (!(!(o instanceof ArrayKey) || o == null && this.theArray != null || o != null && this.theArray == null)) {
                if (o == null && this.theArray == null) {
                    isEqual = true;
                } else {
                    int[] o2 = ((ArrayKey)o).getArray();
                    if (o2.length == this.theArray.length) {
                        isEqual = true;
                        int i = 0;
                        while (i < this.theArray.length) {
                            if (o2[i] != this.theArray[i]) {
                                isEqual = false;
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            return isEqual;
        }

        public int hashCode() {
            int result = 0;
            int i = 0;
            while (i < this.theArray.length) {
                result ^= this.theArray[i] * i;
                ++i;
            }
            return result;
        }

        public String toString() {
            if (this.theArray != null) {
                StringBuffer buf = new StringBuffer(this.theArray.length * 2);
                int i = 0;
                while (i < this.theArray.length) {
                    buf.append(Integer.toHexString(this.theArray[i]));
                    buf.append(' ');
                    ++i;
                }
                return buf.toString();
            }
            return null;
        }

        public int[] getArray() {
            return this.theArray;
        }
    }

    public static class Mapping {
        private int UNKNOWN_CHAR = 63;
        private int[][] toUnicodeMap = new int[256][];
        private int[][] fromUnicodeMap = new int[256][];
        private HashMap toUnicodeMultiMap = null;
        private HashMap fromUnicodeMultiMap = null;
        private int maxSequenceLength = 1;

        public void addMapping(int from, int to) {
            int fromLow = from & 0xFF;
            int fromHigh = from >> 8;
            int toLow = to & 0xFF;
            int toHigh = to >> 8;
            if (this.toUnicodeMap[fromHigh] == null) {
                this.toUnicodeMap[fromHigh] = new int[256];
                Arrays.fill(this.toUnicodeMap[fromHigh], -1);
            }
            if (this.fromUnicodeMap[toHigh] == null) {
                this.fromUnicodeMap[toHigh] = new int[256];
                Arrays.fill(this.fromUnicodeMap[toHigh], -1);
            }
            this.toUnicodeMap[fromHigh][fromLow] = to;
            this.fromUnicodeMap[toHigh][toLow] = from;
        }

        public void addMapping(int[] from, int[] to) {
            int[] ch;
            int[] row;
            if (this.toUnicodeMultiMap == null) {
                this.toUnicodeMultiMap = new HashMap();
                this.fromUnicodeMultiMap = new HashMap();
            }
            int fromHigh = from[0] >> 8;
            int toHigh = to[0] >> 8;
            if (this.toUnicodeMap[fromHigh] == null) {
                this.toUnicodeMap[fromHigh] = new int[256];
                Arrays.fill(this.toUnicodeMap[fromHigh], -1);
            }
            if (this.fromUnicodeMap[toHigh] == null) {
                this.fromUnicodeMap[toHigh] = new int[256];
                Arrays.fill(this.fromUnicodeMap[toHigh], -1);
            }
            if ((row = this.toUnicodeMap[fromHigh]) != null && (ch = new int[]{row[from[0] & 0xFF]})[0] != -1) {
                this.toUnicodeMap[fromHigh][from[0] & 0xFF] = -1;
                this.toUnicodeMultiMap.put(new ArrayKey(from[0]), ch);
            }
            if ((row = this.fromUnicodeMap[toHigh]) != null && (ch = new int[]{row[to[0] & 0xFF]})[0] != -1) {
                this.fromUnicodeMap[toHigh][to[0] & 0xFF] = -1;
                this.fromUnicodeMultiMap.put(new ArrayKey(to[0]), ch);
            }
            this.toUnicodeMultiMap.put(new ArrayKey(from), to);
            this.fromUnicodeMultiMap.put(new ArrayKey(to), from);
            if (to.length > this.maxSequenceLength) {
                this.maxSequenceLength = to.length;
            }
            if (from.length > this.maxSequenceLength) {
                this.maxSequenceLength = from.length;
            }
        }

        public int[] toUnicode(int[] value) {
            return this.lookup(value, this.toUnicodeMap, this.toUnicodeMultiMap, true);
        }

        public int[] fromUnicode(int[] value) {
            return this.lookup(value, this.fromUnicodeMap, this.fromUnicodeMultiMap, true);
        }

        public int canEncodeUpTo(int[] unicodeValue) {
            int[] r = this.lookup(unicodeValue, this.fromUnicodeMap, this.fromUnicodeMultiMap, false);
            return r[0];
        }

        private int[] lookup(int[] value, int[][] map, HashMap multiMap, boolean mapCharacters) {
            int[] array = null;
            if (multiMap == null) {
                array = mapCharacters ? new int[value.length] : new int[]{-1};
                int i = 0;
                while (i < value.length) {
                    int ch;
                    if (mapCharacters) {
                        array[i] = value[i];
                    }
                    int rowIndex = value[i] >> 8;
                    int[] row = map[rowIndex];
                    boolean found = false;
                    if (row != null && (ch = row[value[i] & 0xFF]) != -1) {
                        if (mapCharacters) {
                            array[i] = ch;
                        }
                        found = true;
                    }
                    if (!mapCharacters && !found) {
                        array[0] = i;
                        break;
                    }
                    ++i;
                }
            } else {
                Vector<Integer> returnValue = mapCharacters ? new Vector<Integer>(value.length) : null;
                int i = 0;
                while (i < value.length) {
                    int[] row = map[value[i] >> 8];
                    Integer valueThisIteration = null;
                    if (row != null) {
                        int ch = row[value[i] & 0xFF];
                        if (ch == -1 && this.maxSequenceLength > 1) {
                            int j = this.maxSequenceLength;
                            while (j > 0) {
                                if (i + j - 1 < value.length) {
                                    int[] key = new int[j];
                                    int k = 0;
                                    while (k < j) {
                                        key[k] = value[i + k];
                                        ++k;
                                    }
                                    int[] string = (int[])multiMap.get(new ArrayKey(key));
                                    if (string != null) {
                                        int l = 0;
                                        while (l < string.length) {
                                            returnValue.add(new Integer(string[l]));
                                            ++l;
                                        }
                                        i += key.length - 1;
                                        break;
                                    }
                                }
                                if (j == 1) {
                                    valueThisIteration = new Integer(value[i] > 127 ? this.UNKNOWN_CHAR : value[i]);
                                }
                                --j;
                            }
                        } else {
                            valueThisIteration = ch != -1 ? new Integer(ch) : new Integer(this.UNKNOWN_CHAR);
                        }
                    } else {
                        valueThisIteration = new Integer(value[i] > 127 ? this.UNKNOWN_CHAR : value[i]);
                    }
                    if (valueThisIteration != null) {
                        if (valueThisIteration != this.UNKNOWN_CHAR && mapCharacters) {
                            returnValue.add(valueThisIteration);
                        } else if (mapCharacters) {
                            returnValue.add(new Integer(this.UNKNOWN_CHAR));
                        } else {
                            array = new int[]{i};
                            break;
                        }
                    }
                    ++i;
                }
                if (array == null) {
                    if (mapCharacters) {
                        array = new int[returnValue.size()];
                        i = 0;
                        while (i < returnValue.size()) {
                            array[i] = (Integer)returnValue.get(i);
                            ++i;
                        }
                    } else {
                        array = new int[]{-1};
                    }
                }
            }
            return array;
        }
    }
}

