/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.codepage.AbstractCodePage;

public class DefaultEncoder
extends AbstractStringEncoder {
    private static final char PUNCTUATION_LOWER_BOUND = '\u2000';
    private static final char PUNCTUATION_UPPER_BOUND = '\u206f';
    private static final char ASCII8 = '\u00ff';
    private static final char[] MINUS = new char[]{'\u2010', '\u2012', '\u2013'};
    private static final char[] SINGLE_QUOTE = new char[]{'\u2018', '\u2019', '\u201b', '\u2032'};
    private static final char[] DOUBLE_QUOTE = new char[]{'\u201c', '\u201d', '\u201f', '\u2033', '\u2036'};
    private static final char[] MISC_MAPPING = new char[]{'\u2024', '.', '\u201a', ',', '\u2035', '`', '\u2039', '<', '\u203a', '>', '\u204e', '*', '\u2052', '%', '\u2053', '~', '\u2044', '/'};

    public DefaultEncoder() {
        super("iso8859-1");
    }

    @Override
    public String fromUnicode(String value) {
        boolean conversion = false;
        int size = value.length();
        char[] encoding = new char[size];
        int i = 0;
        while (i < size) {
            char ch = value.charAt(i);
            if (ch <= '\u00ff') {
                encoding[i] = ch;
            } else {
                conversion = true;
                if (ch >= '\u2000' && ch <= '\u206f') {
                    if (this.contains(MINUS, ch)) {
                        ch = '-';
                    } else if (this.contains(SINGLE_QUOTE, ch)) {
                        ch = '\'';
                    } else if (this.contains(DOUBLE_QUOTE, ch)) {
                        ch = '\"';
                    } else {
                        int j = 0;
                        while (j < MISC_MAPPING.length) {
                            if (ch == MISC_MAPPING[j]) {
                                ch = MISC_MAPPING[j + 1];
                                break;
                            }
                            j += 2;
                        }
                    }
                }
                encoding[i] = ch;
            }
            ++i;
        }
        return conversion ? new String(encoding) : value;
    }

    public boolean contains(char[] set, char value) {
        boolean found = false;
        int i = 0;
        while (i < set.length) {
            if (set[i] == value) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    protected AbstractCodePage[] getCodePages() {
        return null;
    }

    @Override
    public String toUnicode(String value) {
        return value;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    protected String[] getPageRefs() {
        return null;
    }
}

