/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.UnicodeEscapeEncoder;

public class KernelEncoder
extends AbstractStringEncoder {
    private static final boolean DEBUG_ENCODER = false;
    private static final String[] XML_PREFIXES = new String[]{"<?xml", "<application_communications", "\"<application_communications"};
    private AbstractStringEncoder encoder = null;

    public KernelEncoder(AbstractStringEncoder encoder) {
        super(null);
        this.encoder = encoder;
    }

    @Override
    protected void initialize() {
    }

    @Override
    public String toUnicode(String encodedString) {
        return this.toUnicode(encodedString, true);
    }

    @Override
    public String fromUnicode(String unicodeString) {
        return this.fromUnicode(unicodeString, true);
    }

    public String toUnicode(String encodedString, boolean removeBackquotes) {
        String before = encodedString;
        String after = this.process(encodedString, true, true);
        if (removeBackquotes && !this.isXML(after) && !before.equals(after)) {
            after = after.replaceAll("`", "");
        }
        return after;
    }

    public String fromUnicode(String unicodeString, boolean addBackquotes) {
        return this.process(unicodeString, false, addBackquotes);
    }

    private void encodeAndAppendString(StringBuffer source, StringBuffer dest) {
        int i = 0;
        while (i < source.length()) {
            this.encodeAndAppendCharacter(source.charAt(i), dest);
            ++i;
        }
    }

    private void encodeAndAppendCharacter(char character, StringBuffer sb) {
        if (character > '\u007f') {
            boolean appended = false;
            if (WmiMathEntityNameMapper.isMathEntity(character)) {
                appended = this.appendEntityNameIfExists(character, sb);
            }
            if (!appended) {
                if (this.canEncodeCharacter(character)) {
                    sb.append(this.encoder.fromUnicode(Character.toString(character)));
                    appended = true;
                } else {
                    sb.append("&#");
                    sb.append((int)character);
                    sb.append(";");
                }
            }
        } else {
            sb.append(character);
        }
    }

    private boolean appendEntityNameIfExists(char character, StringBuffer buffy) {
        boolean exists = false;
        String name = WmiMathEntityNameMapper.getEntityName(character);
        if (name != null) {
            buffy.append("&");
            buffy.append(name);
            buffy.append(";");
            exists = true;
        }
        return exists;
    }

    @Override
    public boolean canEncodeCharacter(char unicodeChar) {
        return this.encoder.canEncodeCharacter(unicodeChar);
    }

    @Override
    public int canEncodeUpTo(String unicodeString) {
        return this.encoder.canEncodeUpTo(unicodeString);
    }

    private boolean isXML(String string) {
        boolean isXML = false;
        if (string != null && string.length() > 0) {
            int i = 0;
            while (i < XML_PREFIXES.length) {
                if (string.startsWith(XML_PREFIXES[i])) {
                    isXML = true;
                    break;
                }
                ++i;
            }
        }
        return isXML;
    }

    private String process(String string, boolean toUnicode, boolean addBackquotes) {
        StringBuffer outerValue = new StringBuffer();
        if (string != null && string.length() > 0) {
            if (toUnicode) {
                if (this.encoder != null) {
                    string = this.encoder.toUnicode(string);
                }
                string = UnicodeEscapeEncoder.convertEscapeSequenceToUnicode(string, false);
            }
            boolean inIdentifier = this.isPartOfIdentifier(string.charAt(0));
            boolean isXML = this.isXML(string);
            boolean inString = false;
            boolean inBackQuote = false;
            boolean inSingleQuote = false;
            boolean escaped = false;
            int i = 0;
            StringBuffer buffy = new StringBuffer();
            while (i < string.length()) {
                buffy.setLength(0);
                boolean needBackQuote = false;
                while (i < string.length()) {
                    char c = string.charAt(i);
                    if (inIdentifier != this.isPartOfIdentifier(c)) {
                        inIdentifier = !inIdentifier;
                        break;
                    }
                    if (escaped) {
                        escaped = false;
                    } else if (!isXML) {
                        if (c == '\\') {
                            escaped = true;
                        } else if (c == '\"' && !inBackQuote && !inSingleQuote) {
                            inString = !inString;
                        } else if (c == '`' && !inString && !inSingleQuote) {
                            inBackQuote = !inBackQuote;
                        } else if (c == '\'' && !inString && !inBackQuote) {
                            inSingleQuote = !inSingleQuote;
                        }
                    }
                    buffy.append(c);
                    if (addBackquotes && c > '\u007f') {
                        needBackQuote = !isXML && !inString && !inBackQuote && !inSingleQuote;
                    }
                    ++i;
                }
                if (needBackQuote) {
                    outerValue.append('`');
                }
                if (toUnicode || this.encoder == null) {
                    outerValue.append(buffy);
                } else {
                    this.encodeAndAppendString(buffy, outerValue);
                }
                if (!needBackQuote) continue;
                outerValue.append('`');
            }
        }
        return outerValue.toString();
    }

    private static void printAsInt(String s) {
        int i = 0;
        while (i < s.length()) {
            System.out.print(s.charAt(i));
            System.out.print('(');
            System.out.print((int)s.charAt(i));
            System.out.print(") ");
            ++i;
        }
        System.out.println();
    }

    private boolean isPartOfIdentifier(char c) {
        boolean isId = true;
        if (c < '\u007f') {
            isId = Character.isLetterOrDigit(c) || c == '_';
        }
        return isId;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    protected String[] getPageRefs() {
        return null;
    }
}

