/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.AbstractStringEncoder;

public class UTF8Encoder
extends AbstractStringEncoder {
    public UTF8Encoder() {
        super("UTF-8");
    }

    @Override
    protected void initialize() {
    }

    @Override
    public int[] fromUnicode(int[] unicodeValues) {
        String s = this.intArrayToString(unicodeValues);
        s = this.fromUnicode(s);
        return this.stringToIntArray(s);
    }

    @Override
    public int[] toUnicode(int[] encodedValues) {
        String s = this.intArrayToString(encodedValues);
        s = this.toUnicode(s);
        return this.stringToIntArray(s);
    }

    private int[] stringToIntArray(String s) {
        int[] i = new int[s.length()];
        int j = 0;
        while (j < i.length) {
            i[j] = s.charAt(j);
            ++j;
        }
        return i;
    }

    private String intArrayToString(int[] array) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            b.append((char)array[i]);
            ++i;
        }
        return b.toString();
    }

    @Override
    public String fromUnicode(String value) {
        return UTF8Encoder.convertUnicodeToUtf8(value);
    }

    @Override
    public String toUnicode(String value) {
        return UTF8Encoder.convertUtf8ToUnicode(value);
    }

    @Override
    public boolean canEncodeCharacter(char unicodeChar) {
        return true;
    }

    @Override
    public int canEncodeUpTo(String unicodeString) {
        return -1;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    protected String[] getPageRefs() {
        return null;
    }

    public static String convertUtf8ToUnicode(String value) {
        String conversion = null;
        if (value != null) {
            try {
                byte[] source = value.getBytes("ISO8859-1");
                conversion = new String(source, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return conversion;
    }

    public static String convertUnicodeToUtf8(String value) {
        byte[] conversion = null;
        String reply = null;
        if (value != null) {
            try {
                conversion = value.getBytes("UTF-8");
                reply = new String(conversion, "ISO8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reply;
    }
}

