package applets;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageUtilities {
	public static final String bundleLocation = "AppletResources"; 

	// method that finds the value of a key in the bundle
	public static String getMessage(Locale mtaLocale, String key) {
		ResourceBundle bundle;
				
		bundle = ResourceBundle.getBundle(bundleLocation, mtaLocale);
		
		String message = "%" + key + "%";
		
		try {
			return bundle.getString(key);
		} catch (Exception e) {
            e.printStackTrace();
		}
		
		return message;
	}

	// method that finds value of key in bundle, filling in placeholders with parameters
	public static String getMessage(Locale mtaLocale, String key,
			Object... arguments) {
		
		ResourceBundle bundle;
				
		bundle = ResourceBundle.getBundle(bundleLocation, mtaLocale);

		String message = "%" + key + "%";
		
		try {
            String s = (String) bundle.getString(key);
            return MessageFormat.format(s, arguments);
            
		} catch (Exception e) {
            e.printStackTrace();
		}
		
		return message;
	}
	
	
	/*
	public static String getMessage(String key, Object ... params) {
		String message = "";
		message = MessageFormat.format(bundle.getString(key), params);
		return message;
	}
	*/

}
