package applets.proctoredTest;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.util.Formatter;
import java.util.Locale;

import javax.swing.JApplet;
import javax.swing.JLabel;

import applets.util.WarningDialog;

public class Timer extends JApplet implements Runnable {

	private static final long	serialVersionUID	= 845228335797500677L;

	/* The user's session locale. Initialize to en_US, update in init() method */
	Locale mtaLocale = new Locale("en", "US");
	
	/* Time stamp (s) that represents the remaining time this user has */
	private long remainingTime;

	/**
	 * We need a Frame to link Dialogs to. This should never be shown.
	 */
	Frame holderFrame = new Frame();
	private String	displayCountdown = "";
	private JLabel theLabel1 = new JLabel("", JLabel.RIGHT);
	private JLabel theLabel2 = new JLabel("", JLabel.RIGHT);

	private boolean timeToDie;
	
	public void destroy() {
		System.out.println("-- destroy() was called.");
		timeToDie = true;

		this.holderFrame.dispose();
		this.holderFrame = null;
	}

	public void init() {

		String[] locale;
		
		try
		{
			locale = getParameter("mtalocale").split("_");
		}
		catch (Exception e)
		{
			locale = "en_US".split("_");
		}
		
		if (locale.length==1)
			mtaLocale = new Locale(locale[0]);
		else if (locale.length==2)
			mtaLocale = new Locale(locale[0], locale[1]);
		else if (locale.length==3)
			mtaLocale = new Locale(locale[0], locale[1], locale[2]);
		
		/* Time currently remining, in seconds. */
		remainingTime = Long.parseLong(getParameter("remainingTime"));

		// Set the colors
		setBackground(Color.white);
		
		setForeground(new Color(0x1D, 0x36, 0x68));
		setLayout(new BorderLayout());

		// Set the font
		setFont(new Font("SansSerif", Font.PLAIN, 10));
//		theLabel.setFont(new Font("SansSerif", Font.PLAIN, 10));
		theLabel1.setOpaque(true);
		theLabel2.setOpaque(true);

		theLabel1.setBackground(Color.white);
		theLabel2.setBackground(Color.white);
		
		if (remainingTime < 300) {
			theLabel2.setForeground(new Color(0x77,0,0));
		}

		String displayCountdownLabel  =   
			applets.MessageUtilities.getMessage(mtaLocale, "Common.RemainingTime.Label");

		theLabel1.setText(displayCountdownLabel);
		
		
		add(theLabel1, BorderLayout.CENTER);
		add(theLabel2, BorderLayout.EAST);
		
		timeToDie = false;
		
		new Thread(this).start();
	}

	/**
	 * @return
	 */
	private int getSeconds(long time) {

		int secNum = (int) (time % 3600) % 60;
		return secNum;
	}

	/**
	 * @return
	 */
	private int getMinutes(long time) {

		int minNum = (int) (time % 3600) / 60 ;
		return minNum;
	}

	/**
	 * @return
	 */
	private int getHours(long time) {

		int hourNum = (int) (time / 3600);
		return hourNum;
	}
	
	public void run() {
		String fiveMinutesMessage = applets.MessageUtilities.getMessage(mtaLocale,"Timer.FiveMinutesMessage");
		String expiredMessage = applets.MessageUtilities.getMessage(mtaLocale,"Timer.ExpiredMessage");
		
		while (!timeToDie) {

			int hours = getHours(remainingTime);
			int mins = getMinutes(remainingTime);
			int secs = getSeconds(remainingTime);

			Formatter formatter = new Formatter();

			displayCountdown  = formatter.format(" %1$02d:%2$02d:%3$02d", hours, mins,secs).toString();

			theLabel2.setText(displayCountdown);
			
			repaint();

			if (remainingTime == 300) {
				new WarningDialog(holderFrame, fiveMinutesMessage, mtaLocale).setVisible(true);
				theLabel2.setForeground(new Color(0x77,0,0));
			} else if (remainingTime == 0) {
				new WarningDialog(holderFrame, expiredMessage, mtaLocale).setVisible(true);
				break;
			}
			
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				System.out.println("-- run() was interrupted.");
				break;
			}

			remainingTime -= 1;
		}
		System.out.println("-- Exiting from run().");
	}

}
