package applets.sliderBall;

import java.applet.*;
import java.awt.*;

public class SliderBall
  extends Applet
{
	final private static Color RULER_COLOR = new Color(202, 182, 110);
	final private static Color RULER_WHISKER_COLOR = Color.black;
	final private static int RULER_WIDTH = 20;
	final private static int RULER_MAX = 45;
	final private static int BALL_SIZE = 20;
	final private static int LEFT_BALL_MARGIN = RULER_WIDTH + 10;
	private int leftBallHeight = 50;
	final private static int RIGHT_BALL_MARGIN = RULER_WIDTH + BALL_SIZE + 20;
	private int rightBallHeight = 80;
	private boolean draggingRightBall = false;
	private int draggingRightBallOffset = 0;
	final private static Color MARKER_COLOR = Color.green;
	final private static int MARKER_WIDTH = 10;
	final private static int MARKER_HEIGHT = 4;
	private Image offscreen;
	private Image rightBallImage;
	private Image leftBallImage;
	private boolean locked;
	final private static Color MARKER_BORDER_COLOR = Color.black;

public int fromPixels(int y) {
	double a = RULER_MAX * (size().height - y - BALL_SIZE/2);
	double b = size().height;
	
	return (int) (a/b + 0.5);
}

public String getResponse() {

	return "" + fromPixels(rightBallHeight);
}

public void init() {
	readParameters();
	setBackground(Color.white);
	offscreen = createImage(size().width, size().height);
	rightBallImage = getImage(getCodeBase(), "applets/sliderBall/red_ball.gif");
	leftBallImage = getImage(getCodeBase(), "applets/sliderBall/purple_ball.gif");
}

private boolean isInRightBall(int x, int y) {
	return (x > RIGHT_BALL_MARGIN && x < RIGHT_BALL_MARGIN + BALL_SIZE && 
	        y > rightBallHeight && y < rightBallHeight + BALL_SIZE);
}

public boolean mouseDown(Event e, int x, int y) {
	if (!locked && isInRightBall(x, y)) {
		draggingRightBall = true;
		draggingRightBallOffset = y - rightBallHeight;
	}
	return true;
}

public boolean mouseDrag(Event e, int x, int y) {
	if (draggingRightBall) {
		rightBallHeight = y - draggingRightBallOffset;
		repaint();
	}
	return true;
}

public boolean mouseExit(Event e, int x, int y) {
	return mouseUp(e, x, y);
}

public boolean mouseUp(Event e, int x, int y) {
	draggingRightBall = false;
	return true;
}

public void paint(Graphics g) {
	
	Graphics gr = offscreen.getGraphics();
	
	gr.setColor(getBackground());
	gr.fillRect(0,0,size().width, size().height);
	
	paintRuler(gr);
	paintLeftBall(gr);
	paintRightBall(gr);
	
	g.drawImage(offscreen, 0, 0, this);
}

private void paintLeftBall(Graphics g) {
	g.drawImage(leftBallImage, LEFT_BALL_MARGIN, leftBallHeight, BALL_SIZE, BALL_SIZE, this);
	paintMarker(g, leftBallHeight + BALL_SIZE/2);
}

private void paintMarker(Graphics g, int y) {
	
	Polygon p = new Polygon();
	p.addPoint(RULER_WIDTH - MARKER_WIDTH, y - MARKER_HEIGHT); 
	p.addPoint(RULER_WIDTH - MARKER_WIDTH, y + MARKER_HEIGHT);
	p.addPoint(RULER_WIDTH, y);
	
	g.setColor(MARKER_COLOR);
	g.fillPolygon(p);
	g.setColor(MARKER_BORDER_COLOR);
	g.drawPolygon(p);
}

private void paintRightBall(Graphics g) {
	g.drawImage(rightBallImage, RIGHT_BALL_MARGIN, rightBallHeight, BALL_SIZE, BALL_SIZE, this);
	paintMarker(g, rightBallHeight + BALL_SIZE/2);
}

private void paintRuler(Graphics g) {

	g.setColor(RULER_COLOR);
	g.fillRect(0,0,RULER_WIDTH + 1,size().height);
	
	// Draw scale
	g.setColor(RULER_WHISKER_COLOR);
	double step = ((double) size().height)/RULER_MAX;
	
	for (int i=1; i<=RULER_MAX; i++) {
		int rwidth;
		int h = (int) (size().height - i*step);
		
		if (i % 10 == 0) {
			Font f = new Font("Helvetica", Font.PLAIN, 8);
			FontMetrics fm = g.getFontMetrics(f);
			int fheight = fm.getAscent();
			
			g.setFont(f);
			g.drawString("" + i, RULER_WIDTH + 2, h + fheight/2);
			
			rwidth = RULER_WIDTH;
			
		} else if (i % 5 == 0) {
			rwidth = RULER_WIDTH/2;
		} else {
			rwidth = RULER_WIDTH/4;
		}
		g.drawLine(RULER_WIDTH - rwidth, h, RULER_WIDTH, h); 
	}
}

private void readParameters() {

	try {
		rightBallHeight = toPixels((int)Double.valueOf(getParameter("right")).doubleValue());
		leftBallHeight = toPixels((int)Double.valueOf(getParameter("left")).doubleValue());
	} catch (Exception e) { }
	
	try {
		String response = getParameter("response");
		
		if (response != null && response.length() > 0) {
			rightBallHeight = toPixels((int)Double.valueOf(response).doubleValue());
		}
	} catch (Exception e) { }
	
	locked = "true".equals(getParameter("locked"));
}

private int toPixels(int v) {
	return (size().height * (RULER_MAX - v))/RULER_MAX - BALL_SIZE/2;
}

public void update(Graphics g) {

	paint(g);
}
}
