package applets.slidingLayers;

import java.awt.*;
import java.awt.image.ImageObserver;
import java.util.StringTokenizer;

class Layer
{
	private boolean selected;
	private Image img;
	private int pos_x;
	private int pos_y;
	private int offset_x;
	private int offset_y;
	private SlidingLayers obs;
	final private static int HANDLE_HEIGHT = 10;
	final private static int HANDLE_WIDTH = 20;
	private Rectangle handle;

Layer(Image img, int x, int y, SlidingLayers obs) {
	this.img = img;
	handle = new Rectangle(x, y, HANDLE_WIDTH, HANDLE_HEIGHT);
	this.obs = obs;
}

int getPosX() { return pos_x; }

int getPosY() { return pos_y; }

public boolean isSelected() { return selected; }

public boolean mouseDown(Event e, int x, int y) {
	offset_x = x - pos_x;
	offset_y = y - pos_y;
	
	if (handle.contains(offset_x, offset_y)) {
	
		selected = true;
		return true;
	} else {
		return false;
	}
}

void move(int x, int y) {
	pos_x = x - offset_x;
	pos_y = y - offset_y;
}

public void paint(Graphics g) {
	g.drawImage(img, pos_x, pos_y, obs);
	
	if (! obs.isLocked) {
	    g.drawImage(selected ? obs.activeHandle : obs.inactiveHandle, pos_x + handle.x, pos_y + handle.y, obs);
	}
}

public void setSelected(boolean s) { 
	selected = s;
}
}

public class SlidingLayers
  extends java.applet.Applet
{
	private Image offscreen;
	private Layer[] layers;
	private Image background;
	Image inactiveHandle;
	Image activeHandle;
	boolean isLocked;

public String getResponse() {
	StringBuffer sb = new StringBuffer(64);
	
	for (int i=0; i<layers.length; i++) {
		if (i > 0) {
			sb.append("; ");
		}
		sb.append("(");
		sb.append(layers[i].getPosX());
		sb.append(",");
		sb.append(layers[i].getPosY());
		sb.append(")");
	}
	return sb.toString();
}

public void init() {
	offscreen = createImage(size().width, size().height);
	inactiveHandle = getImage(getCodeBase(), "applets/slidingLayers/inactive_handle.gif");
	activeHandle = getImage(getCodeBase(), "applets/slidingLayers/active_handle.gif");
	
	int size = Integer.parseInt(getParameter("size"));
	layers = new Layer[size];
	
	for (int i=1; i <= size; i++) {
		Image img = getImage(getCodeBase(), getParameter("layer." + i + ".image"));
		int x = Integer.parseInt(getParameter("layer." + i + ".anchor.x"));
		int y = Integer.parseInt(getParameter("layer." + i + ".anchor.y"));
		int hnd_x = Integer.parseInt(getParameter("layer." + i + ".handle.x"));
		int hnd_y = Integer.parseInt(getParameter("layer." + i + ".handle.y"));
		Layer l = new Layer(img, hnd_x, hnd_y, this);
		layers[i-1] = l;
		l.move(x,y);
	}
	background = getImage(getCodeBase(), getParameter("background.image"));
	
	isLocked = "true".equals(getParameter("locked"));
	
	if (getParameter("response") != null) {
	    Point[] responsePositions = getPointList(getParameter("response"));

	    for (int i=0; i<responsePositions.length; i++) {
		layers[i].move(responsePositions[i].x, responsePositions[i].y);
	    }
	}
}

    private Point[] getPointList(String text) {
	StringTokenizer stz = new StringTokenizer(text, ";");
	Point[] list = new Point[stz.countTokens()];

	for (int i=0; i<list.length; i++) {
	    list[i] = parsePoint(stz.nextToken());
	}
	return list;   
    }

    private Point parsePoint(String text){
	text = text.trim();

	int commaPos = text.indexOf(',');
	int x = Integer.parseInt(text.substring(1, commaPos).trim());
 	int y = Integer.parseInt(text.substring(commaPos + 1, text.length() - 1).trim());
	
	return new Point(x, y);
    }

public boolean mouseDown(Event e, int x, int y) {
	
    if (isLocked) return true;

	for (int i=layers.length - 1; i>=0; i--) {
		if (layers[i].mouseDown(e, x, y)) {
			repaint();
			break;
		}
	}
	return true;
}

public boolean mouseDrag(Event e, int x, int y) {
	
	if (x < 0) {
		x = 0;
	}
	
	if (y < 0) {
		y = 0;
	}
	
	if (x > size().width) {
		x = size().width;
	}
	
	if (y > size().height) {
		y = size().height;
	}
	
	for (int i=0; i<layers.length; i++) {
		Layer l = layers[i];
		
		if (l.isSelected()) {
			l.move(x, y);
			repaint();
			break;
		}
	}
	return true;
}

public boolean mouseUp(Event e, int x, int y) {
	releaseAll();
	return true;
}

public void paint(Graphics g) {
	Graphics gr = offscreen.getGraphics();
	gr.setColor(getBackground());
	gr.fillRect(0,0,size().width, size().height);
	gr.drawImage(background, 0, 0, this);
	
	for (int i=0; i<layers.length; i++) {
		layers[i].paint(gr);
	}
	g.drawImage(offscreen, 0, 0, this);
}

private void releaseAll() {
	
	for (int i=0; i<layers.length; i++) {
		layers[i].setSelected(false);
	}
	repaint();
}

public void update(Graphics g) {
	paint(g);
}

}
